/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiException;

public class HandlerCollection
extends AbstractHandlerContainer {
    private final boolean _mutableWhenRunning;
    private volatile Handler[] _handlers;
    private boolean _parallelStart = false;

    public HandlerCollection() {
        this._mutableWhenRunning = false;
    }

    public HandlerCollection(boolean mutableWhenRunning) {
        this._mutableWhenRunning = mutableWhenRunning;
    }

    @Override
    public Handler[] getHandlers() {
        return this._handlers;
    }

    public void setHandlers(Handler[] handlers) {
        int i2;
        if (!this._mutableWhenRunning && this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        Object[] old_handlers = this._handlers == null ? null : (Handler[])this._handlers.clone();
        this._handlers = handlers;
        Server server = this.getServer();
        MultiException mex = new MultiException();
        for (i2 = 0; handlers != null && i2 < handlers.length; ++i2) {
            if (handlers[i2].getServer() == server) continue;
            handlers[i2].setServer(server);
        }
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, old_handlers, handlers, "handler");
        }
        for (i2 = 0; old_handlers != null && i2 < old_handlers.length; ++i2) {
            if (old_handlers[i2] == null) continue;
            try {
                if (!old_handlers[i2].isStarted()) continue;
                old_handlers[i2].stop();
                continue;
            }
            catch (Throwable e2) {
                mex.add(e2);
            }
        }
        mex.ifExceptionThrowRuntime();
    }

    public boolean isParallelStart() {
        return this._parallelStart;
    }

    public void setParallelStart(boolean parallelStart) {
        this._parallelStart = parallelStart;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this._handlers != null && this.isStarted()) {
            MultiException mex = null;
            for (int i2 = 0; i2 < this._handlers.length; ++i2) {
                try {
                    this._handlers[i2].handle(target, baseRequest, request, response);
                    continue;
                }
                catch (IOException e2) {
                    throw e2;
                }
                catch (RuntimeException e3) {
                    throw e3;
                }
                catch (Exception e4) {
                    if (mex == null) {
                        mex = new MultiException();
                    }
                    mex.add(e4);
                }
            }
            if (mex != null) {
                if (mex.size() == 1) {
                    throw new ServletException(mex.getThrowable(0));
                }
                throw new ServletException(mex);
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        final MultiException mex = new MultiException();
        if (this._handlers != null) {
            if (this._parallelStart) {
                final CountDownLatch latch = new CountDownLatch(this._handlers.length);
                final ClassLoader loader = Thread.currentThread().getContextClassLoader();
                int i2 = 0;
                while (i2 < this._handlers.length) {
                    final int h2 = i2++;
                    this.getServer().getThreadPool().dispatch(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            ClassLoader orig = Thread.currentThread().getContextClassLoader();
                            try {
                                Thread.currentThread().setContextClassLoader(loader);
                                HandlerCollection.this._handlers[h2].start();
                            }
                            catch (Throwable e2) {
                                mex.add(e2);
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(orig);
                                latch.countDown();
                            }
                        }
                    });
                }
                latch.await();
            } else {
                for (int i3 = 0; i3 < this._handlers.length; ++i3) {
                    try {
                        this._handlers[i3].start();
                        continue;
                    }
                    catch (Throwable e2) {
                        mex.add(e2);
                    }
                }
            }
        }
        super.doStart();
        mex.ifExceptionThrow();
    }

    @Override
    protected void doStop() throws Exception {
        MultiException mex = new MultiException();
        try {
            super.doStop();
        }
        catch (Throwable e2) {
            mex.add(e2);
        }
        if (this._handlers != null) {
            int i2 = this._handlers.length;
            while (i2-- > 0) {
                try {
                    this._handlers[i2].stop();
                }
                catch (Throwable e3) {
                    mex.add(e3);
                }
            }
        }
        mex.ifExceptionThrow();
    }

    @Override
    public void setServer(Server server) {
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        Server old_server = this.getServer();
        super.setServer(server);
        Handler[] h2 = this.getHandlers();
        for (int i2 = 0; h2 != null && i2 < h2.length; ++i2) {
            h2[i2].setServer(server);
        }
        if (server != null && server != old_server) {
            server.getContainer().update((Object)this, null, this._handlers, "handler");
        }
    }

    public void addHandler(Handler handler) {
        this.setHandlers(LazyList.addToArray(this.getHandlers(), handler, Handler.class));
    }

    public void removeHandler(Handler handler) {
        Handler[] handlers = this.getHandlers();
        if (handlers != null && handlers.length > 0) {
            this.setHandlers(LazyList.removeFromArray(handlers, handler));
        }
    }

    protected Object expandChildren(Object list, Class byClass) {
        Handler[] handlers = this.getHandlers();
        for (int i2 = 0; handlers != null && i2 < handlers.length; ++i2) {
            list = this.expandHandler(handlers[i2], list, byClass);
        }
        return list;
    }

    @Override
    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        Handler[] children = this.getChildHandlers();
        this.setHandlers(null);
        for (Handler child : children) {
            child.destroy();
        }
        super.destroy();
    }
}

