/*
 * Decompiled with CFR 0.152.
 */
package ice.net.proxy;

import ice.net.Authentication;
import ice.net.Indirect;
import java.io.Serializable;

public class Proxy
extends Indirect
implements Serializable {
    private Authentication authentication;
    private String protocol;
    private boolean tunneling;

    public Proxy(String string) throws IllegalArgumentException {
        this("http", string, 80, false);
    }

    public Proxy(String string, int n) throws IllegalArgumentException {
        this("http", string, n, false);
    }

    public Proxy(String string, String string2, int n) throws IllegalArgumentException {
        this(string, string2, n, false);
    }

    public Proxy(String string, String string2, int n, boolean bl) throws IllegalArgumentException {
        super(string2, n);
        this.checkProtocol(string);
        this.protocol = string.trim().toLowerCase();
        this.tunneling = bl;
    }

    public Proxy(String string, int n, String string2) {
        this(string2, string, n);
    }

    public Proxy(String string, int n, String string2, boolean bl) {
        this(string2, string, n, bl);
    }

    public boolean equals(Object object) {
        if (object instanceof Proxy) {
            return super.equals(object) && this.protocol.equals(((Proxy)object).getProtocol()) && this.tunneling == ((Proxy)object).isTunneling() && this.authentication != null ? this.authentication.equals(((Proxy)object).getAuthentication()) : ((Proxy)object).getAuthentication() == null;
        }
        return false;
    }

    public final Authentication getAuthentication() {
        return this.authentication;
    }

    public final String getProtocol() {
        return this.protocol;
    }

    public Authentication getProxyAuthentication() {
        return this.getAuthentication();
    }

    public final boolean isTunneling() {
        return this.tunneling;
    }

    public final void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public void setProxyAuthentication(Authentication authentication) {
        this.setAuthentication(authentication);
    }

    public String toString() {
        return "Proxy [host: " + this.getHost() + ", " + "port: " + this.getPort() + "]";
    }

    protected final void checkProtocol(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("protocol is null");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("protocol is empty");
        }
    }
}

