/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.datamgr.brushing;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.widgets.spreadsheet.color.ColorTableModel;
import java.awt.Color;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BrushTableModel
implements ColorTableModel {
    public BrushTableCache fBrushTableCache = new BrushTableCache();
    public Vector<ChangeListener> fChangeListeners = new Vector();
    public String fVarName;

    public BrushTableModel() {
    }

    public BrushTableModel(String string) {
        this.fVarName = string;
    }

    private static boolean[] createEmptyCache(int n, int n2) {
        boolean[] blArray = new boolean[n * n2];
        for (int i = 0; i < n * n2; ++i) {
            blArray[i] = false;
        }
        return blArray;
    }

    public void addColorTableModelListener(ChangeListener changeListener) {
        this.fChangeListeners.add(changeListener);
    }

    public Color getColorAt(int n, int n2) {
        if (this.fBrushTableCache.getValueAt(n, n2)) {
            return this.fBrushTableCache.getColor();
        }
        return null;
    }

    public void fireColorChangeListeners() {
        for (int i = 0; i < this.fChangeListeners.size(); ++i) {
            this.fChangeListeners.elementAt(i).stateChanged(new ChangeEvent(this));
        }
    }

    public void clearCache() {
        this.fBrushTableCache.rebuildCache();
    }

    public void removeColorTableModelListener(ChangeListener changeListener) {
        this.fChangeListeners.remove(changeListener);
    }

    private class BrushTableCache {
        private int MINROWCOUNT = 50;
        private int MINCOLUMNCOUNT = 50;
        private int fTopRow;
        private int fTopColumn;
        private boolean fTopLeftCell = false;
        private boolean[] fCache;
        private int fNumCols;
        private Color fColor;
        private MatlabWorker fMatlabCacheRebuilder = new MatlabCacheRebuilder();

        public BrushTableCache() {
            this.fCache = new boolean[this.MINROWCOUNT * 2 * this.MINCOLUMNCOUNT * 2];
        }

        private boolean isCachedCell(int n, int n2) {
            if (this.fCache == null) {
                return false;
            }
            if (n == 0 && n2 == 0) {
                return true;
            }
            boolean bl = n >= this.fTopRow && n <= this.fTopRow + 2 * this.MINROWCOUNT;
            boolean bl2 = n2 >= this.fTopColumn && n2 <= this.fTopColumn + 2 * this.MINCOLUMNCOUNT;
            return bl && bl2;
        }

        private boolean getCacheValueAt(int n, int n2) {
            if (this.fCache == null || this.fNumCols <= 0) {
                return false;
            }
            if (n == 0 && n2 == 0) {
                return this.fTopLeftCell;
            }
            int n3 = this.fCache.length / this.fNumCols;
            if (n >= this.fTopRow && n < this.fTopRow + n3 && n2 >= this.fTopColumn && n2 < this.fTopColumn + this.fNumCols && n - this.fTopRow < n3) {
                return this.fCache[n - this.fTopRow + (n2 - this.fTopColumn) * n3];
            }
            return false;
        }

        public void rebuildCache(int n, int n2) {
            this.fTopRow = n;
            this.fTopColumn = n2;
            this.rebuildCache();
        }

        public void rebuildCache() {
            this.fMatlabCacheRebuilder.start();
        }

        public boolean getValueAt(int n, int n2) {
            if (this.isCachedCell(n, n2)) {
                return this.getCacheValueAt(n, n2);
            }
            this.rebuildCache(n - this.MINROWCOUNT < 0 ? 0 : n - this.MINROWCOUNT, n2 - this.MINCOLUMNCOUNT < 0 ? 0 : n2 - this.MINCOLUMNCOUNT);
            return false;
        }

        public Color getColor() {
            return this.fColor;
        }

        static /* synthetic */ boolean[] access$102(BrushTableCache brushTableCache, boolean[] blArray) {
            brushTableCache.fCache = blArray;
            return blArray;
        }

        private class MatlabCacheRebuilder
        extends MatlabWorker {
            private MatlabCacheRebuilder() {
            }

            public void runOnAWTEventDispatchThread(Object object) {
                if (object == null) {
                    BrushTableCache.access$102(BrushTableCache.this, new boolean[BrushTableCache.this.MINROWCOUNT * 2 * BrushTableCache.this.MINCOLUMNCOUNT * 2]);
                    BrushTableCache.this.fTopLeftCell = false;
                    BrushTableCache.this.fNumCols = BrushTableCache.this.MINCOLUMNCOUNT * 2;
                    return;
                }
                Object[] objectArray = (Object[])object;
                if (!(objectArray.length > 2 && objectArray[0] instanceof Boolean && objectArray[1] instanceof boolean[] && objectArray[2] instanceof double[] && objectArray[3] instanceof Color)) {
                    BrushTableCache.access$102(BrushTableCache.this, null);
                    BrushTableCache.this.fTopLeftCell = false;
                    BrushTableCache.this.fNumCols = 0;
                    return;
                }
                Boolean bl = (Boolean)objectArray[0];
                boolean[] blArray = (boolean[])objectArray[1];
                double[] dArray = (double[])objectArray[2];
                int n = (int)dArray[0];
                Color color = (Color)objectArray[3];
                if (bl.equals(BrushTableCache.this.fTopLeftCell) && Arrays.equals(blArray, BrushTableCache.this.fCache) && n == BrushTableCache.this.fNumCols && color.equals(BrushTableCache.this.fColor)) {
                    return;
                }
                BrushTableCache.this.fTopLeftCell = bl;
                BrushTableCache.access$102(BrushTableCache.this, blArray);
                BrushTableCache.this.fNumCols = n;
                BrushTableCache.this.fColor = color;
                BrushTableModel.this.fireColorChangeListeners();
            }

            public Object runOnMatlabThread() {
                Object[] objectArray = new Object[]{BrushTableModel.this.fVarName, BrushTableCache.this.fTopRow, BrushTableCache.this.fTopColumn, BrushTableCache.this.MINROWCOUNT, BrushTableCache.this.MINCOLUMNCOUNT};
                try {
                    return Matlab.mtFeval((String)"datamanager.getArrayEditorBrushCache", (Object[])objectArray, (int)4);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
    }
}

