/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.datamgr.linkedplots;

import com.mathworks.hg.peer.HeavyweightLightweightContainerFactory;
import com.mathworks.hg.peer.TransparentPanel;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.page.datamgr.linkedplots.HyperLinkLabel;
import com.mathworks.page.datamgr.linkedplots.LegendEntry;
import com.mathworks.page.datamgr.linkedplots.TwistOpenList;
import com.mathworks.page.plottool.plotbrowser.ChartObjectProxyFactory;
import com.mathworks.util.Log;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class LinkPlotPanel
extends MJPanel {
    private static int LINKED_GRAPHICS = 2;
    private static int UNLINKED_GRAPHICS = 1;
    private static int NO_GRAPHICS = 0;
    private MJPanel fClickHerePanel;
    private TwistOpenList fLegendTwistOpenList;
    private HyperLinkLabel fEditLabel = new HyperLinkLabel();
    private HyperLinkLabel fNoDataSourceLbl = new HyperLinkLabel();
    private MJPanel fLegendPanel;
    private MJButton fMinimizeButton;
    private Object fFigure;
    private MJLabel fErrorLabel;
    private MJPanel fNoDataSource;
    private MJPanel fEditButtonPanel;
    private DisplacedBorderLayout fDisplacedBorderLayout = new DisplacedBorderLayout();
    private int fIncrement = 2;
    private Timer fAnimationTimer;
    private static final String resStr = "com.mathworks.page.datamgr.resources.RES_LinkedPlots";
    private static final String key = "LinkPlotPanel.";
    private ResourceBundle resources = ResourceBundle.getBundle("com.mathworks.page.datamgr.resources.RES_LinkedPlots");

    LinkPlotPanel() {
        super((LayoutManager)new BorderLayout(0, 5));
        this.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 1));
        this.fAnimationTimer = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinkPlotPanel.this.animate();
            }
        });
    }

    public static void activateLinkMode(Object object) {
        LinkPlotPanel.fireFigureCallback(object, "linkdata", new Object[]{"on"});
    }

    public static void fireFigureCallback(final Object object, final String string, Object[] objectArray) {
        final Object[] objectArray2 = new Object[objectArray.length + 1];
        objectArray2[0] = object;
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i + 1] = objectArray[i];
        }
        Matlab.whenMatlabIdle((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    boolean[] blArray = (boolean[])Matlab.mtFevalConsoleOutput((String)"ishghandle", (Object[])new Object[]{object}, (int)1);
                    if (blArray[0]) {
                        Matlab.mtFevalConsoleOutput((String)string, (Object[])objectArray2, (int)0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void init(ChartObjectProxyFactory.SeriesProxy[] seriesProxyArray, boolean[] blArray, boolean bl) {
        this.setName("LinkPlotPanel");
        this.fLegendTwistOpenList = new TwistOpenList();
        this.fLegendTwistOpenList.setName("LinkPlotPanel:LegendTwistOpenList");
        this.fEditLabel.setBackground(UIManager.getColor("TextField.background"));
        this.fEditLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 15));
        this.fEditLabel.setText(this.resources.getString("LinkPlotPanel.Edithtml"));
        this.fEditLabel.setName("LinkPlotPanel:editHyperlink");
        this.fEditLabel.setToolTipText(this.resources.getString("LinkPlotPanel.EditTooltip"));
        this.fEditLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                new BuildSrcDialogWorker(LinkPlotPanel.this.fEditLabel).start();
            }
        });
        this.fErrorLabel = new MJLabel(this.resources.getString("LinkPlotPanel.FailingLinks"), (Icon)LegendEntry.createErrorIcon(), 2);
        this.fErrorLabel.setName("LinkPlotPanel:failingLinks");
        this.fErrorLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.fErrorLabel.setVisible(false);
        this.fEditButtonPanel = new MJPanel((LayoutManager)new BorderLayout(5, 5));
        this.fEditButtonPanel.add((Component)this.fErrorLabel, (Object)"Center");
        this.fEditButtonPanel.add((Component)((Object)this.fEditLabel), (Object)"East");
        this.fEditButtonPanel.setBackground(UIManager.getColor("TextField.background"));
        this.fEditButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.fNoDataSource = new MJPanel();
        this.fNoDataSource.setLayout((LayoutManager)new BoxLayout((Container)this.fNoDataSource, 2));
        this.fNoDataSource.setBackground(UIManager.getColor("TextField.background"));
        this.fNoDataSource.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        this.fNoDataSourceLbl = new HyperLinkLabel(this.resources.getString("LinkPlotPanel.Here"), new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                new BuildSrcDialogWorker(LinkPlotPanel.this.fNoDataSourceLbl).start();
            }
        });
        this.fNoDataSourceLbl.setName("LinkPlotPanel:fixitLabel");
        MJLabel mJLabel = new MJLabel(this.resources.getString("LinkPlotPanel.NoDataSrcs"), (Icon)LegendEntry.createErrorIcon(), 2);
        mJLabel.setName("LinkPlotPanel:noDataSrcs");
        this.fNoDataSource.add((Component)mJLabel);
        this.fClickHerePanel = new MJPanel();
        this.fClickHerePanel.setBackground(UIManager.getColor("TextField.background"));
        this.fClickHerePanel.setLayout((LayoutManager)new BoxLayout((Container)this.fClickHerePanel, 2));
        this.fClickHerePanel.add((Component)((Object)this.fNoDataSourceLbl));
        this.fNoDataSource.add((Component)this.fClickHerePanel);
        this.fNoDataSource.setVisible(false);
        this.fLegendPanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fLegendPanel.setBackground(UIManager.getColor("TextField.background"));
        this.fLegendPanel.add((Component)this.fNoDataSource, (Object)"West");
        this.fLegendPanel.add((Component)this.fEditButtonPanel, (Object)"East");
        this.fLegendPanel.add((Component)((Object)this.fLegendTwistOpenList), (Object)"Center");
        this.fMinimizeButton = new MJButton((Icon)new ImageIcon(LinkPlotPanel.class.getResource("/com/mathworks/page/datamgr/resources/moveright.gif")));
        this.fMinimizeButton.setFocusPainted(false);
        if (MJUtilities.isHighContrast()) {
            this.fMinimizeButton.setBorder(BorderFactory.createLineBorder(Color.white));
        } else {
            this.fMinimizeButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        }
        Insets insets = this.fMinimizeButton.getMargin();
        insets.top = 0;
        insets.bottom = 0;
        this.fMinimizeButton.setMargin(insets);
        this.fMinimizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinkPlotPanel.this.fLegendPanel.setVisible(!LinkPlotPanel.this.fLegendPanel.isVisible());
                if (LinkPlotPanel.this.fLegendPanel.isVisible()) {
                    LinkPlotPanel.this.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 1));
                    LinkPlotPanel.this.fDisplacedBorderLayout.setRightMinimized(false);
                    LinkPlotPanel.this.fMinimizeButton.setIcon((Icon)new ImageIcon(LinkPlotPanel.class.getResource("/com/mathworks/page/datamgr/resources/moveright.gif")));
                } else {
                    LinkPlotPanel.this.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 1));
                    LinkPlotPanel.this.fDisplacedBorderLayout.setRightMinimized(true);
                    LinkPlotPanel.this.fMinimizeButton.setIcon((Icon)new ImageIcon(LinkPlotPanel.class.getResource("/com/mathworks/page/datamgr/resources/moveleft.gif")));
                }
                LinkPlotPanel.this.doLayout();
                LinkPlotPanel.this.refreshFigure();
            }
        });
        this.fMinimizeButton.setName("LinkPlotPanel:MinimizeButton");
        this.add((Component)this.fMinimizeButton, "East");
        this.add((Component)this.fLegendPanel, "Center");
        this.showGraphicsNames(seriesProxyArray, blArray, bl);
        this.fDisplacedBorderLayout.setVerticalShift(-this.getPreferredSize().height);
    }

    private DisplacedBorderLayout getDisplacedBorderLayout() {
        return this.fDisplacedBorderLayout;
    }

    private void setFigure(Object object) {
        this.fFigure = object;
    }

    public void open() {
        this.fIncrement = 2;
        if (this.fDisplacedBorderLayout.getVerticalShift() >= 0) {
            return;
        }
        this.fDisplacedBorderLayout.setVerticalShift(-this.getPreferredSize().height);
        if (!this.fAnimationTimer.isRunning()) {
            this.fAnimationTimer.start();
        }
    }

    public void close() {
        if (this.fDisplacedBorderLayout.getVerticalShift() == this.getPreferredSize().height) {
            return;
        }
        this.fIncrement = -2;
        if (!this.fAnimationTimer.isRunning()) {
            this.fAnimationTimer.start();
        }
    }

    private void animate() {
        int n = this.fDisplacedBorderLayout.getVerticalShift();
        if ((n += this.fIncrement) >= 0) {
            n = 0;
            this.fAnimationTimer.stop();
        } else if (n <= -this.getPreferredSize().height) {
            this.setVisible(false);
            n = this.getPreferredSize().height;
            this.fAnimationTimer.stop();
        } else {
            this.setVisible(true);
        }
        this.fDisplacedBorderLayout.setVerticalShift(n);
        this.getParent().doLayout();
        this.refreshFigure();
    }

    private void refreshFigure() {
        Container container = SwingUtilities.getAncestorOfClass(HeavyweightLightweightContainerFactory.FigurePanelContainerLight.class, (Component)((Object)this));
        if (container != null) {
            container.revalidate();
        }
    }

    public void setNoLinkState(final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.utSetNoLinkState(n);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LinkPlotPanel.this.utSetNoLinkState(n);
                }
            });
        }
    }

    private void utSetNoLinkState(int n) {
        this.fEditButtonPanel.setVisible(n == LINKED_GRAPHICS);
        this.fLegendTwistOpenList.setVisible(n == LINKED_GRAPHICS);
        this.fNoDataSource.setVisible(n != LINKED_GRAPHICS);
        this.fClickHerePanel.setVisible(n == UNLINKED_GRAPHICS);
        this.refreshFigure();
    }

    public void showGraphicsNames(final ChartObjectProxyFactory.SeriesProxy[] seriesProxyArray, final boolean[] blArray, final boolean bl) {
        if (SwingUtilities.isEventDispatchThread() || !Matlab.isMatlabAvailable()) {
            this.utShowGraphicsNames(seriesProxyArray, blArray, bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LinkPlotPanel.this.utShowGraphicsNames(seriesProxyArray, blArray, bl);
                }
            });
        }
    }

    private void utShowGraphicsNames(ChartObjectProxyFactory.SeriesProxy[] seriesProxyArray, boolean[] blArray, boolean bl) {
        if (seriesProxyArray == null || seriesProxyArray.length == 0) {
            if (bl) {
                this.utSetNoLinkState(NO_GRAPHICS);
            } else {
                this.utSetNoLinkState(UNLINKED_GRAPHICS);
            }
            return;
        }
        this.utSetNoLinkState(LINKED_GRAPHICS);
        LegendEntry[] legendEntryArray = new LegendEntry[seriesProxyArray.length];
        boolean bl2 = false;
        for (int i = 0; i < seriesProxyArray.length; ++i) {
            legendEntryArray[i] = new LegendEntry(seriesProxyArray[i], blArray[i]);
            if (!blArray[i]) continue;
            bl2 = true;
        }
        this.fErrorLabel.setVisible(bl2);
        this.fLegendTwistOpenList.setLegendItems(legendEntryArray);
    }

    public static LinkPlotPanel addLinkPlotPanel(Object object, ChartObjectProxyFactory.SeriesProxy[] seriesProxyArray, boolean[] blArray, boolean bl) {
        assert (SwingUtilities.isEventDispatchThread() || !Matlab.isMatlabAvailable());
        LinkPlotPanel linkPlotPanel = new LinkPlotPanel();
        linkPlotPanel.setFigure(object);
        linkPlotPanel.init(seriesProxyArray, blArray, bl);
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setOpaque(false);
        transparentPanel.add((Component)((Object)linkPlotPanel));
        linkPlotPanel.setVisible(false);
        transparentPanel.setLayout((LayoutManager)linkPlotPanel.getDisplacedBorderLayout());
        return linkPlotPanel;
    }

    public void addOverlay() {
        try {
            Matlab.mtFeval((String)"javacomponent", (Object[])new Object[]{this.getParent(), "Overlay", this.fFigure}, (int)1);
        }
        catch (Exception exception) {
            Log.log((String)exception.toString());
        }
    }

    private static class DisplacedBorderLayout
    implements LayoutManager {
        private int iVerticalShift = 0;
        private boolean iRightMinimized = false;

        private DisplacedBorderLayout() {
        }

        @Override
        public void layoutContainer(Container container) {
            for (Component component : container.getComponents()) {
                Rectangle rectangle = container.getBounds();
                if (this.iRightMinimized) {
                    component.setBounds(rectangle.width - component.getPreferredSize().width, this.iVerticalShift, component.getPreferredSize().width, component.getPreferredSize().height);
                    continue;
                }
                component.setBounds(0, this.iVerticalShift, rectangle.width, component.getPreferredSize().height);
            }
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(container.getBounds().width, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(container.getBounds().width, 0);
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        private void setVerticalShift(int n) {
            this.iVerticalShift = n;
        }

        private int getVerticalShift() {
            return this.iVerticalShift;
        }

        private void setRightMinimized(boolean bl) {
            this.iRightMinimized = bl;
        }
    }

    private class BuildSrcDialogWorker
    extends MatlabWorker<Object> {
        private HyperLinkLabel fLabel;

        BuildSrcDialogWorker(HyperLinkLabel hyperLinkLabel) {
            this.fLabel = hyperLinkLabel;
            this.fLabel.setCursor(new Cursor(3));
        }

        public Object runOnMatlabThread() {
            try {
                Matlab.mtFeval((String)"datamanager.sourceDialogBuilder", (Object[])new Object[]{LinkPlotPanel.this.fFigure, "build"}, (int)0);
            }
            catch (Exception exception) {
                Log.log((String)exception.toString());
            }
            return null;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            this.fLabel.setCursor(new Cursor(12));
        }
    }
}

