/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.export;

import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.SynchronousInvokeUtility;
import com.mathworks.page.export.PrintExportPanel;
import com.mathworks.page.export.PrintExportSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class PreviewTabMisc
extends MJPanel
implements ActionListener,
PropertyChangeListener {
    private PrintExportSettings fPrintSettings;
    private boolean isHG2 = false;
    private MJComboBox fComboRenderer;
    private MJComboBox fComboResolution;
    private String[] fLocalRenderer;
    private MJRadioButton fRadBtnAxesRecompute;
    private MJRadioButton fRadBtnAxesScreen;
    private MJCheckBox fCheckboxPrintUI;
    private MJCheckBox fCheckboxPrintActiveX;

    public PreviewTabMisc(PrintExportSettings printExportSettings) {
        this(printExportSettings, false);
    }

    public PreviewTabMisc(PrintExportSettings printExportSettings, boolean bl) {
        this.fPrintSettings = printExportSettings;
        this.isHG2 = bl;
        this.fPrintSettings.addPropertyChangeListener(this);
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PreviewTabMisc.this.createUI();
                }
            };
            SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter(runnable));
        } else {
            this.createUI();
        }
    }

    private void createUI() {
        this.setLayout(new GridBagLayout());
        int n = 0;
        MJPanel mJPanel = new MJPanel();
        mJPanel.setBorder((Border)new TitledBorder(PrintExportPanel.sResHandle.getString("groupbox.axisGroup")));
        mJPanel.setLayout((LayoutManager)new GridBagLayout());
        this.fRadBtnAxesRecompute = new MJRadioButton(PrintExportPanel.sResHandle.getString("checkbox.recalcAxesLimits"));
        this.fRadBtnAxesRecompute.setName("RadBtn_AxesRecompute");
        this.add((Component)mJPanel, new GridBagConstraints(0, n++, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 6, 3, 6), 0, 0));
        this.fRadBtnAxesScreen = new MJRadioButton(PrintExportPanel.sResHandle.getString("checkbox.freezeAxesLimits"));
        this.fRadBtnAxesScreen.setName("RadBtn_AxesScreen");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fRadBtnAxesRecompute);
        buttonGroup.add((AbstractButton)this.fRadBtnAxesScreen);
        mJPanel.add((Component)this.fRadBtnAxesRecompute, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel.add((Component)this.fRadBtnAxesScreen, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.fRadBtnAxesRecompute.addActionListener((ActionListener)this);
        this.fRadBtnAxesScreen.addActionListener((ActionListener)this);
        MJPanel mJPanel2 = new MJPanel();
        mJPanel2.setLayout((LayoutManager)new GridBagLayout());
        mJPanel2.setBorder((Border)new TitledBorder(PrintExportPanel.sResHandle.getString("groupbox.rendering")));
        this.add((Component)mJPanel2, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 6, 3, 3), 0, 0));
        this.fComboRenderer = new MJComboBox();
        this.fComboRenderer.setName("Combo_Renderer");
        this.fComboRenderer.setEditorColumnCount(10);
        this.fComboResolution = new MJComboBox();
        this.fComboResolution.setName("Combo_Resolution");
        this.fComboResolution.setEditorColumnCount(6);
        this.fComboResolution.setEditable(true);
        this.fComboResolution.addItem((Object)PrintExportPanel.sAuto);
        this.fComboResolution.addItem((Object)"150");
        this.fComboResolution.addItem((Object)"300");
        this.fComboResolution.addItem((Object)"600");
        this.fComboRenderer.addActionListener((ActionListener)this);
        this.fComboResolution.addActionListener((ActionListener)this);
        MJLabel mJLabel = new MJLabel(PrintExportPanel.sResHandle.getString("label.renderer"));
        MJLabel mJLabel2 = new MJLabel(PrintExportPanel.sResHandle.getString("label.resolution"));
        mJPanel2.add((Component)mJLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(9, 3, 6, 3), 0, 0));
        mJPanel2.add((Component)this.fComboRenderer, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(6, 3, 6, 3), 0, 0));
        mJPanel2.add((Component)mJLabel2, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 3, 0, 3), 0, 0));
        mJPanel2.add((Component)this.fComboResolution, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 0, 3), 0, 0));
        int n2 = PrintExportSettings.RENDERER_CODE_ARRAY.length;
        this.fLocalRenderer = new String[n2];
        for (int i = 0; i < n2; ++i) {
            this.fLocalRenderer[i] = PrintExportPanel.sResHandle.getString(PrintExportSettings.RENDERER_CODE_ARRAY[i]);
            this.fComboRenderer.addItem((Object)this.fLocalRenderer[i]);
        }
        if (this.isHG2) {
            this.fComboRenderer.removeItemAt(2);
        }
        this.fCheckboxPrintUI = new MJCheckBox(PrintExportPanel.sResHandle.getString("checkbox.fControls"));
        this.fCheckboxPrintUI.setName("ChkBox_PrintUI");
        this.fCheckboxPrintActiveX = new MJCheckBox(PrintExportPanel.sResHandle.getString("checkbox.fActiveX"));
        this.fCheckboxPrintActiveX.setName("ChkBox_PrintActiveX");
        mJPanel2.add((Component)this.fCheckboxPrintUI, (Object)new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(3, 6, 3, 3), 0, 0));
        this.fCheckboxPrintActiveX.setEnabled(false);
        this.fCheckboxPrintUI.addActionListener((ActionListener)this);
        this.fCheckboxPrintActiveX.addActionListener((ActionListener)this);
        MJPanel mJPanel3 = new MJPanel();
        this.add((Component)mJPanel3, new GridBagConstraints(0, n++, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.fComboRenderer)) {
            this.onRendererChanged();
        } else if (object.equals(this.fComboResolution)) {
            this.onResolutionChanged();
        } else if (object.equals(this.fRadBtnAxesScreen)) {
            this.onAxesLimsTicksChanged();
        } else if (object.equals(this.fRadBtnAxesRecompute)) {
            this.onAxesLimsTicksChanged();
        } else if (object.equals(this.fCheckboxPrintUI)) {
            this.onPrintUIChanged();
        } else if (object.equals(this.fCheckboxPrintActiveX)) {
            this.onPrintActiveXChanged();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        if (propertyChangeEvent.getSource() != this.fPrintSettings) {
            return;
        }
        if (string.equals("Renderer")) {
            this.setRenderer((String)object);
        } else if (string.equals("DPI")) {
            this.setResolution((Double)object);
        } else if (string.equals("AxesFreezeTicks")) {
            this.setAxesLimsTicks((Double)object);
        } else if (string.equals("PrintUI")) {
            this.setPrintUI((Double)object);
        } else if (string.equals("PrintActiveX")) {
            this.setPrintActiveX((Double)object);
        }
    }

    private void onRendererChanged() {
        String string = (String)this.fComboRenderer.getSelectedItem();
        string = PrintExportPanel.convertL10n(string, this.fLocalRenderer, PrintExportSettings.RENDERER_CODE_ARRAY);
        this.fPrintSettings.setRenderer(this, string);
    }

    private void onResolutionChanged() {
        String string = (String)this.fComboResolution.getSelectedItem();
        Double d = string.equals(PrintExportPanel.sAuto) ? new Double(0.0) : PrintExportSettings.convertToDoubleOrZero(string);
        this.fPrintSettings.setResolution(this, d);
    }

    private void setRenderer(String string) {
        this.fComboRenderer.removeActionListener((ActionListener)this);
        string = PrintExportPanel.convertL10n(string, PrintExportSettings.RENDERER_CODE_ARRAY, this.fLocalRenderer);
        this.fComboRenderer.setSelectedItem((Object)string);
        this.fComboRenderer.addActionListener((ActionListener)this);
    }

    private void setResolution(Double d) {
        this.fComboResolution.removeActionListener((ActionListener)this);
        double d2 = d;
        if (d2 == 0.0) {
            this.fComboResolution.setSelectedItem((Object)PrintExportPanel.sAuto);
        } else {
            this.fComboResolution.setSelectedItem((Object)d.toString());
        }
        this.fComboResolution.addActionListener((ActionListener)this);
    }

    private void setAxesLimsTicks(Double d) {
        boolean bl = d > 0.5;
        this.fRadBtnAxesRecompute.setSelected(!bl);
        this.fRadBtnAxesScreen.setSelected(bl);
    }

    private void onAxesLimsTicksChanged() {
        boolean bl = this.fRadBtnAxesScreen.isSelected();
        Double d = bl ? new Double(1.0) : new Double(0.0);
        this.fPrintSettings.setAxesTicksLims(this, d);
    }

    private void onPrintUIChanged() {
        boolean bl = this.fCheckboxPrintUI.isSelected();
        Double d = bl ? new Double(1.0) : new Double(0.0);
        this.fPrintSettings.setPrintUI(this, d);
    }

    private void onPrintActiveXChanged() {
        boolean bl = this.fCheckboxPrintActiveX.isSelected();
        Double d = bl ? new Double(1.0) : new Double(0.0);
        this.fPrintSettings.setPrintActiveX(this, d);
    }

    private void setPrintUI(Double d) {
        boolean bl = d > 0.5;
        this.fCheckboxPrintUI.removeActionListener((ActionListener)this);
        this.fCheckboxPrintUI.setSelected(bl);
        this.fCheckboxPrintUI.addActionListener((ActionListener)this);
    }

    private void setPrintActiveX(Double d) {
        boolean bl = d > 0.5;
        this.fCheckboxPrintActiveX.removeActionListener((ActionListener)this);
        this.fCheckboxPrintActiveX.setSelected(bl);
        this.fCheckboxPrintActiveX.addActionListener((ActionListener)this);
    }
}

