/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.export.pagesetup;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.page.export.print.PagePrintSettings;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class PSSizer
extends MJPanel
implements PropertyChangeListener,
MouseListener,
MouseMotionListener {
    private static final int STATE_NORMAL = 0;
    private static final int STATE_MOVE = 2;
    private static final int STATE_RESIZE_N = 4;
    private static final int STATE_RESIZE_S = 8;
    private static final int STATE_RESIZE_E = 16;
    private static final int STATE_RESIZE_W = 32;
    private static final int STATE_RESIZE_NE = 20;
    private static final int STATE_RESIZE_SE = 24;
    private static final int STATE_RESIZE_NW = 36;
    private static final int STATE_RESIZE_SW = 40;
    private PagePrintSettings fPrintSettings;
    private int fPosPaperPixelLeft;
    private int fPosPaperPixelTop;
    private double[] fPosnFig = null;
    private double fRatio;
    private int fFigEditingMode = 0;
    private int fMouseLastXLoc;
    private int fMouseLastYLoc;

    public PSSizer(PagePrintSettings pagePrintSettings) {
        this.fPrintSettings = pagePrintSettings;
        this.fPrintSettings.addPropertyChangeListener(this);
        this.setPreferredSize(new Dimension(180, 220));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paint(Graphics graphics) {
        boolean bl;
        double d;
        super.paint(graphics);
        int n = 10;
        if (!this.fPrintSettings.isInitialized()) {
            return;
        }
        double[] dArray = this.fPrintSettings.getPaperSize();
        double d2 = (double)(this.getWidth() - 2 * n) / dArray[0];
        this.fRatio = d2 < (d = (double)(this.getHeight() - 2 * n) / dArray[1]) ? d2 : d;
        int n2 = (int)(this.fRatio * dArray[0]);
        int n3 = (int)(this.fRatio * dArray[1]);
        this.fPosPaperPixelLeft = (this.getWidth() - n2) / 2;
        this.fPosPaperPixelTop = (this.getHeight() - n3) / 2;
        graphics.setColor(Color.WHITE);
        graphics.fillRect(this.fPosPaperPixelLeft, this.fPosPaperPixelTop, n2, n3);
        graphics.setColor(Color.BLACK);
        graphics.draw3DRect(this.fPosPaperPixelLeft, this.fPosPaperPixelTop, n2, n3, true);
        for (int i = 0; i < 3; ++i) {
            graphics.drawLine(this.fPosPaperPixelLeft + i, this.fPosPaperPixelTop + n3 + i, this.fPosPaperPixelLeft + n2 + i, this.fPosPaperPixelTop + n3 + i);
            graphics.drawLine(this.fPosPaperPixelLeft + n2 + i, this.fPosPaperPixelTop + i, this.fPosPaperPixelLeft + n2 + i, this.fPosPaperPixelTop + n3 + i);
        }
        graphics.setClip(this.fPosPaperPixelLeft + 1, this.fPosPaperPixelTop + 1, n2 - 2, n3 - 2);
        if (this.fPosnFig == null) {
            this.fPosnFig = this.fPrintSettings.getFigPosition();
        }
        int[] nArray = this.getFigPixelPosition(this.fPosnFig);
        graphics.drawRect(nArray[0], nArray[1], nArray[2], nArray[3]);
        if (this.fPrintSettings.getBackgroundColor().equals("off")) {
            graphics.setColor(new Color(220, 220, 220));
            graphics.fillRect(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        int n4 = (int)Math.round((double)nArray[0] + 0.2 * (double)nArray[2]);
        int n5 = (int)Math.round((double)nArray[1] + 0.3 * (double)nArray[3]);
        int n6 = (int)Math.round((double)nArray[0] + 0.6 * (double)nArray[2]);
        int n7 = (int)Math.round((double)nArray[1] + 0.8 * (double)nArray[3]);
        if (this.fPrintSettings.getBackgroundColor().equals("off")) {
            graphics.setColor(Color.WHITE);
            graphics.fillRect(n4, n5, n6 - n4, n7 - n5);
        }
        boolean bl2 = bl = this.fPrintSettings.getLineColor() > 0.5;
        if (bl) {
            graphics.setColor(Color.RED);
        } else {
            graphics.setColor(Color.BLACK);
        }
        graphics.drawLine(n4, n7, n6, n7);
        graphics.drawLine(n4, n7, n4, n5);
        graphics.drawLine(n4, n7, n6, n5);
        graphics.setFont(new Font("Dialog", 0, 8));
        graphics.drawString("Sample", (int)((double)nArray[0] + 0.4 * (double)nArray[2]), (int)((double)nArray[1] + 0.2 * (double)nArray[3]));
        double d3 = this.fPrintSettings.getPrintUI();
        if (d3 > 0.5) {
            int n8 = (int)((double)nArray[0] + 0.75 * (double)nArray[2]);
            int n9 = (int)((double)nArray[1] + 0.75 * (double)nArray[3]);
            int n10 = (int)(0.15 * (double)nArray[2]);
            int n11 = (int)(0.1 * (double)nArray[3]);
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.fillRect(n8, n9, n10, n11);
            graphics.clipRect(n8, n9, n10, n11);
            graphics.setColor(Color.BLACK);
            graphics.draw3DRect(n8, n9, n10, n11, true);
            graphics.drawString("OK", (int)((double)n8 + 0.2 * (double)n10), (int)((double)n9 + 0.8 * (double)n11));
            graphics.setClip(this.fPosPaperPixelLeft + 1, this.fPosPaperPixelTop + 1, n2 - 2, n3 - 2);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("PaperPosition") || string.equals("FigSize") || string.equals("PaperSize") || string.equals("PrintUI") || string.equals("DriverColor") || string.equals("InvertHardCopy")) {
            this.fPosnFig = null;
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.fFigEditingMode > 0) {
            this.fPrintSettings.setFigPosition(this, this.fPosnFig);
        }
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        double d = (double)(mouseEvent.getX() - this.fMouseLastXLoc) / this.fRatio;
        double d2 = (double)(mouseEvent.getY() - this.fMouseLastYLoc) / this.fRatio;
        this.fMouseLastXLoc = mouseEvent.getX();
        this.fMouseLastYLoc = mouseEvent.getY();
        if (this.fFigEditingMode == 0) {
            return;
        }
        if ((this.fFigEditingMode & 0x20) != 0) {
            this.fPosnFig[0] = this.fPosnFig[0] + d;
            this.fPosnFig[2] = this.fPosnFig[2] - d;
        } else if ((this.fFigEditingMode & 0x10) != 0) {
            this.fPosnFig[2] = this.fPosnFig[2] + d;
        }
        if ((this.fFigEditingMode & 4) != 0) {
            this.fPosnFig[1] = this.fPosnFig[1] + d2;
            this.fPosnFig[3] = this.fPosnFig[3] - d2;
        } else if ((this.fFigEditingMode & 8) != 0) {
            this.fPosnFig[3] = this.fPosnFig[3] + d2;
        }
        if ((this.fFigEditingMode & 2) != 0) {
            this.fPosnFig[0] = this.fPosnFig[0] + d;
            this.fPosnFig[1] = this.fPosnFig[1] + d2;
        }
        if (this.fPosnFig[2] <= 0.0) {
            this.fPosnFig[0] = this.fPosnFig[0] + this.fPosnFig[2];
            this.fPosnFig[2] = -1.0 * this.fPosnFig[2];
            this.fFigEditingMode ^= 0x30;
        }
        if (this.fPosnFig[3] <= 0.0) {
            this.fPosnFig[1] = this.fPosnFig[1] + this.fPosnFig[3];
            this.fPosnFig[3] = -1.0 * this.fPosnFig[3];
            this.fFigEditingMode ^= 0xC;
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.fMouseLastXLoc = mouseEvent.getX();
        this.fMouseLastYLoc = mouseEvent.getY();
        if (this.fPrintSettings.getFigPositionMode().equals("auto")) {
            return;
        }
        if (this.fPosnFig == null) {
            return;
        }
        int[] nArray = this.getFigPixelPosition(this.fPosnFig);
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Cursor cursor = null;
        if (this.isMouseCloseToPoint(n, n2, nArray[0], nArray[1])) {
            cursor = Cursor.getPredefinedCursor(6);
            this.fFigEditingMode = 36;
        } else if (this.isMouseCloseToPoint(n, n2, nArray[0], nArray[1] + nArray[3])) {
            cursor = Cursor.getPredefinedCursor(4);
            this.fFigEditingMode = 40;
        } else if (this.isMouseCloseToPoint(n, n2, nArray[0] + nArray[2], nArray[1])) {
            cursor = Cursor.getPredefinedCursor(7);
            this.fFigEditingMode = 20;
        } else if (this.isMouseCloseToPoint(n, n2, nArray[0] + nArray[2], nArray[1] + nArray[3])) {
            cursor = Cursor.getPredefinedCursor(5);
            this.fFigEditingMode = 24;
        } else if (this.isMouseCloseToLine(n, n2, 1, 0, nArray[0])) {
            cursor = Cursor.getPredefinedCursor(10);
            this.fFigEditingMode = 32;
        } else if (this.isMouseCloseToLine(n, n2, 1, 0, nArray[0] + nArray[2])) {
            cursor = Cursor.getPredefinedCursor(11);
            this.fFigEditingMode = 16;
        } else if (this.isMouseCloseToLine(n, n2, 0, 1, nArray[1])) {
            cursor = Cursor.getPredefinedCursor(8);
            this.fFigEditingMode = 4;
        } else if (this.isMouseCloseToLine(n, n2, 0, 1, nArray[1] + nArray[3])) {
            cursor = Cursor.getPredefinedCursor(9);
            this.fFigEditingMode = 8;
        } else if (n > nArray[0] && n < nArray[0] + nArray[2] && n2 > nArray[1] && n2 < nArray[1] + nArray[3]) {
            cursor = Cursor.getPredefinedCursor(13);
            this.fFigEditingMode = 2;
        } else {
            cursor = Cursor.getPredefinedCursor(0);
            this.fFigEditingMode = 0;
        }
        this.setCursor(cursor);
    }

    private boolean isMouseCloseToPoint(int n, int n2, int n3, int n4) {
        return Math.abs(n - n3) < 6 && Math.abs(n2 - n4) < 6;
    }

    private boolean isMouseCloseToLine(int n, int n2, int n3, int n4, int n5) {
        double d = (double)(n3 * n + n4 * n2 - n5) / Math.sqrt(n3 * n3 + n4 * n4);
        return (d = Math.abs(d)) < 6.0;
    }

    private int[] getFigPixelPosition(double[] dArray) {
        int[] nArray = new int[]{(int)Math.round((double)this.fPosPaperPixelLeft + dArray[0] * this.fRatio), (int)Math.round((double)this.fPosPaperPixelTop + dArray[1] * this.fRatio), (int)Math.round(dArray[2] * this.fRatio), (int)Math.round(dArray[3] * this.fRatio)};
        return nArray;
    }
}

