/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.controls;

import com.mathworks.beans.EnumPair;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.PropertyEditor;
import com.mathworks.page.plottool.propertyeditor.PropertyEditorResources;
import com.mathworks.page.plottool.propertyeditor.controls.ComboControl;
import com.mathworks.page.plottool.propertyeditor.controls.PropertyControl;
import java.awt.Component;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class ColormapControl
extends ComboControl {
    private static final String cmapNameJet = PropertyEditorResources.getBundle().getString("value.Jet");
    private static final String cmapNameHSV = PropertyEditorResources.getBundle().getString("value.HSV");
    private static final String cmapNameHot = PropertyEditorResources.getBundle().getString("value.Hot");
    private static final String cmapNameCool = PropertyEditorResources.getBundle().getString("value.Cool");
    private static final String cmapNameSpring = PropertyEditorResources.getBundle().getString("value.Spring");
    private static final String cmapNameSummer = PropertyEditorResources.getBundle().getString("value.Summer");
    private static final String cmapNameAutumn = PropertyEditorResources.getBundle().getString("value.Autumn");
    private static final String cmapNameWinter = PropertyEditorResources.getBundle().getString("value.Winter");
    private static final String cmapNameGray = PropertyEditorResources.getBundle().getString("value.Gray");
    private static final String cmapNameBone = PropertyEditorResources.getBundle().getString("value.Bone");
    private static final String cmapNameCopper = PropertyEditorResources.getBundle().getString("value.Copper");
    private static final String cmapNamePink = PropertyEditorResources.getBundle().getString("value.Pink");
    private static final String cmapNameLines = PropertyEditorResources.getBundle().getString("value.Lines");
    private static final String cmapNameParula = PropertyEditorResources.getBundle().getString("value.Parula");
    private static final String cmapNameCustom = PropertyEditorResources.getBundle().getString("value.Custom");
    protected static EnumPair[] CMAP_NAMES = new EnumPair[]{new EnumPair(cmapNameParula, (Object)"parula"), new EnumPair(cmapNameJet, (Object)"jet"), new EnumPair(cmapNameHSV, (Object)"hsv"), new EnumPair(cmapNameHot, (Object)"hot"), new EnumPair(cmapNameCool, (Object)"cool"), new EnumPair(cmapNameSpring, (Object)"spring"), new EnumPair(cmapNameSummer, (Object)"summer"), new EnumPair(cmapNameAutumn, (Object)"autumn"), new EnumPair(cmapNameWinter, (Object)"winter"), new EnumPair(cmapNameGray, (Object)"gray"), new EnumPair(cmapNameBone, (Object)"bone"), new EnumPair(cmapNameCopper, (Object)"copper"), new EnumPair(cmapNamePink, (Object)"pink"), new EnumPair(cmapNameLines, (Object)"lines"), new EnumPair(cmapNameCustom, (Object)"custom")};
    private ColormapTestWorker fColormapTestWorker = new ColormapTestWorker();
    private ColormapEditorWorker fColormapEditorWorker = new ColormapEditorWorker();
    private final ColormapSetWorker fColormapSetWorker = new ColormapSetWorker();

    public ColormapControl(String string, CellEditorListener cellEditorListener, String string2) {
        super(string, cellEditorListener, CMAP_NAMES, string2);
        this.setEditable(false);
        this.setMaximumRowCount(CMAP_NAMES.length);
        this.fCombo.setRenderer(new ColormapRenderer());
    }

    @Override
    public void setValue(Object object) {
        this.fColormapTestWorker.fValue = object;
        this.fColormapTestWorker.start();
    }

    @Override
    protected void propertyEditStopped() {
        Object object = this.getDisplayedValue();
        if (object != null && object.equals("custom")) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = this.fNCellListeners - 1; i >= 0; --i) {
                this.fCellListeners[i].editingStopped(changeEvent);
            }
        } else {
            super.propertyEditStopped();
        }
    }

    @Override
    public void applyChanges(Object[] objectArray) {
        Object object = this.getValue();
        Object object2 = this.getDisplayedValue();
        if (object2 != null && (object2.equals(PropertyControl.MIXED_VALUES) || object2 instanceof String[] && ((String[])object2).length > 0 && ((String[])object2)[0].equals(PropertyControl.MIXED_VALUES))) {
            return;
        }
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        if ("custom".equals(object2)) {
            this.fColormapEditorWorker.start();
        } else if (object != null && !object.equals(object2) || object != object2) {
            this.fColormapSetWorker.fFigures = objectArray;
            this.fColormapSetWorker.fValue = object2;
            this.fColormapSetWorker.start();
        }
    }

    class ColormapRenderer
    extends BasicComboBoxRenderer {
        private Hashtable icons = new Hashtable();

        ColormapRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if ("Custom".equals(object)) {
                jLabel.setText(PropertyEditorResources.getBundle().getString("value." + object));
            } else {
                jLabel.setText(object.toString());
            }
            Object object2 = ColormapControl.this.stringToValue((String)object);
            jLabel.setIcon(this.findIconForText((String)object2));
            return jLabel;
        }

        private Icon findIconForText(String string) {
            ImageIcon imageIcon;
            if (this.icons.contains(string)) {
                imageIcon = (ImageIcon)this.icons.get(string);
            } else {
                String string2 = "cmap-" + string.toLowerCase() + ".gif";
                imageIcon = PropertyEditor.makeImage(string2);
                this.icons.put(string, imageIcon);
            }
            return imageIcon;
        }
    }

    private class ColormapSetWorker
    extends MatlabWorker {
        public Object[] fFigures;
        public Object fValue;

        private ColormapSetWorker() {
        }

        public Object runOnMatlabThread() {
            try {
                ColormapSetWorker.feval((String)"plottoolfunc", (Object[])new Object[]{"setColormap", this.fFigures, this.fValue}, (int)0);
            }
            catch (Exception exception) {
                ErrorHandler.showJavaException("setColormap", exception);
            }
            return null;
        }

        public void runOnAWTEventDispatchThread(Object object) {
        }
    }

    private class ColormapEditorWorker
    extends MatlabWorker {
        private ColormapEditorWorker() {
        }

        public Object runOnMatlabThread() {
            try {
                ColormapEditorWorker.eval((String)"colormapeditor(gcf)");
            }
            catch (Exception exception) {
                ErrorHandler.showJavaException("colormapeditor", exception);
            }
            return null;
        }

        public void runOnAWTEventDispatchThread(Object object) {
        }
    }

    private class ColormapTestWorker
    extends MatlabWorker {
        public Object fValue;

        private ColormapTestWorker() {
        }

        public Object runOnMatlabThread() {
            Object object = null;
            try {
                object = ColormapTestWorker.feval((String)"plottoolfunc", (Object[])new Object[]{"testColormap", this.fValue}, (int)1);
            }
            catch (Exception exception) {
                ErrorHandler.showJavaException("testColormap", exception);
            }
            return object;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            if (object instanceof String && ((String)object).length() > 0) {
                ColormapControl.super.setValue(object);
            } else {
                ColormapControl.super.setValue("custom");
            }
        }
    }
}

