/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.controls;

import com.mathworks.hg.types.HGFontName;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.page.plottool.propertyeditor.controls.ComboControl;
import com.mathworks.util.PlatformInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;

public class FontComboControl
extends ComboControl {
    protected static String[] sHGFonts = new String[]{"AvantGarde", "Bookman", "Courier", "Helvetica", "Helvetica-Narrow", "MS Sans Serif", "New Century Schoolbook", "Palatino", "Symbol", "Tahoma", "Times", "ZapfChancery", "ZapfDingbats"};
    protected static String[] sAvailableFonts = null;

    public FontComboControl(String string, CellEditorListener cellEditorListener, String string2) {
        super(string, cellEditorListener, string2);
    }

    public void setPrototypeDisplayValue(Object object) {
        this.fCombo.setPrototypeDisplayValue(object);
    }

    @Override
    protected void postInitializeUsingPropContent(Object object) {
        assert (SwingUtilities.isEventDispatchThread());
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>();
        if (object instanceof Object[] && ((Object[])object).length >= 1) {
            Object[] objectArray = (Object[])object;
            assert (objectArray[0] instanceof HGFontName);
        } else assert (object instanceof HGFontName);
        FontComboControl.createDefaultFonts();
        for (String string : sAvailableFonts) {
            defaultComboBoxModel.addElement(string);
        }
        this.fCombo.setModel(defaultComboBoxModel);
    }

    private static void createDefaultFonts() {
        if (sAvailableFonts == null) {
            List list = FontUtils.getFontNames();
            Vector<String> vector = new Vector<String>(list);
            if (!PlatformInfo.isMacintosh()) {
                for (String string : sHGFonts) {
                    if (vector.contains(string)) continue;
                    vector.add(string);
                }
            }
            sAvailableFonts = new String[vector.size()];
            vector.copyInto(sAvailableFonts);
            Arrays.sort(sAvailableFonts);
        }
    }

    @Override
    public String valueToString(Object object) {
        return ((HGFontName)object).getFontName();
    }

    @Override
    public Object stringToValue(String string) {
        return new HGFontName(string);
    }
}

