/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.prefs;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.page.utils.VertFlowLayout;
import com.mathworks.services.Prefs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.border.Border;

public class CopyOptions
extends MJPanel {
    static final int FIG_FORMAT_BITMAP = 0;
    static final int FIG_FORMAT_METAFILE = 1;
    static final int FIG_FORMAT_PRESERVE = 2;
    static final int FIG_BG_TRANSPARENT = 0;
    static final int FIG_BG_WHITE = 1;
    static final int FIG_BG_PRESERVE_COLOR = 2;
    private MJRadioButton fClipFormatMeta;
    private MJRadioButton fClipFormatPreserve;
    private MJRadioButton fClipFormatBitmap;
    private MJCheckBox fMatchFigScreenSize;
    private MJRadioButton fPreserveColor;
    private MJRadioButton fWhiteBg;
    private MJRadioButton fTransparent;
    private MJButton fCopyFigToClip = new MJButton(fRes.getString("button.CopyToClipboard"));
    private static CopyOptions sThePanel = null;
    private static ResourceBundle fRes = ResourceBundle.getBundle("com.mathworks.page.prefs.resources.RES_CopyOpts");

    public CopyOptions() {
        VertFlowLayout vertFlowLayout = new VertFlowLayout(3, 4, 4);
        vertFlowLayout.setMaximizeHorizontally(true);
        MJPanel mJPanel = new MJPanel();
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(fRes.getString("groupbox.ClipboardFormat")));
        ButtonGroup buttonGroup = new ButtonGroup();
        mJPanel.setLayout((LayoutManager)vertFlowLayout);
        this.fClipFormatMeta = new MJRadioButton(fRes.getString("checkbox.Metafile"), false);
        buttonGroup.add((AbstractButton)this.fClipFormatMeta);
        this.fClipFormatPreserve = new MJRadioButton(fRes.getString("checkbox.Preserve"), false);
        buttonGroup.add((AbstractButton)this.fClipFormatPreserve);
        this.fClipFormatBitmap = new MJRadioButton(fRes.getString("checkbox.Bitmap"), false);
        buttonGroup.add((AbstractButton)this.fClipFormatBitmap);
        mJPanel.add((Component)this.fClipFormatMeta);
        mJPanel.add((Component)this.fClipFormatPreserve);
        mJPanel.add((Component)this.fClipFormatBitmap);
        MJPanel mJPanel2 = new MJPanel();
        mJPanel2.setBorder((Border)BorderFactory.createTitledBorder(fRes.getString("groupbox.FigureBKColor")));
        mJPanel2.setLayout((LayoutManager)vertFlowLayout);
        buttonGroup = new ButtonGroup();
        this.fPreserveColor = new MJRadioButton(fRes.getString("checkbox.PreserveColor"), false);
        this.fWhiteBg = new MJRadioButton(fRes.getString("checkbox.White"), false);
        this.fTransparent = new MJRadioButton(fRes.getString("checkbox.Transparent"), false);
        buttonGroup.add((AbstractButton)this.fPreserveColor);
        buttonGroup.add((AbstractButton)this.fPreserveColor);
        buttonGroup.add((AbstractButton)this.fWhiteBg);
        buttonGroup.add((AbstractButton)this.fTransparent);
        mJPanel2.add((Component)this.fPreserveColor);
        mJPanel2.add((Component)this.fWhiteBg);
        mJPanel2.add((Component)this.fTransparent);
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel3.add((Component)mJPanel2, (Object)"North");
        MJPanel mJPanel4 = new MJPanel();
        mJPanel4.setBorder((Border)BorderFactory.createTitledBorder(fRes.getString("groupbox.Size")));
        mJPanel4.setLayout((LayoutManager)new VertFlowLayout(3, 0, 0));
        this.fMatchFigScreenSize = new MJCheckBox(fRes.getString("checkbox.Match"));
        MJLabel mJLabel = new MJLabel("    " + fRes.getString("label.MatchInfo1"));
        MJLabel mJLabel2 = new MJLabel("    " + fRes.getString("label.MatchInfo2"));
        MJLabel mJLabel3 = new MJLabel("    " + fRes.getString("label.MatchInfo3"));
        mJPanel4.add((Component)this.fMatchFigScreenSize);
        MJPanel mJPanel5 = new MJPanel();
        mJPanel5.setLayout((LayoutManager)new VertFlowLayout(3, 0, 0));
        mJPanel5.add((Component)mJLabel);
        mJPanel5.add((Component)mJLabel2);
        mJPanel5.add((Component)mJLabel3);
        mJPanel4.add((Component)mJPanel5);
        this.setLayout(new GridBagLayout());
        this.add((Component)mJPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)mJPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)mJPanel4, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new MJPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.initializePrefsPanel();
    }

    public void initializePrefsPanel() {
        this.fCopyFigToClip.setEnabled(false);
        int n = Prefs.getIntegerPref((String)"CopyOptions.FigureFormat", (int)2);
        if (n == 0) {
            this.fClipFormatBitmap.setSelected(true);
        } else if (n == 2) {
            this.fClipFormatPreserve.setSelected(true);
        } else {
            this.fClipFormatMeta.setSelected(true);
        }
        n = Prefs.getIntegerPref((String)"CopyOptions.FigureBackground", (int)0);
        if (n == 0) {
            this.fTransparent.setSelected(true);
        } else if (n == 1) {
            this.fWhiteBg.setSelected(true);
        } else {
            this.fPreserveColor.setSelected(true);
        }
        boolean bl = Prefs.getBooleanPref((String)"CopyOptions.MatchFigureScreen", (boolean)true);
        this.fMatchFigScreenSize.setSelected(bl);
    }

    public static MJPanel createPrefsPanel() {
        if (sThePanel != null) {
            sThePanel = null;
        }
        sThePanel = new CopyOptions();
        return sThePanel;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl && sThePanel != null) {
            if (CopyOptions.sThePanel.fClipFormatBitmap.isSelected()) {
                Prefs.setIntegerPref((String)"CopyOptions.FigureFormat", (int)0);
            } else if (CopyOptions.sThePanel.fClipFormatPreserve.isSelected()) {
                Prefs.setIntegerPref((String)"CopyOptions.FigureFormat", (int)2);
            } else {
                Prefs.setIntegerPref((String)"CopyOptions.FigureFormat", (int)1);
            }
            if (CopyOptions.sThePanel.fTransparent.isSelected()) {
                Prefs.setIntegerPref((String)"CopyOptions.FigureBackground", (int)0);
            } else if (CopyOptions.sThePanel.fWhiteBg.isSelected()) {
                Prefs.setIntegerPref((String)"CopyOptions.FigureBackground", (int)1);
            } else {
                Prefs.setIntegerPref((String)"CopyOptions.FigureBackground", (int)2);
            }
            Prefs.setBooleanPref((String)"CopyOptions.MatchFigureScreen", (boolean)CopyOptions.sThePanel.fMatchFigScreenSize.isSelected());
        }
        sThePanel = null;
    }

    public static CopyOptions getCopyOptions() {
        return sThePanel;
    }

    public int getFigureFormat() {
        int n = CopyOptions.sThePanel.fClipFormatBitmap.isSelected() ? 0 : (CopyOptions.sThePanel.fClipFormatPreserve.isSelected() ? 2 : 1);
        return n;
    }

    public int getFigureBackground() {
        int n = CopyOptions.sThePanel.fTransparent.isSelected() ? 0 : (CopyOptions.sThePanel.fWhiteBg.isSelected() ? 1 : 2);
        return n;
    }

    public boolean getMatchFigureScreen() {
        return CopyOptions.sThePanel.fMatchFigScreenSize.isSelected();
    }

    public void setFigureFormat(int n) {
        if (n == 0) {
            this.fClipFormatBitmap.setSelected(true);
        } else if (n == 2) {
            this.fClipFormatPreserve.setSelected(true);
        } else if (n == 1) {
            this.fClipFormatMeta.setSelected(true);
        } else {
            MessageFormat messageFormat = new MessageFormat(fRes.getString("error.IllegalSetFigureFormatValue"));
            Object[] objectArray = new Object[]{new Integer(n)};
            String string = messageFormat.format(objectArray);
            System.out.println(string);
        }
    }

    public void setFigureBackground(int n) {
        if (n == 0) {
            this.fTransparent.setSelected(true);
        } else if (n == 1) {
            this.fWhiteBg.setSelected(true);
        } else if (n == 2) {
            this.fPreserveColor.setSelected(true);
        } else {
            MessageFormat messageFormat = new MessageFormat(fRes.getString("error.IllegalSetFigureBKValue"));
            Object[] objectArray = new Object[]{new Integer(n)};
            String string = messageFormat.format(objectArray);
            System.out.println(string);
        }
    }

    public void setMatchFigureScreen(boolean bl) {
        CopyOptions.sThePanel.fMatchFigScreenSize.setSelected(bl);
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"creating_plots"), "copy_options_figure"};
    }
}

