/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class VertFlowLayout
extends FlowLayout {
    public static final int CENTER = 1;
    public static final int BOTTOM = 2;
    public static final int TOP = 3;
    public static final int STRETCH = 4;
    private int fAlignment = 1;
    private boolean fMaximizeHorizontally = false;

    public VertFlowLayout() {
    }

    public VertFlowLayout(int n) {
        this.fAlignment = n;
    }

    public VertFlowLayout(int n, int n2, int n3) {
        super(1, n2, n3);
        this.fAlignment = n;
    }

    public VertFlowLayout(int n, boolean bl) {
        this.fAlignment = n;
        this.fMaximizeHorizontally = bl;
    }

    @Override
    public void setAlignment(int n) {
        this.fAlignment = n;
    }

    @Override
    public int getAlignment() {
        return this.fAlignment;
    }

    public void setMaximizeHorizontally(boolean bl) {
        this.fMaximizeHorizontally = bl;
    }

    public boolean getMaximizeHorizontally() {
        return this.fMaximizeHorizontally;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(1, 1);
        int n = container.getComponentCount();
        if (n <= 0) {
            return dimension;
        }
        Component[] componentArray = container.getComponents();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Dimension dimension2 = componentArray[i].getPreferredSize();
            n2 = Math.max(dimension2.width + this.getHgap(), n2);
            n3 += dimension2.height + this.getVgap();
        }
        Insets insets = container.getInsets();
        dimension.width = n2 += insets.left + insets.right;
        dimension.height = n3 += insets.top + insets.bottom - this.getVgap();
        return dimension;
    }

    @Override
    public void layoutContainer(Container container) {
        int n;
        int n2 = container.getComponentCount();
        if (n2 <= 0) {
            return;
        }
        Dimension dimension = container.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        Insets insets = container.getInsets();
        int n3 = dimension.height - insets.top - insets.bottom;
        int n4 = dimension.width - insets.left - insets.right;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        Component[] componentArray = container.getComponents();
        for (n = 0; n < n2; ++n) {
            Dimension dimension2 = componentArray[n].getPreferredSize();
            n6 += dimension2.height;
            n5 += dimension2.height + this.getVgap();
        }
        n5 = Math.min(n5 - this.getVgap(), n3);
        int n7 = insets.left;
        int n8 = insets.top;
        int n9 = this.getVgap();
        switch (this.fAlignment) {
            case 1: {
                double d = ((double)n3 - (double)n5 + 0.5) / 2.0;
                n8 = (int)d;
                break;
            }
            case 3: {
                n8 = 0;
                break;
            }
            case 2: {
                n8 = n3 - n5;
                break;
            }
            case 4: {
                n8 = 0;
                if (n2 <= 1) break;
                n9 = (n3 - n6) / (n2 - 1);
            }
        }
        if (n8 < 0) {
            n8 = 0;
            n9 = Math.max(1, n3 / n2);
        }
        n8 += insets.top;
        for (n = 0; n < n2; ++n) {
            Dimension dimension3 = componentArray[n].getPreferredSize();
            if (this.fMaximizeHorizontally) {
                dimension3.width = n4;
            }
            componentArray[n].setSize(dimension3);
            dimension3 = componentArray[n].getPreferredSize();
            if (this.fMaximizeHorizontally) {
                dimension3.width = n4;
            }
            componentArray[n].setSize(dimension3);
            componentArray[n].setLocation(n7, n8);
            n8 += dimension3.height + n9;
        }
    }
}

