/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser;

import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.testmeas.guiutil.TMHelpViewer;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;

public class ScanOptionPanel
extends JPanel
implements KeyListener,
ActionListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private static final String ACTION = "ACTION";
    private static final int ADD = 0;
    private static final int DELETE = 1;
    private static final int RESTORE = 2;
    private static final int CANCEL = 3;
    private static final int OK = 4;
    private static final int HELP = 5;
    private static final Boolean TRUE = new Boolean(true);
    private MJFrame frame;
    private MJDialog dialog;
    private JTextField scanCommand;
    private JButton addButton;
    private ScanTableModel model;
    private Object[][] data;
    private String[] columnNames = new String[]{" ", "Scan Commands"};
    private JTable table;
    private JPanel centerPanel;

    public ScanOptionPanel() {
        this.setLayout(new BorderLayout(0, 0));
        this.centerPanel = new JPanel(new BorderLayout());
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.add((Component)this.centerPanel, "Center");
        this.layoutPanel();
    }

    private void layoutPanel() {
        this.createAddBox();
        this.createTable();
        this.createLowerButtonPanel();
    }

    private void createAddBox() {
        JPanel jPanel = new JPanel(new BorderLayout(6, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder("Define a new scan command"));
        this.centerPanel.add((Component)jPanel, "North");
        jPanel.add((Component)new JLabel("Scan Command:"), "West");
        this.scanCommand = new JTextField();
        this.scanCommand.addKeyListener(this);
        jPanel.add((Component)this.scanCommand, "Center");
        this.addButton = this.createButton("Add", new Integer(0));
        jPanel.add((Component)this.createButtonPanel(this.addButton), "South");
    }

    protected void createTable() {
        this.defineTableData();
        this.model = new ScanTableModel();
        JPanel jPanel = new JPanel(new BorderLayout(0, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 1, 4, 1));
        this.centerPanel.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Defined scan commands"));
        jPanel.add((Component)jPanel2, "Center");
        this.table = new JTable(this.model);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jPanel2.add((Component)jScrollPane, "Center");
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        this.configureColumnWidths();
        JButton jButton = this.createButton("Delete", new Integer(1));
        JButton jButton2 = this.createButton("Restore Defaults", new Integer(2));
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 4, 4));
        jPanel3.add(jButton2);
        jPanel3.add(jButton);
        jPanel2.add((Component)jPanel3, "South");
    }

    private void configureColumnWidths() {
        this.table.getColumnModel().getColumn(0).setPreferredWidth(25);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
    }

    private void createLowerButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 5, 0));
        JButton jButton = new JButton("OK");
        jButton.addActionListener(this);
        jButton.putClientProperty(ACTION, new Integer(4));
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(this);
        jButton2.putClientProperty(ACTION, new Integer(3));
        JButton jButton3 = new JButton("Help");
        jButton3.setMnemonic(72);
        jButton3.addActionListener(this);
        jButton3.putClientProperty(ACTION, new Integer(5));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        jPanel.add(jPanel2);
        this.add((Component)jPanel, "South");
    }

    private JButton createButton(String string, Integer n) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        jButton.addFocusListener(this);
        jButton.putClientProperty(ACTION, n);
        return jButton;
    }

    private JPanel createButtonPanel(JButton jButton) {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 4));
        jPanel.add(jButton);
        return jPanel;
    }

    private void defineTableData() {
        String string;
        Hashtable<Object, Boolean> hashtable = Instrument.getScanCommandSelection();
        Vector<String> vector = Instrument.getScanCommands();
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if (vector == null) {
            vector = new Vector();
        }
        this.data = new Object[hashtable.size()][2];
        Enumeration<Object> enumeration = hashtable.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!hashtable.get(string).equals(TRUE)) continue;
            this.data[n][0] = hashtable.get(string);
            this.data[n++][1] = string;
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (hashtable.get(string).equals(TRUE)) continue;
            this.data[n][0] = hashtable.get(string);
            this.data[n++][1] = string;
        }
    }

    private Hashtable<Object, Boolean> getSelectedState() {
        Hashtable<Object, Boolean> hashtable = new Hashtable<Object, Boolean>();
        for (int i = 0; i < this.data.length; ++i) {
            hashtable.put(this.data[i][1], (Boolean)this.data[i][0]);
        }
        return hashtable;
    }

    private Vector<Object> getDefinedScanCommands() {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this.data.length; ++i) {
            vector.addElement(this.data[i][1]);
        }
        return vector;
    }

    private boolean hasBeenAdded(String string) {
        for (int i = 0; i < this.data.length; ++i) {
            if (!this.data[i][1].equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        int n = (Integer)jButton.getClientProperty(ACTION);
        switch (n) {
            case 2: {
                for (int i = this.table.getRowCount() - 1; i >= 0; --i) {
                    this.model.remove(i);
                }
                this.table.clearSelection();
                this.model.append("*IDN?");
                this.scanCommand.setText("");
                this.configureColumnWidths();
                break;
            }
            case 0: {
                String string = this.scanCommand.getText();
                if (TMStringUtil.isOnlyWhiteSpace((String)string)) {
                    TMStringUtil.error((MJFrame)this.frame, (String)"Invalid Scan Command", (String)"The scan command must be specified.");
                    return;
                }
                if (this.hasBeenAdded(string)) {
                    TMStringUtil.error((MJFrame)this.frame, (String)"Invalid Scan Command", (String)"The scan command already exists.");
                    return;
                }
                this.model.append(string);
                this.scanCommand.setText("");
                if (this.table.getRowCount() != 1) break;
                this.configureColumnWidths();
                break;
            }
            case 1: {
                int n2 = this.table.getSelectedRow();
                if (n2 == -1 || n2 > this.model.getRowCount()) {
                    TMStringUtil.error((MJFrame)this.frame, (String)"Error Deleting Scan Command", (String)"To delete a scan command, select the scan command in the table.");
                    return;
                }
                this.model.remove(n2);
                this.table.clearSelection();
                if (this.table.getRowCount() != 0) break;
                this.configureColumnWidths();
                break;
            }
            case 4: {
                Instrument.setScanCommands(this.getDefinedScanCommands());
                Instrument.setScanCommandSelection(this.getSelectedState());
                this.dialog.dispose();
                break;
            }
            case 3: {
                this.dialog.dispose();
                break;
            }
            case 5: {
                TMHelpViewer tMHelpViewer = TMHelpViewer.getInstance();
                tMHelpViewer.update("instrument", "tmtool_csh\\scan_commands.html", "Define Scan Commands Help");
                tMHelpViewer.addToDialog();
            }
        }
        this.dialog.getRootPane().setDefaultButton(null);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.dialog.getRootPane().setDefaultButton(null);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.addButton.doClick();
        }
    }

    public void showAsDialog(MJFrame mJFrame) {
        this.frame = mJFrame;
        this.dialog = new MJDialog((Frame)this.frame, "Define Scan Commands", true);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.getRootPane().setDefaultButton(this.addButton);
        this.dialog.getContentPane().add(this);
        this.dialog.setSize(350, 400);
        Point point = this.frame.getLocation();
        this.dialog.setLocation(point.x, point.y);
        this.dialog.show();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    static /* synthetic */ Object[][] access$102(ScanOptionPanel scanOptionPanel, Object[][] objectArray) {
        scanOptionPanel.data = objectArray;
        return objectArray;
    }

    public class ScanTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public int getColumnCount() {
            return ScanOptionPanel.this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (ScanOptionPanel.this.data == null) {
                return 0;
            }
            return ScanOptionPanel.this.data.length;
        }

        @Override
        public String getColumnName(int n) {
            return ScanOptionPanel.this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return ScanOptionPanel.this.data[n][n2];
        }

        public void setValueAt(String string, int n, int n2) {
            ((ScanOptionPanel)ScanOptionPanel.this).data[n][n2] = string;
            this.fireTableCellUpdated(n, n2);
        }

        public Class<? extends Object> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void append(String string) {
            int n = this.getRowCount() + 1;
            Object[][] objectArray = new Object[n][this.getColumnCount()];
            for (int i = 0; i < n - 1; ++i) {
                for (int j = 0; j < this.getColumnCount(); ++j) {
                    objectArray[i][j] = ScanOptionPanel.this.data[i][j];
                }
            }
            objectArray[n - 1][0] = new Boolean(true);
            objectArray[n - 1][1] = string;
            ScanOptionPanel.access$102(ScanOptionPanel.this, null);
            ScanOptionPanel.access$102(ScanOptionPanel.this, objectArray);
            this.fireTableRowsInserted(n - 1, ScanOptionPanel.this.data.length);
        }

        public void remove(int n) {
            int n2;
            int n3;
            int n4 = this.getRowCount() - 1;
            Object[][] objectArray = new Object[n4][this.getColumnCount()];
            for (n3 = 0; n3 < n; ++n3) {
                for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
                    objectArray[n3][n2] = ScanOptionPanel.this.data[n3][n2];
                }
            }
            for (n3 = n; n3 < n4; ++n3) {
                for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
                    objectArray[n3][n2] = ScanOptionPanel.this.data[n3 + 1][n2];
                }
            }
            ScanOptionPanel.access$102(ScanOptionPanel.this, null);
            ScanOptionPanel.access$102(ScanOptionPanel.this, objectArray);
            this.fireTableRowsInserted(n4 - 1, ScanOptionPanel.this.data.length);
        }
    }
}

