/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.ivicWrapper;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.TablePage;
import com.mathworks.toolbox.instrument.browser.driver.DriverPageInfo;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IviCInstrumentPage;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IviCInstrumentStore;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IvicInstrument;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.JTableHeader;

public class IviCClassCompliantInstrumentTablePage
extends TablePage
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private InstrumentControlBrowser browser;
    private MJMultilineLabel infoLabel;
    private JLabel lastScanDate;
    private JScrollPane scrollPane;
    private JButton scanButton;
    private IviCInstrumentPage iviInstrumentPage;
    private Vector<BrowserTreeNode> currentNodes = new Vector();
    private Object[][] ivic_wrappers;
    private static final String[] ALL_HEADINGS = new String[]{"Driver Name", "Driver Type", "Driver Path"};
    private static final int[] ALL_WIDTH = new int[]{250, 250, 500};
    private static final int SCAN = 0;
    private static final String ACTION = "ACTION";
    private Collator collator = null;

    public IviCClassCompliantInstrumentTablePage(InstrumentControlBrowser instrumentControlBrowser) {
        this.browser = instrumentControlBrowser;
        this.setLayout(new BorderLayout(0, 0));
        this.layoutPanel();
        this.scan();
    }

    private void layoutPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 10, 0, 10));
        this.add(jPanel, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.infoLabel = new MJMultilineLabel();
        jPanel2.add((Component)this.infoLabel, "Center");
        jPanel.add((Component)jPanel2, "North");
        JTableHeader jTableHeader = table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        this.scrollPane = new JScrollPane((Component)table);
        jPanel.add((Component)this.scrollPane, "Center");
        this.scrollPane.setPreferredSize(new Dimension(200, 50));
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 0));
        this.lastScanDate = new JLabel("Last scan date:");
        jPanel3.add((Component)this.lastScanDate, "West");
        jPanel3.add((Component)this.createButtonPanel(), "Center");
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 5, 0));
        this.scanButton = new JButton("Scan");
        this.scanButton.putClientProperty(ACTION, new Integer(0));
        this.scanButton.addActionListener(this);
        this.scanButton.setName("Scan Driver Button");
        jPanel2.add(this.scanButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    @Override
    public void update(BrowserTreeNode browserTreeNode) {
        super.setup();
        if (this.scrollPane.getViewport().getView() == null) {
            this.scrollPane.getViewport().setView((Component)table);
        }
        this.configureTable(ALL_HEADINGS, ALL_WIDTH);
        this.updateTableData();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = (Integer)((JButton)actionEvent.getSource()).getClientProperty(ACTION);
        switch (n) {
            case 0: {
                this.scan();
            }
        }
    }

    public void scan() {
        ScanIviCClassWorker scanIviCClassWorker = new ScanIviCClassWorker();
        scanIviCClassWorker.start();
    }

    public void assignData(String[] stringArray) {
        this.ivic_wrappers = null;
        this.ivic_wrappers = this.convertData(stringArray, ALL_HEADINGS.length, 0, 2);
        this.updateTableData();
    }

    private void updateTableData() {
        if (tableModel != null) {
            tableModel.setData(this.ivic_wrappers);
        }
    }

    private Object[][] convertData(String[] stringArray, int n, int n2, int n3) {
        String[] stringArray2 = new String[]{"Instrument Control Toolbox", "IVI Instruments"};
        Object[][] objectArray = new Object[stringArray.length / n][n];
        int n4 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                objectArray[i][j] = stringArray[n4++];
            }
        }
        this.addNodes(objectArray, n2, n3, stringArray2);
        return objectArray;
    }

    private void cleanupNodes(Vector<BrowserTreeNode> vector, String[] stringArray) {
        for (int i = 0; i < vector.size(); ++i) {
            BrowserTreeNode browserTreeNode = vector.elementAt(i);
            this.browser.removeNode(browserTreeNode.getName(), stringArray);
            DriverPageInfo driverPageInfo = (DriverPageInfo)browserTreeNode.getUserData();
            driverPageInfo.dispose();
            this.browser.removeNode(driverPageInfo.getDriverNameWithPath(), stringArray);
        }
    }

    private void addNodes(Object[][] objectArray, int n, int n2, String[] stringArray) {
        this.cleanupNodes(this.currentNodes, stringArray);
        this.currentNodes.removeAllElements();
        if (objectArray == null) {
            this.currentNodes = new Vector();
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.currentNodes.add(this.createNode(objectArray, (String)objectArray[i][n], stringArray, i));
            String string = (String)objectArray[i][n];
            String string2 = (String)objectArray[i][n2];
            IvicInstrument ivicInstrument = new IvicInstrument(string, string2);
            IviCInstrumentStore.addIviCInstrument(string, ivicInstrument);
        }
    }

    private BrowserTreeNode createNode(Object[][] objectArray, String string, String[] stringArray, int n) {
        BrowserTreeNode browserTreeNode = this.browser.getNode(stringArray, string);
        if (browserTreeNode == null) {
            browserTreeNode = new BrowserTreeNode(string, (BrowserClient)this.browser);
            if (this.iviInstrumentPage == null) {
                this.iviInstrumentPage = new IviCInstrumentPage(this.browser);
            }
            browserTreeNode.setPanel((JPanel)((Object)this.iviInstrumentPage));
            browserTreeNode.setUserData((Object)string);
            browserTreeNode.setType(18);
            browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "ivi_instrument");
            this.browser.addNode(string, stringArray, browserTreeNode, this.findLocation(objectArray, string, n));
        }
        return browserTreeNode;
    }

    private int findLocation(Object[][] objectArray, String string, int n) {
        if (this.collator == null) {
            this.collator = Collator.getInstance();
        }
        for (int i = 0; i < n; ++i) {
            if (this.collator.compare(objectArray[i][0], (Object)string) <= 0) continue;
            return i;
        }
        return n;
    }

    private class ScanIviCClassWorker
    extends MatlabWorker {
        private ScanIviCClassWorker() {
        }

        public void runOnAWTEventDispatchThread(Object object) {
            try {
                String[] stringArray = (String[])object;
                IviCClassCompliantInstrumentTablePage.this.assignData(stringArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
            IviCClassCompliantInstrumentTablePage.this.browser.postStatusBarUpdateEvent("");
            IviCClassCompliantInstrumentTablePage.this.browser.postBlockEventsEvent(false);
        }

        public Object runOnMatlabThread() throws Exception {
            Object object = null;
            try {
                IviCClassCompliantInstrumentTablePage.this.browser.postBlockEventsEvent(true);
                object = ScanIviCClassWorker.feval((String)"instrument.ivic.getIviCWrappers", null, (int)1, (boolean)false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return object;
        }
    }
}

