/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.objects;

import com.mathworks.toolbox.instrument.I2C;
import com.mathworks.toolbox.instrument.browser.objects.BrowserObject;
import com.mathworks.toolbox.instrument.browser.objects.I2CAARDVARKObject;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;

public class I2CObject
extends BrowserObject {
    private static final String[] BYTEORDER = new String[]{"littleEndian", "bigEndian"};
    private static final String[] PULLUPRESISTORS = new String[]{"none", "both"};
    private String Vendor;
    private int BoardIndex;
    private String BoardSerial;
    private String RemoteAddress = "0x0";
    private double BitRate = 100.0;
    private String PullUpResistors = PULLUPRESISTORS[1];

    public I2CObject(String string, String string2, String string3, int n, String string4) {
        super(string2, string4);
        this.Vendor = string;
        this.BoardSerial = string2;
        this.BoardIndex = n;
        this.setRemoteAddress(string3);
    }

    public static I2CObject factoryCreate(String string, String string2, String string3, int n, String string4) {
        if (string.equalsIgnoreCase("aardvark")) {
            return new I2CAARDVARKObject(string, string2, string3, n, string4);
        }
        return new I2CObject(string, string2, string3, n, string4);
    }

    @Override
    public String[] getHeadingInfoColumnOne() {
        String[] stringArray = new String[]{"Vendor:", this.Vendor, "BoardSerial:", this.BoardSerial, "RemoteAddress:", "0x" + Integer.toHexString(Integer.parseInt(this.RemoteAddress))};
        return stringArray;
    }

    @Override
    public String getDescriptiveText() {
        return this.Vendor + ":" + this.BoardSerial + ":[Remote Address: " + "0x" + Integer.toHexString(Integer.parseInt(this.RemoteAddress)) + "]";
    }

    @Override
    public String getType() {
        return "i2c";
    }

    public int getBoardIndex() {
        return this.BoardIndex;
    }

    public String getBoardSerial() {
        return this.BoardSerial;
    }

    public String getRemoteAddress() {
        return this.RemoteAddress;
    }

    public void setRemoteAddress(String string) {
        boolean bl = false;
        if (string.indexOf("0x") == 0) {
            string = string.substring(2);
            bl = true;
            this.RemoteAddress = Integer.toString(Integer.parseInt(string, 16));
        } else {
            this.RemoteAddress = Integer.toString(Integer.parseInt(string));
        }
        if (this.instrumentObject == null) {
            return;
        }
        try {
            if (bl) {
                ((I2C)this.instrumentObject).setRemoteAddress(Integer.parseInt(string, 16));
            } else {
                ((I2C)this.instrumentObject).setRemoteAddress(Integer.parseInt(string));
            }
        }
        catch (Exception exception) {
            TMStringUtil.error((String)"Error Setting RemoteAddress", (String)exception.getMessage());
        }
    }

    public double getBitRate() {
        return this.BitRate;
    }

    public void setBitRate(double d) {
        this.BitRate = d;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((I2C)this.instrumentObject).setBitRate(d);
        }
        catch (Exception exception) {
            TMStringUtil.error((String)"Error Setting BitRate", (String)exception.getMessage());
        }
    }

    public String getVendor() {
        return this.Vendor;
    }

    public String getPullUpResistors() {
        return this.PullUpResistors;
    }

    public void setPullUpResistors(String string) {
        this.PullUpResistors = string;
        int n = 0;
        for (int i = 0; i < PULLUPRESISTORS.length; ++i) {
            if (PULLUPRESISTORS[i] != string) continue;
            n = i;
            break;
        }
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((I2C)this.instrumentObject).setPullupResistors(n);
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting PullupResistors", (String)tMException.getMessage());
        }
    }
}

