/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtool;

import com.mathworks.toolbox.instrument.device.drivers.xml.MethodDefinition;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverGroup;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelEvent;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class DriverFunction
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int sCommandType = 0;
    public static final int sMCodeType = 1;
    private static final String kDefaultFunctionName = "UnknownFunction";
    private static final String[] kAsciiFormats = new String[]{"text", "numeric"};
    private static final String[] kBinaryFormats = new String[]{"int8", "int16", "int32", "uint8", "uint16", "uint32", "float", "double"};
    private String fName = "UnknownFunction";
    private String fMCode = "";
    private String fDescription = "";
    private DriverGroup fGroup = null;
    private int fType = 0;
    private Vector<Object> fCommandStrings = new Vector();
    private Vector<Object> fOutputType = new Vector();
    private Vector<Object> fOutputFormat = new Vector();
    private Vector<String> fInputArguments = new Vector();
    private Vector<DriverModelListener> fChangeListeners = new Vector();

    public DriverFunction() {
    }

    public DriverFunction(String string, String string2) {
        this(string, new DriverGroup(string2));
    }

    public DriverFunction(String string, DriverGroup driverGroup) {
        this.fName = string;
        this.fGroup = driverGroup;
        this.setMCodeToEvaluate("function " + string + "(obj)" + "\n" + "% For group functions, OBJ is the group object. For\n" + "% base device functions, OBJ is the device object.\n");
    }

    public static DriverFunction createFromMethodDefinition(MethodDefinition methodDefinition) {
        return DriverFunction.createFromMethodDefinition(methodDefinition, null);
    }

    public static DriverFunction createFromMethodDefinition(MethodDefinition methodDefinition, DriverGroup driverGroup) {
        String string;
        DriverGroup driverGroup2 = driverGroup;
        if (driverGroup2 == null) {
            driverGroup2 = new DriverGroup(methodDefinition.getLocation());
        }
        DriverFunction driverFunction = methodDefinition.getName() == null ? new DriverFunction(kDefaultFunctionName, driverGroup2) : new DriverFunction(methodDefinition.getName(), driverGroup2);
        if (methodDefinition.getDescription() != null) {
            driverFunction.setDescription(methodDefinition.getDescription());
        }
        if (methodDefinition.getType().equalsIgnoreCase("MCode")) {
            driverFunction.setCodeType(1);
        }
        if (methodDefinition.getRawInputs() != null) {
            driverFunction.setInputs(methodDefinition.getRawInputs());
        }
        if ((string = methodDefinition.getMCodeToEvaluate()) != null && string.length() != 0) {
            driverFunction.setMCodeToEvaluate(methodDefinition.getMCodeToEvaluate());
        } else {
            driverFunction.setMCodeToEvaluate("function " + methodDefinition.getName() + "(obj)" + "\n" + "% If this is a group function, OBJ is the group object. If\n" + "% it a base device function, OBJ is the device object.\n");
        }
        Vector<String> vector = methodDefinition.getRawCommands();
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = "None";
            String string3 = "N/A";
            if (methodDefinition.hasOutput(i)) {
                int n;
                boolean bl = false;
                string3 = methodDefinition.getOutputFormat(i);
                if (methodDefinition.getTypeOfOutputRead(i).equalsIgnoreCase("ascii")) {
                    string2 = "ASCII";
                    for (n = 0; n < kAsciiFormats.length; ++n) {
                        if (!string3.equalsIgnoreCase(kAsciiFormats[n])) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        string3 = "text";
                    }
                } else if (methodDefinition.getTypeOfOutputRead(i).equalsIgnoreCase("binary")) {
                    string2 = "Binary";
                    for (n = 0; n < kBinaryFormats.length; ++n) {
                        if (!string3.equalsIgnoreCase(kBinaryFormats[n])) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        string3 = "text";
                    }
                } else {
                    string2 = "Binblock";
                    for (n = 0; n < kBinaryFormats.length; ++n) {
                        if (!string3.equalsIgnoreCase(kBinaryFormats[n])) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        string3 = "text";
                    }
                }
            }
            driverFunction.addCommand(vector.get(i), string2, string3);
        }
        return driverFunction;
    }

    public static DriverFunction createFromIviInfo(String string, DriverGroup driverGroup, String string2, String string3, String string4, String string5, boolean bl, String[] stringArray, boolean bl2) {
        DriverFunction driverFunction = new DriverFunction(string, driverGroup);
        driverFunction.setDescription(string2);
        driverFunction.writeMCodeForIvi(string3, string4, string5, bl, stringArray, bl2);
        return driverFunction;
    }

    public Object clone() {
        int n;
        DriverFunction driverFunction = new DriverFunction(this.getName(), this.getGroup());
        driverFunction.setDescription(new String(this.getDescription()));
        driverFunction.setCodeType(this.getCodeType());
        driverFunction.setMCodeToEvaluate(new String(this.getMCodeToEvaluate()));
        Vector<String> vector = this.getInputs();
        Vector<String> vector2 = new Vector<String>();
        for (n = 0; n < vector.size(); ++n) {
            vector2.add(new String(vector.get(n)));
        }
        driverFunction.setInputs(vector2);
        for (n = 0; n < this.fCommandStrings.size(); ++n) {
            driverFunction.addCommand(this.fCommandStrings.get(n), this.fOutputType.get(n), this.fOutputFormat.get(n));
        }
        return driverFunction;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.fName);
        objectOutputStream.writeUTF(this.fMCode);
        objectOutputStream.writeUTF(this.fDescription);
        objectOutputStream.writeInt(this.fType);
        objectOutputStream.writeObject(this.fCommandStrings);
        objectOutputStream.writeObject(this.fOutputType);
        objectOutputStream.writeObject(this.fOutputFormat);
        objectOutputStream.writeObject(this.fInputArguments);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.fName = objectInputStream.readUTF();
        this.fMCode = objectInputStream.readUTF();
        this.fDescription = objectInputStream.readUTF();
        this.fType = objectInputStream.readInt();
        this.fCommandStrings = (Vector)objectInputStream.readObject();
        this.fOutputType = (Vector)objectInputStream.readObject();
        this.fOutputFormat = (Vector)objectInputStream.readObject();
        this.fInputArguments = (Vector)objectInputStream.readObject();
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (!string.equals(this.fName)) {
            String string2 = this.getMCodeToEvaluate();
            if (string2.trim().startsWith("function")) {
                int n;
                int n2 = string2.indexOf(10);
                if (n2 == -1) {
                    n2 = string2.indexOf(13);
                }
                if (n2 == -1) {
                    n2 = string2.length();
                }
                if ((n = string2.indexOf(this.fName)) != -1 && n <= n2) {
                    this.setMCodeToEvaluate(string2.substring(0, n) + string + string2.substring(n + this.fName.length()));
                }
            }
            String string3 = this.fName;
            this.fName = string;
            this.fireFunctionNameChangedEvent(string3);
        }
    }

    public String toString() {
        return this.getName();
    }

    public DriverGroup getGroup() {
        return this.fGroup;
    }

    public void setGroup(DriverGroup driverGroup) {
        if (!driverGroup.equals(this.getGroup())) {
            this.fGroup = driverGroup;
            this.fireFunctionChangedEvent();
        }
    }

    public int getCodeType() {
        return this.fType;
    }

    public void setCodeType(int n) {
        if (n != this.fType) {
            this.fType = n;
            this.fireFunctionChangedEvent();
        }
    }

    public String getMCodeToEvaluate() {
        return this.fMCode;
    }

    public void setMCodeToEvaluate(String string) {
        if (!string.equals(this.getMCodeToEvaluate())) {
            this.fMCode = string;
            this.fireFunctionChangedEvent();
        }
    }

    public void writeMCodeForIvi(String string, String string2, String string3, boolean bl, String[] stringArray, boolean bl2) {
        String string4 = string2;
        String string5 = string + "\n\n";
        if (this.getGroup().isParentGroup()) {
            string5 = string5 + "comobj = obj.Interface;\n";
        } else {
            string5 = string5 + "comobj = obj.Parent;\n";
            string5 = string5 + "comobj = comobj.Interface;\n";
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("_collection_")) {
                    string5 = string5 + "name = comobj.Name(obj.HwIndex);\n";
                    string5 = string5 + "comobj = comobj.Item(name);\n";
                    continue;
                }
                string5 = string5 + "comobj = comobj." + stringArray[i] + ";\n";
            }
        }
        string5 = string5 + "feature('COM_SafeArraySingleDim',1);\n";
        if (string3.endsWith("_varargin_")) {
            string5 = string5 + "if ~isempty(varargin)\n";
            string5 = string5 + "\tcomobj." + this.getName() + "(" + string3.replaceFirst(", _varargin_$", ", varargin{:}") + ");\n";
            string5 = string5 + "end\n";
            string5 = string5 + string4 + "comobj." + this.getName() + "(" + string3.replaceFirst(", _varargin_$", "") + ");\n";
        } else {
            string5 = string5 + string4 + "comobj." + this.getName() + "(" + string3 + ");\n";
            string5 = string5 + "feature('COM_SafeArraySingleDim',0);\n";
        }
        this.setMCodeToEvaluate(string5);
        this.setCodeType(1);
    }

    public void appendMCodeToEvaluate(String string) {
        this.fMCode = this.fMCode + string;
        this.fireFunctionChangedEvent();
    }

    public String getDescription() {
        return this.fDescription;
    }

    public void setDescription(String string) {
        if (!string.equals(this.getDescription())) {
            this.fDescription = string;
            this.fireFunctionChangedEvent();
        }
    }

    public void addCommand(Object object, Object object2, Object object3) {
        this.fCommandStrings.addElement(object);
        this.fOutputType.addElement(object2);
        this.fOutputFormat.addElement(object3);
        this.fireFunctionChangedEvent();
    }

    public void removeCommand(int n) {
        this.fCommandStrings.removeElementAt(n);
        this.fOutputType.removeElementAt(n);
        this.fOutputFormat.removeElementAt(n);
        this.fireFunctionChangedEvent();
    }

    public int getCommandCount() {
        return this.fCommandStrings.size();
    }

    public String getCommand(int n) {
        return (String)this.fCommandStrings.get(n);
    }

    public void setCommand(Object object, int n) {
        if (!object.equals(this.fCommandStrings.elementAt(n))) {
            this.fCommandStrings.setElementAt(object, n);
            this.fireFunctionChangedEvent();
        }
    }

    public boolean hasOutput(int n) {
        return !((String)this.fOutputType.get(n)).equalsIgnoreCase("none");
    }

    public String getOutputFormat(int n) {
        return (String)this.fOutputFormat.get(n);
    }

    public void setOutputFormat(Object object, int n) {
        if (!object.equals(this.fOutputFormat.elementAt(n))) {
            this.fOutputFormat.setElementAt(object, n);
            this.fireFunctionChangedEvent();
        }
    }

    public String getOutputType(int n) {
        return (String)this.fOutputType.get(n);
    }

    public void setOutputType(Object object, int n) {
        if (!object.equals(this.fOutputType.elementAt(n))) {
            this.fOutputType.setElementAt(object, n);
            if (object.equals("ASCII")) {
                this.fOutputFormat.setElementAt("text", n);
            } else if (object.equals("None")) {
                this.fOutputFormat.setElementAt("N/A", n);
            } else {
                this.fOutputFormat.setElementAt("int8", n);
            }
            this.fireFunctionChangedEvent();
        }
    }

    public Vector<String> getInputs() {
        return this.fInputArguments;
    }

    public void setInputs(Vector<String> vector) {
        if (vector == null || vector.isEmpty()) {
            if (!this.fInputArguments.isEmpty()) {
                this.fInputArguments.clear();
                this.fireFunctionChangedEvent();
            }
            return;
        }
        if (vector.size() != this.fInputArguments.size()) {
            this.fInputArguments = vector;
            this.fireFunctionChangedEvent();
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i).equals(this.fInputArguments.get(i))) continue;
            this.fInputArguments = vector;
            this.fireFunctionChangedEvent();
            return;
        }
    }

    public void addDriverModelListener(DriverModelListener driverModelListener) {
        if (!this.fChangeListeners.contains(driverModelListener)) {
            this.fChangeListeners.add(driverModelListener);
        }
    }

    public void removeDriverModelListener(DriverModelListener driverModelListener) {
        this.fChangeListeners.remove(driverModelListener);
    }

    private void fireFunctionChangedEvent() {
        DriverModelEvent driverModelEvent = new DriverModelEvent(this, 13, null, 0);
        for (int i = 0; i < this.fChangeListeners.size(); ++i) {
            this.fChangeListeners.get(i).driverStateChanged(driverModelEvent);
        }
    }

    private void fireFunctionNameChangedEvent(String string) {
        DriverModelEvent driverModelEvent = new DriverModelEvent(this, 14, string, 0);
        for (int i = 0; i < this.fChangeListeners.size(); ++i) {
            this.fChangeListeners.get(i).driverStateChanged(driverModelEvent);
        }
    }
}

