/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.guiutil;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.testmeas.guiutil.TMFileDialog;
import com.mathworks.util.NativeJava;
import java.awt.Component;
import java.io.File;

public class ICSaveDialog {
    private static String fileName = "";
    private static String fileNameWithPath = "";
    private static String directoryName = "";

    public static boolean save(String string, String string2, String string3, MJFrame mJFrame, String string4) {
        directoryName = string4;
        int n = ICSaveDialog.launchSaveDialog(string, string2, string3, mJFrame);
        if (n == 1) {
            return false;
        }
        if (!ICSaveDialog.checkFilePermissions(string, string2, string3, mJFrame)) {
            return false;
        }
        directoryName = "";
        return true;
    }

    public static boolean save(String string, String string2, String string3, MJFrame mJFrame) {
        int n = ICSaveDialog.launchSaveDialog(string, string2, string3, mJFrame);
        if (n == 1) {
            return false;
        }
        if (!ICSaveDialog.checkFilePermissions(string, string2, string3, mJFrame)) {
            return false;
        }
        directoryName = "";
        return true;
    }

    private static int launchSaveDialog(String string, String string2, String string3, MJFrame mJFrame) {
        if (directoryName.equals("")) {
            directoryName = Instrument.getPreferenceFile().read("SaveDirectory");
        }
        return ICSaveDialog.launchDialog(0, string2, string, string3, mJFrame);
    }

    private static int launchDialog(int n, String string, String string2, String string3, MJFrame mJFrame) {
        try {
            TMFileDialog tMFileDialog = new TMFileDialog(string, string2.substring(1), string3);
            if (directoryName.equals("")) {
                tMFileDialog.setSelectedFile(new File("untitled" + string2));
            } else {
                tMFileDialog.setCurrentDirectory(new File(directoryName));
                tMFileDialog.setSelectedFile(new File("untitled" + string2));
            }
            int n2 = tMFileDialog.showDialog(n, mJFrame);
            if (n2 == 0) {
                fileNameWithPath = tMFileDialog.getSelectedFile().getAbsolutePath();
                fileName = new File(fileNameWithPath).getName();
                Instrument.getPreferenceFile().update("SaveDirectory", tMFileDialog.getSelectedFile().getParentFile().getPath());
            }
            return n2;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    private static boolean checkFilePermissions(String string, String string2, String string3, MJFrame mJFrame) {
        return ICSaveDialog.checkFilePermissions(fileNameWithPath, string, string2, string3, mJFrame);
    }

    public static boolean checkFilePermissions(String string, String string2, String string3, String string4, MJFrame mJFrame) {
        File file = new File(string);
        if (!file.exists() | file.canWrite()) {
            return true;
        }
        int n = ICSaveDialog.showReadOnlyOverwriteDialog(mJFrame);
        switch (n) {
            case 0: {
                return ICSaveDialog.launchSaveDialog(string2, string3, string4, mJFrame) != 1;
            }
            case 1: {
                NativeJava.changeFileAttribute((String)string, (String)"w");
                return file.canWrite();
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    private static int showReadOnlyOverwriteDialog(MJFrame mJFrame) {
        int n = MJOptionPane.showOptionDialog((Component)mJFrame, (Object)"This file is read-only on disk.", (String)"Save File As", (int)1, (int)2, null, (Object[])new Object[]{"Save As...", "Overwrite", MJOptionPane.CANCEL_STRING}, (Object)"Save As...");
        return n;
    }

    public static String getFileName() {
        return fileName;
    }

    public static String getFileNameWithPath() {
        return fileNameWithPath;
    }

    public static void reset() {
        fileName = "";
        fileNameWithPath = "";
        directoryName = "";
    }
}

