/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.timer;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabMCRFactory;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.timer.MWCallback;
import com.mathworks.timer.MWCallbackScheduler;
import com.mathworks.timer.TimerTaskException;
import java.io.Serializable;

public class TimerTask
implements Serializable,
MWCallback.MyActionListener {
    public static final int MODE_SINGLESHOT = 0;
    public static final int MODE_FIXEDSPACING = 1;
    public static final int MODE_FIXEDDELAY = 2;
    public static final int MODE_FIXEDRATE = 3;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_OVERLAP = 1;
    public static final int ERROR_CALLBACK = 2;
    private MWCallbackScheduler scheduler;
    private long lastRun;
    private long lastRun2;
    private long firstRun;
    private int totalMarks;
    MLArrayRef userData = null;
    private String type = "timer";
    private String name = "timer-" + System.identityHashCode(this);
    private String tag = "";
    private MWCallback timerFcn;
    private MWCallback errorFcn;
    private MWCallback stopFcn;
    private MWCallback startFcn;
    private MWCallback deleteFcn;
    private int mode = 0;
    private int startDelay = 0;
    private int rate = 1000;
    private MatlabMCR fMatlabMCR = MatlabMCRFactory.getForCurrentMCR();
    private boolean visibility = true;
    private boolean isvalid = true;

    public TimerTask() {
        this.timerFcn = new MWCallback("TimerFcn", this, this.fMatlabMCR);
        this.errorFcn = new MWCallback("ErrorFcn", this.fMatlabMCR);
        this.stopFcn = new MWCallback("StopFcn", this, this.fMatlabMCR);
        this.startFcn = new MWCallback("StartFcn", this, this.fMatlabMCR);
        this.deleteFcn = new MWCallback("DeleteFcn", this, this.fMatlabMCR);
        this.scheduler = MWCallbackScheduler.getScheduler();
        this.timerFcn.setOverrateAction(0);
        this.timerFcn.setEnabled(false);
        this.deleteFcn.setEnabled(true);
    }

    public void dispose() throws Throwable {
        this.isvalid = false;
        this.timerFcn.dispose();
        this.errorFcn.dispose();
        this.stopFcn.dispose();
        this.deleteFcn.dispose();
        this.startFcn.dispose();
        this.timerFcn.removeActionListener(this);
        this.timerFcn = null;
        this.errorFcn.removeActionListener(this);
        this.errorFcn = null;
        this.stopFcn.removeActionListener(this);
        this.stopFcn = null;
        this.startFcn.removeActionListener(this);
        this.startFcn = null;
        this.deleteFcn.removeActionListener(this);
        this.deleteFcn = null;
        TimerTask timerTask = this;
        timerTask.scheduler.releaseScheduler();
        if (this.userData != null) {
            this.userData.dispose();
        }
        this.userData = null;
        System.runFinalization();
    }

    private void assertValidForPropertyAccess() throws TimerTaskException {
        if (this.isvalid) {
            return;
        }
        throw new TimerTaskException("The timer object is being deleted. Cannot access its properties.");
    }

    public MLArrayRef getTimerFcn() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        return this.timerFcn.getCallbackFcn();
    }

    public void setTimerFcn(MLArrayRef mLArrayRef) throws TimerTaskException {
        this.assertValidForPropertyAccess();
        if (this.timerFcn.getEnabled() && mLArrayRef.isEmpty()) {
            throw new TimerTaskException("Cannot set a running timer's TimerFcn to empty.");
        }
        this.timerFcn.setCallbackFcn(mLArrayRef);
    }

    public MLArrayRef getErrorFcn() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        return this.errorFcn.getCallbackFcn();
    }

    public void setErrorFcn(MLArrayRef mLArrayRef) throws TimerTaskException {
        this.assertValidForPropertyAccess();
        this.errorFcn.setCallbackFcn(mLArrayRef);
    }

    public MLArrayRef getStopFcn() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        return this.stopFcn.getCallbackFcn();
    }

    public void setStopFcn(MLArrayRef mLArrayRef) throws TimerTaskException {
        this.assertValidForPropertyAccess();
        this.stopFcn.setCallbackFcn(mLArrayRef);
    }

    public MLArrayRef getStartFcn() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        return this.startFcn.getCallbackFcn();
    }

    public void setStartFcn(MLArrayRef mLArrayRef) throws TimerTaskException {
        this.assertValidForPropertyAccess();
        this.startFcn.setCallbackFcn(mLArrayRef);
    }

    public void MakeDeleteFcn(MLArrayRef mLArrayRef) throws TimerTaskException {
        this.assertValidForPropertyAccess();
        this.deleteFcn.setCallbackFcn(mLArrayRef);
    }

    public MLArrayRef getUserData() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        return this.userData;
    }

    public void setUserData(MLArrayRef mLArrayRef) throws TimerTaskException {
        this.assertValidForPropertyAccess();
        if (this.userData != null) {
            this.userData.dispose();
        }
        this.userData = mLArrayRef;
    }

    public String getName() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        return this.name;
    }

    public void setName(String string) throws TimerTaskException {
        this.assertValidForPropertyAccess();
        this.name = string;
    }

    public String getTag() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        return this.tag;
    }

    public void setTag(String string) throws TimerTaskException {
        this.assertValidForPropertyAccess();
        this.tag = string;
    }

    public String getType() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        return this.type;
    }

    public int getVisibility() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        if (this.visibility) {
            return 1;
        }
        return 0;
    }

    public void setVisibility(int n) throws TimerTaskException {
        this.assertValidForPropertyAccess();
        this.visibility = n == 1;
    }

    public int getOverrateAction() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        return this.timerFcn.getOverrateAction();
    }

    public void setOverrateAction(int n) throws TimerTaskException {
        this.assertValidForPropertyAccess();
        if (this.timerFcn.getEnabled()) {
            throw new TimerTaskException("BusyMode cannot be set while timer is running.");
        }
        this.timerFcn.setOverrateAction(n);
    }

    public int getMode() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        return this.mode;
    }

    public void setMode(int n) throws TimerTaskException {
        this.assertValidForPropertyAccess();
        if (this.timerFcn.getEnabled()) {
            throw new TimerTaskException("ExecutionMode cannot be set while timer is running.");
        }
        this.mode = n;
    }

    public void callErrorFcn(String string, String string2) {
        this.errorFcn.asyncExecute(this, string, string2);
        this._stop();
    }

    public double getStartDelay() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        return (double)this.startDelay / 1000.0;
    }

    public void setStartDelay(double d) throws TimerTaskException {
        this.assertValidForPropertyAccess();
        if (this.timerFcn.getEnabled()) {
            throw new TimerTaskException("StartDelay cannot be set while timer is running.");
        }
        if (d >= 2147483.75) {
            throw new TimerTaskException("StartDelay property cannot be set.  StartDelay is limited to values\nless than 2.1474e+006.");
        }
        int n = (int)Math.round(d * 1000.0);
        if (n < 0) {
            throw new TimerTaskException("StartDelay cannot be less than zero.");
        }
        if (Math.abs(d * 1000.0 - (double)n) > 1.0E-15 * (double)n) {
            Object[] objectArray = new Object[]{"MATLAB:TIMER:STARTDELAYPRECISION", "StartDelay property is limited to 1 millisecond precision.  Sub-millisecond precision will be ignored."};
            try {
                MatlabMCR.mtFevalConsoleOutput((String)"warning", (Object[])objectArray, (int)0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.startDelay = n;
    }

    public double getRate() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        return (double)this.rate / 1000.0;
    }

    public void setRate(double d) throws TimerTaskException {
        this.assertValidForPropertyAccess();
        if (this.timerFcn.getEnabled()) {
            throw new TimerTaskException("Period cannot be set while timer is running.");
        }
        if (d >= 2147483.75) {
            throw new TimerTaskException("Period property cannot be set.  Period is limited to values less than\n2.1474e+006.");
        }
        int n = (int)Math.round(d * 1000.0);
        if (n < 1) {
            throw new TimerTaskException("Cannot set Period property to be less than 0.001 seconds.");
        }
        if (Math.abs(d * 1000.0 - (double)n) > 1.0E-15 * (double)n) {
            Object[] objectArray = new Object[]{"MATLAB:TIMER:RATEPRECISION", "Period property is limited to 1 millisecond precision.  Sub-millisecond precision will be ignored."};
            try {
                MatlabMCR.mtFevalConsoleOutput((String)"warning", (Object[])objectArray, (int)0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.rate = n;
    }

    public double getTaskRepeat() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        if (this.timerFcn.getMaxCallbacks() < 0L) {
            return Double.POSITIVE_INFINITY;
        }
        return this.timerFcn.getMaxCallbacks();
    }

    public void setTaskRepeat(double d) throws TimerTaskException {
        this.assertValidForPropertyAccess();
        if (d == Double.POSITIVE_INFINITY) {
            this.timerFcn.setMaxCallbacks(-1L);
        } else {
            if (d >= 9.223372036854776E18) {
                throw new TimerTaskException("TasksToExecute property cannot be set.  TasksToExecute is limited to Inf or\nless than 9.2233e+018.");
            }
            if (d >= 1.0) {
                this.timerFcn.setMaxCallbacks((long)d);
            } else {
                throw new TimerTaskException("TasksToExecute cannot be less than one.");
            }
        }
    }

    public double getTasksExecuted() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        return this.timerFcn.getCallbackCount();
    }

    public double getInstantRate() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        if (this.totalMarks < 2) {
            return Double.NaN;
        }
        return (double)(this.lastRun - this.lastRun2) / 1000.0;
    }

    public double getAverageRate() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        if (this.totalMarks < 2) {
            return Double.NaN;
        }
        return (double)(this.lastRun - this.firstRun) / (double)(this.totalMarks - 1) / 1000.0;
    }

    public int isRunning() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        return this.bool2int(this.timerFcn.getEnabled());
    }

    public synchronized void resetMarks() {
        this.firstRun = 0L;
        this.lastRun = 0L;
        this.lastRun2 = 0L;
        this.totalMarks = 0;
    }

    public synchronized void markRunTime() {
        long l = System.currentTimeMillis();
        if (this.firstRun == 0L) {
            this.firstRun = l;
        }
        this.lastRun2 = this.lastRun;
        this.lastRun = l;
        ++this.totalMarks;
    }

    public void start() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        if (this.timerFcn.getEnabled()) {
            throw new TimerTaskException("Cannot start timer because it is already running.");
        }
        if (this.timerFcn.isEmpty()) {
            throw new TimerTaskException("Cannot start timer without specifying a TimerFcn callback.");
        }
        this.timerFcn.setEnabled(true);
        this.errorFcn.setEnabled(true);
        this.startFcn.setEnabled(true);
        this.stopFcn.setEnabled(true);
        this.timerFcn.resetCallbackCount();
        this.resetMarks();
        this.startFcn.asyncExecute(this);
        if (this.timerFcn.getEnabled()) {
            if (this.startDelay < 1) {
                this.timerFcn.asyncExecute(this);
                if (this.mode == 3) {
                    this.scheduler.schedule(this, this.timerFcn, this.rate, (long)this.rate);
                }
            } else if (this.mode == 3) {
                this.scheduler.schedule(this, this.timerFcn, this.startDelay, (long)this.rate);
            } else {
                this.scheduler.schedule(this, this.timerFcn, this.startDelay);
            }
        }
    }

    public void stop() throws TimerTaskException {
        this.assertValidForPropertyAccess();
        this._stop();
    }

    private void _stop() {
        this.timerFcn.setEnabled(false);
    }

    public void Asyncdelete() {
        this.deleteFcn.asyncExecute(this);
    }

    private int bool2int(boolean bl) {
        if (bl) {
            return 1;
        }
        return 0;
    }

    @Override
    public void actionPerformed(MWCallback.MyActionEvent myActionEvent) {
        int n = myActionEvent.getID();
        if (myActionEvent.getSource() == this.timerFcn) {
            switch (n) {
                case 2: {
                    this.markRunTime();
                    if (this.mode != 2 || !this.timerFcn.getEnabled()) break;
                    this.scheduler.schedule(this, this.timerFcn, this.rate);
                    break;
                }
                case 1: {
                    if (!this.timerFcn.getEnabled() || this.mode == 0) {
                        this._stop();
                        break;
                    }
                    if (this.mode != 1 || !this.timerFcn.getEnabled()) break;
                    this.scheduler.schedule(this, this.timerFcn, this.rate);
                    break;
                }
                case 6: {
                    if (this.mode != 2 && this.mode != 1 || !this.timerFcn.getEnabled()) break;
                    this.scheduler.schedule(this, this.timerFcn, this.rate);
                    break;
                }
                case 3: {
                    this.errorFcn.asyncExecute(this, myActionEvent.getActionCommand(), "MATLAB:timer:errorcallingtimercb");
                    break;
                }
                case 4: {
                    this.errorFcn.asyncExecute(this, myActionEvent.getActionCommand(), "MATLAB:timer:timerfcnoverlap");
                    break;
                }
                case 5: {
                    if (this.timerFcn.getEnabled()) break;
                    this.scheduler.removeCallback(this.timerFcn);
                    this.stopFcn.asyncExecute(this);
                }
            }
        }
    }
}

