/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.phoenix;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;

class PipeWriter
implements Runnable {
    private ByteArrayOutputStream bufOut;
    private int cLast;
    private byte[] currSep;
    private PrintWriter out;
    private InputStream in;
    private String pipeString;
    private String execString;
    private static String lineSeparator = System.getProperty("line.separator");
    private static int lineSeparatorLength = lineSeparator.length();

    private PipeWriter(InputStream inputStream, OutputStream outputStream, String string, String string2) {
        this.in = inputStream;
        this.out = new PrintWriter(outputStream);
        this.bufOut = new ByteArrayOutputStream();
        this.currSep = new byte[lineSeparatorLength];
        this.execString = ":" + string + ':' + string2 + ':';
    }

    public void run() {
        byte[] byArray = new byte[256];
        try {
            int n;
            while ((n = this.in.read(byArray)) != -1) {
                this.write(byArray, 0, n);
            }
            String string = this.bufOut.toString();
            this.bufOut.reset();
            if (string.length() > 0) {
                this.out.println(this.createAnnotation() + string);
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i]);
        }
    }

    private void write(byte by) throws IOException {
        int n = 0;
        for (n = 1; n < this.currSep.length; ++n) {
            this.currSep[n - 1] = this.currSep[n];
        }
        this.currSep[n - 1] = by;
        this.bufOut.write(by);
        if (this.cLast >= lineSeparatorLength - 1 && lineSeparator.equals(new String(this.currSep))) {
            this.cLast = 0;
            this.out.print(this.createAnnotation() + this.bufOut.toString());
            this.out.flush();
            this.bufOut.reset();
            if (this.out.checkError()) {
                throw new IOException("PipeWriter: IO Exception when writing to output stream.");
            }
        } else {
            ++this.cLast;
        }
    }

    private String createAnnotation() {
        return new Date().toString() + this.execString;
    }

    static void plugTogetherPair(String string, InputStream inputStream, OutputStream outputStream, InputStream inputStream2, OutputStream outputStream2) {
        Thread thread = new Thread((Runnable)new PipeWriter(inputStream, outputStream, string, "out"), string + "-out");
        thread.setDaemon(true);
        thread.start();
        Thread thread2 = new Thread((Runnable)new PipeWriter(inputStream2, outputStream2, string, "err"), string + "-err");
        thread2.setDaemon(true);
        thread2.start();
    }
}

