/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.array;

import com.mathworks.services.Prefs;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;

public class ArrayEditorPrefs {
    private static final String CS = "_CS_";
    private static final String ENTER_MODE_KEY = "ArrayEditorEMoves";
    private static final String ENTER_DIRECTION_KEY = "ArrayEditorEDirection";
    private static final String FORMAT_KEY = "ArrayEditor_CS_Format";
    public static final int DIRECTION_RIGHT = 1;
    public static final int DIRECTION_LEFT = 3;
    public static final int DIRECTION_DOWN = 0;
    public static final int DIRECTION_UP = 2;

    private ArrayEditorPrefs() {
    }

    static void setDefaultFormat(FormatIdentifier formatIdentifier) {
        Prefs.setIntegerPref((String)FORMAT_KEY, (int)formatIdentifier.ordinal());
    }

    public static FormatIdentifier getDefaultFormat() {
        FormatIdentifier[] formatIdentifierArray = FormatIdentifier.values();
        return formatIdentifierArray[Prefs.getIntegerPref((String)FORMAT_KEY, (int)FormatIdentifier.getDefaultInstance().ordinal())];
    }

    static String getDefaultFormatKey() {
        return FORMAT_KEY;
    }

    public static boolean isEnterCausesMotion() {
        return Prefs.getBooleanPref((String)ENTER_MODE_KEY, (boolean)true);
    }

    static void setEnterCausesMotion(boolean bl) {
        Prefs.setBooleanPref((String)ENTER_MODE_KEY, (boolean)bl);
    }

    public static String getEnterCausesMotionKey() {
        return ENTER_MODE_KEY;
    }

    public static int getEnterMotionDirection() {
        return Prefs.getIntegerPref((String)ENTER_DIRECTION_KEY, (int)0);
    }

    static void setEnterMotionDirection(int n) {
        Prefs.setIntegerPref((String)ENTER_DIRECTION_KEY, (int)n);
    }

    public static String getEnterMotionDirectionKey() {
        return ENTER_DIRECTION_KEY;
    }
}

