/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.autosave;

import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.util.ResourceBundle;

public class AutoSaveUtils {
    private static final int MILLISECONDS_IN_A_MINUTE = 60000;
    private static final String AUTO_SAVE_ON = "AutoSaveOn";
    private static final String AUTO_SAVE_INT = "AutoSaveInt";
    private static final String AUTO_SAVE_UNTITLED = "AutoSaveUntitled";
    private static final String AUTO_SAVE_SAME_DIRECTORY = "AutoSaveSameDirectory";
    private static final String AUTO_SAVE_REPLACE_EXTENSION = "AutoSaveReplaceExtension";
    private static final String AUTO_SAVE_DIRECTORY = "AutoSaveDirectory";
    private static final String AUTO_SAVE_REPLACE_EXT = "AutoSaveReplaceExt";
    private static final String AUTO_SAVE_APPEND_EXT = "AutoSaveAppendExt";
    private static final String AUTO_SAVE_DELETE_FILES = "AutoSaveDeleteFiles2";
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mde.autosave.resources.RES_autosave");
    private static final boolean DEFAULT_AUTO_SAVE_ON = true;
    private static final int DEFAULT_AUTO_SAVE_INTERVAL = 5;
    private static final String DEFAULT_REPLACE_EXT = "asv";
    private static final String DEFAULT_APPEND_EXT = "~";
    private static final boolean DEFAULT_SAVE_UNTITLED_ON = false;
    private static final boolean DEFAULT_EXTENSION_REPLACED = !PlatformInfo.isUnix();
    private static final boolean DEFAULT_SAME_DIR = true;
    private static final String DEFAULT_AUTO_SAVE_DIR = "";
    private static final boolean DEFAULT_DELETE_ON_EXIT = true;

    private AutoSaveUtils() {
    }

    static void setAutoSaveOptions(boolean bl, double d, boolean bl2, boolean bl3, String string, boolean bl4, String string2, String string3, boolean bl5) {
        AutoSaveUtils.setAutoSaveIntervalInMinutes(d);
        AutoSaveUtils.setAutoSaveUntitled(bl2);
        AutoSaveUtils.setAutoSaveSameDirectory(bl3);
        AutoSaveUtils.setAutoSaveDirectory(string);
        AutoSaveUtils.setAutoSaveExtensionReplaced(bl4);
        AutoSaveUtils.setAutoSaveReplaceExt(string2);
        AutoSaveUtils.setAutoSaveAppendExt(string3);
        AutoSaveUtils.setAutoSaveDeleteFiles(bl5);
        AutoSaveUtils.setAutoSaveOn(bl);
    }

    public static boolean isAutoSaveOn() {
        return Prefs.getBooleanPref((String)"EditorAutoSaveOn", (boolean)true);
    }

    public static void setAutoSaveOn(boolean bl) {
        Prefs.setBooleanPref((String)"EditorAutoSaveOn", (boolean)bl);
    }

    public static double getAutoSaveIntervalInMinutes() {
        return Prefs.getDoublePref((String)"EditorAutoSaveInt", (double)5.0);
    }

    public static void setAutoSaveIntervalInMinutes(double d) {
        Prefs.setDoublePref((String)"EditorAutoSaveInt", (double)d);
    }

    public static void setAutoSaveIntervalInMilliseconds(double d) {
        AutoSaveUtils.setAutoSaveIntervalInMinutes(d / 60000.0);
    }

    public static boolean isAutoSaveUntitledOn() {
        return Prefs.getBooleanPref((String)"EditorAutoSaveUntitled", (boolean)false);
    }

    public static void setAutoSaveUntitled(boolean bl) {
        Prefs.setBooleanPref((String)"EditorAutoSaveUntitled", (boolean)bl);
    }

    public static boolean isAutoSaveSameDirectory() {
        return Prefs.getBooleanPref((String)"EditorAutoSaveSameDirectory", (boolean)true);
    }

    public static void setAutoSaveSameDirectory(boolean bl) {
        Prefs.setBooleanPref((String)"EditorAutoSaveSameDirectory", (boolean)bl);
    }

    public static String getAutoSaveDirectory() {
        return Prefs.getStringPref((String)"EditorAutoSaveDirectory", (String)DEFAULT_AUTO_SAVE_DIR);
    }

    public static void setAutoSaveDirectory(String string) {
        Prefs.setStringPref((String)"EditorAutoSaveDirectory", (String)string);
    }

    static boolean isAutoSaveExtensionReplaced() {
        return Prefs.getBooleanPref((String)"EditorAutoSaveReplaceExtension", (boolean)DEFAULT_EXTENSION_REPLACED);
    }

    private static void setAutoSaveExtensionReplaced(boolean bl) {
        Prefs.setBooleanPref((String)"EditorAutoSaveReplaceExtension", (boolean)bl);
    }

    public static String getAutoSaveReplaceExt() {
        return Prefs.getStringPref((String)"EditorAutoSaveReplaceExt", (String)DEFAULT_REPLACE_EXT);
    }

    public static void setAutoSaveReplaceExt(String string) {
        Prefs.setStringPref((String)"EditorAutoSaveReplaceExt", (String)string);
    }

    static String getAutoSaveAppendExt() {
        return Prefs.getStringPref((String)"EditorAutoSaveAppendExt", (String)DEFAULT_APPEND_EXT);
    }

    private static void setAutoSaveAppendExt(String string) {
        Prefs.setStringPref((String)"EditorAutoSaveAppendExt", (String)string);
    }

    public static boolean isAutoSaveDeleteFilesOn() {
        return Prefs.getBooleanPref((String)"EditorAutoSaveDeleteFiles2", (boolean)true);
    }

    public static void setAutoSaveDeleteFiles(boolean bl) {
        Prefs.setBooleanPref((String)"EditorAutoSaveDeleteFiles2", (boolean)bl);
    }

    public static File translateBufferToAutoSaveFile(String string, String string2) {
        if (string2 == null || !AutoSaveUtils.isAutoSaveUntitledOn()) {
            return null;
        }
        string = AutoSaveUtils.getAutoSaveFilename(string);
        String string3 = AutoSaveUtils.isAutoSaveSameDirectory() ? string2 : AutoSaveUtils.getAutoSaveDirectory();
        return new File(string3, string);
    }

    public static File translateToAutoSaveFile(String string, String string2) {
        File file;
        assert (string2 != null);
        File file2 = new File(string2, string);
        string = AutoSaveUtils.getAutoSaveFilename(string);
        if (!AutoSaveUtils.isAutoSaveSameDirectory()) {
            string2 = AutoSaveUtils.getAutoSaveDirectory();
        }
        return file2.equals(file = new File(string2, string)) ? null : file;
    }

    private static String getAutoSaveFilename(String string) {
        assert (string != null);
        if (AutoSaveUtils.isAutoSaveExtensionReplaced()) {
            int n = string.lastIndexOf(".");
            if (n != -1) {
                string = string.substring(0, n);
            }
            string = string + "." + AutoSaveUtils.getAutoSaveReplaceExt();
        } else {
            string = string + AutoSaveUtils.getAutoSaveAppendExt();
        }
        return string;
    }

    public static String getUnableToMakeAutosaveDirMessage() {
        return sRes.getString("msg.AutoSaveMakeDirs");
    }

    static String intlString(String string) {
        return sRes.getString(string);
    }

    public static String getAutoSaveFilename(String string, String string2) {
        if (!AutoSaveUtils.isAutoSaveOn()) {
            return null;
        }
        string2 = AutoSaveUtils.getAutoSaveFilename(string2);
        if (!AutoSaveUtils.isAutoSaveSameDirectory()) {
            string = AutoSaveUtils.getAutoSaveDirectory();
        }
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string + string2;
    }

    public static boolean isAutoSaveFilename(String string) {
        return AutoSaveUtils.isAutoSaveExtensionReplaced() ? string.endsWith("." + AutoSaveUtils.getAutoSaveReplaceExt()) : string.endsWith(AutoSaveUtils.getAutoSaveAppendExt());
    }

    static void registerForAutosavePreferences(PrefListener prefListener) {
        Prefs.addListener((PrefListener)prefListener, (String)"EditorAutoSaveOn");
        Prefs.addListener((PrefListener)prefListener, (String)"EditorAutoSaveInt");
        Prefs.addListener((PrefListener)prefListener, (String)"EditorAutoSaveUntitled");
        Prefs.addListener((PrefListener)prefListener, (String)"EditorAutoSaveSameDirectory");
        Prefs.addListener((PrefListener)prefListener, (String)"EditorAutoSaveDirectory");
        Prefs.addListener((PrefListener)prefListener, (String)"EditorAutoSaveReplaceExtension");
        Prefs.addListener((PrefListener)prefListener, (String)"EditorAutoSaveReplaceExt");
        Prefs.addListener((PrefListener)prefListener, (String)"EditorAutoSaveAppendExt");
    }

    public static void restoreDefaultValues() {
        AutoSaveUtils.setAutoSaveUntitled(false);
        AutoSaveUtils.setAutoSaveExtensionReplaced(DEFAULT_EXTENSION_REPLACED);
        AutoSaveUtils.setAutoSaveReplaceExt(DEFAULT_REPLACE_EXT);
        AutoSaveUtils.setAutoSaveAppendExt(DEFAULT_APPEND_EXT);
        AutoSaveUtils.setAutoSaveSameDirectory(true);
        AutoSaveUtils.setAutoSaveDirectory(DEFAULT_AUTO_SAVE_DIR);
        AutoSaveUtils.setAutoSaveIntervalInMinutes(5.0);
        AutoSaveUtils.setAutoSaveDeleteFiles(true);
        AutoSaveUtils.setAutoSaveOn(true);
    }
}

