/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import com.mathworks.mde.cmdwin.XCmdWndView;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.FontPrefsComponent;
import com.mathworks.services.Prefs;
import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingPath;
import com.mathworks.util.FileUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.ResourceBundle;

public class CmdWinPrefs
implements FontPrefsComponent {
    static final String CWLINK = "CWLink";
    private static final String SHOW_CLEAR_CONFIRM = "ClearConfirmation";
    static final String SHOW_STARTUP_MSG = "ShowStartupMessage";
    static final String SHOW_HANDLE_GRAPHICS_2_MESSAGE = "ShowHandleGraphics2Message";
    public static final String SHOW_FUNCTION_BROWSER_BTN = "ShowFunctionBrowser";
    private static int sSessionSize;
    private static boolean sWrapLines;
    private static String sNumericDisplay;
    private static boolean sEightyColumnLimit;
    private static int sTabSize;
    private static boolean sShowClearWindowConfirm;
    private static Boolean sIsUserNewToHandleGraphics2;
    public static final int PRINT_HEADER = 1;
    public static final int PRINT_LINE_NUMBERS = 4;
    public static final int PRINT_LINE_WRAP = 8;
    public static final int PRINT_HEADER1_STYLE = 0x100000;
    public static final int PRINT_PAGENUM2_STYLE = 0x20000000;
    public static final int PRINT_DOUBLE_LINE = 0x2000000;
    public static final int SYNTAX_BW = 4096;
    public static final int SYNTAX_COLOR = 2048;
    public static final int SYNTAX_STYLE = 6144;
    public static final int SYNTAX_OPTIONS_MASK = 6144;
    public static final int TEXT_FONT = 32768;
    public static final int HEADER_FONT = 16384;
    private static final int DEFAULT_PRINT_OPTIONS = 571527177;
    private static ResourceBundle sMLRes;
    private static Setting<Boolean> sCWShowTypoCorrectionsKey;

    public static int getTabSize() {
        return sTabSize;
    }

    static void setTabSize(int n) {
        sTabSize = n;
        Prefs.setIntegerPref((String)"CommandWindowSpacesPerTab", (int)n);
    }

    public static int getSessionSize() {
        return sSessionSize;
    }

    static void setSessionSize(int n) {
        sSessionSize = n;
        Prefs.setIntegerPref((String)"CommandWindowMinSessionSize", (int)n);
    }

    public static boolean isWrapLines() {
        return sWrapLines;
    }

    static void setWrapLines(boolean bl) {
        sWrapLines = bl;
        Prefs.setBooleanPref((String)"CommandWindowWrapLines", (boolean)bl);
    }

    public static boolean shouldShowClearConfirmation() {
        return sShowClearWindowConfirm;
    }

    public static void setShowClearConfirmation(boolean bl) {
        sShowClearWindowConfirm = bl;
        Prefs.setBooleanPref((String)"CommandWindowClearConfirmation", (boolean)bl);
    }

    public static String getShowClearConfirmationPrefKey() {
        return "CommandWindowClearConfirmation";
    }

    static void setNumericFormat(String string) {
        Prefs.setStringPref((String)"GeneralNumFormat2", (String)string);
    }

    public static String getNumericDisplay() {
        return sNumericDisplay;
    }

    static void setNumericDisplay(String string) {
        sNumericDisplay = string;
        Prefs.setStringPref((String)"GeneralNumDisplay", (String)string);
    }

    public static boolean isEightyColumnLimit() {
        return sEightyColumnLimit;
    }

    static void setEightyColumnLimit(boolean bl) {
        sEightyColumnLimit = bl;
        Prefs.setBooleanPref((String)"GeneralEightyColumns", (boolean)bl);
    }

    public String getDisplayName() {
        return sMLRes.getString("title.CommandWindow");
    }

    public String getFontPrefsTagName() {
        return "CommandWindow";
    }

    public FontPrefs.FontType getDefaultFont() {
        return FontPrefs.FontType.CODE;
    }

    public static Color getHtmlLinkColor() {
        return ColorPrefs.getHyperlinkColor();
    }

    public static void setShowFunctionBrowser(boolean bl) {
        Prefs.setBooleanPref((String)"CommandWindowShowFunctionBrowser", (boolean)bl);
    }

    public static boolean isShowFunctionBrowser() {
        return Prefs.getBooleanPref((String)"CommandWindowShowFunctionBrowser", (boolean)true);
    }

    public static Setting<Boolean> getTypoSetting() throws SettingException {
        if (sCWShowTypoCorrectionsKey == null) {
            SettingPath settingPath = new SettingPath(new SettingPath(MvmContext.get()), new String[]{"matlab", "desktop", "commandwindow"});
            sCWShowTypoCorrectionsKey = new Setting(settingPath, Boolean.class, "ShowTypoSuggestions");
        }
        return sCWShowTypoCorrectionsKey;
    }

    public static void setShowTypoSuggestions(boolean bl) {
        try {
            CmdWinPrefs.getTypoSetting().set((Object)bl);
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    public static boolean isShowTypoSuggestions() {
        try {
            return (Boolean)CmdWinPrefs.getTypoSetting().get();
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    public static int getPrintOptions() {
        return Prefs.getIntegerPref((String)"CommandWindowPrintOptions", (int)571527177);
    }

    static void setPrintOptions(int n) {
        Prefs.setIntegerPref((String)"CommandWindowPrintOptions", (int)n);
    }

    static void setPrintingBodyCustomFont(Font font) {
        Prefs.setFontPref((String)"CommandWindowTextFont", (Font)font);
    }

    static void setPrintingHeaderCustomFont(Font font) {
        Prefs.setFontPref((String)"CommandWindowHeaderFont", (Font)font);
    }

    public static Font getPrintingBodyFont() {
        int n = CmdWinPrefs.getPrintOptions();
        if ((n & 0x8000) != 0) {
            return XCmdWndView.getInstance().getFont();
        }
        return Prefs.getFontPref((String)"CommandWindowTextFont", (Font)XCmdWndView.getInstance().getFont());
    }

    public static Font getPrintingHeaderFont() {
        int n = CmdWinPrefs.getPrintOptions();
        if ((n & 0x4000) != 0) {
            return CmdWinPrefs.getPrintingBodyFont();
        }
        return Prefs.getFontPref((String)"CommandWindowHeaderFont", (Font)CmdWinPrefs.getPrintingBodyFont());
    }

    public static boolean shouldShowStartingMessage() {
        return Prefs.getBooleanPref((String)"CommandWindowShowStartupMessage", (boolean)true);
    }

    static void setShouldShowStartingMessage(boolean bl) {
        Prefs.setBooleanPref((String)"CommandWindowShowStartupMessage", (boolean)bl);
    }

    static boolean shouldShowHandleGraphics2Message() {
        return Prefs.getBooleanPref((String)"CommandWindowShowHandleGraphics2Message", (boolean)CmdWinPrefs.isUserNewToHandleGraphics2());
    }

    static void setShouldShowHandleGraphics2Message(boolean bl) {
        Prefs.setBooleanPref((String)"CommandWindowShowHandleGraphics2Message", (boolean)bl);
    }

    static boolean isUserNewToHandleGraphics2() {
        if (sIsUserNewToHandleGraphics2 == null) {
            File file = new File(FileUtils.getPreferencesDirectory());
            File file2 = file.getParentFile();
            int n = CmdWinPrefs.getVersionFromFolder(file);
            int n2 = -1;
            for (File file3 : file2.listFiles()) {
                int n3 = CmdWinPrefs.getVersionFromFolder(file3);
                if (n3 >= n || n3 <= n2) continue;
                n2 = n3;
            }
            int n4 = 4029;
            sIsUserNewToHandleGraphics2 = n2 != -1 && n2 < n4;
        }
        return sIsUserNewToHandleGraphics2;
    }

    private static int getVersionFromFolder(File file) {
        if (!file.isDirectory()) {
            return -1;
        }
        String string = file.getName();
        if (string.length() != 6 || string.charAt(0) != 'R') {
            return -1;
        }
        try {
            return 2 * Integer.parseInt(string.substring(1, 5)) + (string.charAt(5) == 'a' ? 0 : 1);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    static {
        sMLRes = ResourceBundle.getBundle("com.mathworks.mde.desk.resources.RES_Desktop");
        sTabSize = Prefs.getIntegerPref((String)"CommandWindowSpacesPerTab", (int)(PlatformInfo.isUnix() ? 8 : 4));
        sSessionSize = Prefs.getIntegerPref((String)"CommandWindowMinSessionSize", (int)5000);
        sWrapLines = Prefs.getBooleanPref((String)"CommandWindowWrapLines", (boolean)false);
        sNumericDisplay = Prefs.getStringPref((String)"GeneralNumDisplay", (String)"loose");
        sEightyColumnLimit = Prefs.getBooleanPref((String)"GeneralEightyColumns", (boolean)true);
        sShowClearWindowConfirm = Prefs.getBooleanPref((String)"CommandWindowClearConfirmation", (boolean)true);
        sCWShowTypoCorrectionsKey = null;
    }
}

