/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import com.mathworks.mde.cmdwin.CmdWinPrefs;
import com.mathworks.mde.cmdwin.XCmdWndView;
import com.mathworks.widgets.text.print.PrintUtils;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;

public class CmdWinPrintUtils {
    public static final String MATLAB_MDE_PRINT_OPTIONS = "DesktopPrintOptions";
    private static final String COMPONENT_TITLE = "ComponentName";
    private static final String PRINT_HEADER_STR = "PrintHeader";
    private static final String PRINT_LINE_NUMBER_STR = "PrintLineNumber";
    private static final String WRAP_LINES_STR = "WrapLines";
    private static final String SYNTAX_STYLE_STR = "SyntaxStyle";
    private static final String PAGE_NUMBER_STYLE_STR = "PageNumberStyle";
    private static final String BORDER_STYLE_STR = "BorderStyle";
    private static final String HEADER_LAYOUT_STYLE_STR = "HeaderLayoutStyle";
    private static final String DEFAULT_FONT_STR = "DefaultFont";
    private static final String USE_CUSTOM_FONT_FOR_BODY_STR = "UseCustomFontForBody";
    private static final String BODY_CUSTOM_FONT_STR = "BodyCustomFont";
    private static final String USE_CUSTOM_FONT_FOR_HEADER_STR = "UseCustomFontForHeader";
    private static final String HEADER_CUSTOM_FONT_STR = "HeaderCustomFont";

    private CmdWinPrintUtils() {
    }

    public static Map<String, Object> getPrintOptionsAsMap() {
        Font font;
        int n = CmdWinPrefs.getPrintOptions();
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 4) != 0;
        boolean bl3 = (n & 8) != 0;
        int n2 = (n & 0xF000000) >> 24;
        int n3 = (n & 0xF0000000) >> 28;
        int n4 = (n & 0xF00000) >> 20;
        int n5 = (n & 0x1800) >> 11;
        boolean bl4 = (n & 0x8000) == 0;
        Font font2 = XCmdWndView.getInstance().getFont();
        boolean bl5 = (n & 0x4000) == 0;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PRINT_HEADER_STR, bl);
        hashMap.put(PRINT_LINE_NUMBER_STR, bl2);
        hashMap.put(WRAP_LINES_STR, bl3);
        hashMap.put(SYNTAX_STYLE_STR, n5);
        hashMap.put(PAGE_NUMBER_STYLE_STR, n3);
        hashMap.put(HEADER_LAYOUT_STYLE_STR, n4);
        hashMap.put(BORDER_STYLE_STR, n2);
        hashMap.put(USE_CUSTOM_FONT_FOR_BODY_STR, bl4);
        hashMap.put(DEFAULT_FONT_STR, PrintUtils.FontHelper.fontToMap((Font)font2));
        if (bl4) {
            font = CmdWinPrefs.getPrintingBodyFont();
            hashMap.put(BODY_CUSTOM_FONT_STR, PrintUtils.FontHelper.fontToMap((Font)font));
        }
        hashMap.put(USE_CUSTOM_FONT_FOR_HEADER_STR, bl5);
        if (bl5) {
            font = CmdWinPrefs.getPrintingHeaderFont();
            hashMap.put(HEADER_CUSTOM_FONT_STR, PrintUtils.FontHelper.fontToMap((Font)font));
        }
        return hashMap;
    }

    public static void setPrintOptionsFromMap(Map<String, Object> map) {
        if (map != null) {
            Font font;
            Map map2;
            Boolean bl;
            Boolean bl2;
            Integer n;
            Integer n2;
            Integer n3;
            Integer n4;
            Boolean bl3;
            Boolean bl4;
            int n5 = 0;
            Boolean bl5 = (Boolean)map.get(PRINT_HEADER_STR);
            if (bl5 != null && bl5.booleanValue()) {
                n5 |= 1;
            }
            if ((bl4 = (Boolean)map.get(PRINT_LINE_NUMBER_STR)) != null && bl4.booleanValue()) {
                n5 |= 4;
            }
            if ((bl3 = (Boolean)map.get(WRAP_LINES_STR)) != null && bl3.booleanValue()) {
                n5 |= 8;
            }
            if ((n4 = (Integer)map.get(SYNTAX_STYLE_STR)) != null) {
                n5 |= n4 << 11;
            }
            if ((n3 = (Integer)map.get(PAGE_NUMBER_STYLE_STR)) != null) {
                n5 |= n3 << 28;
            }
            if ((n2 = (Integer)map.get(BORDER_STYLE_STR)) != null) {
                n5 |= n2 << 24;
            }
            if ((n = (Integer)map.get(HEADER_LAYOUT_STYLE_STR)) != null) {
                n5 |= n << 20;
            }
            if ((bl2 = (Boolean)map.get(USE_CUSTOM_FONT_FOR_BODY_STR)) != null && !bl2.booleanValue()) {
                n5 |= 0x8000;
            }
            if ((bl = (Boolean)map.get(USE_CUSTOM_FONT_FOR_HEADER_STR)) != null && !bl.booleanValue()) {
                n5 |= 0x4000;
            }
            if ((map2 = (Map)map.get(BODY_CUSTOM_FONT_STR)) != null) {
                font = PrintUtils.FontHelper.mapToFont((Map)map2);
                if ((n5 & 0x8000) == 0 && font != null) {
                    CmdWinPrefs.setPrintingBodyCustomFont(font);
                }
            }
            font = PrintUtils.FontHelper.mapToFont((Map)((Map)map.get(HEADER_CUSTOM_FONT_STR)));
            if ((n5 & 0x4000) == 0 && font != null) {
                CmdWinPrefs.setPrintingHeaderCustomFont(font);
            }
            CmdWinPrefs.setPrintOptions(n5);
        }
    }
}

