/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.desk;

import com.mathworks.mde.desk.ContributedTools;
import com.mathworks.mde.desk.ContributedToolsLoader;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.mwswing.IconSet;
import com.mathworks.toolstrip.factory.TSRegistry;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.util.Log;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.xml.bind.DatatypeConverter;

public class AppsFetcher {
    public static void publishAppList() {
        AppsFetcher.getAppList(new Handler(){

            @Override
            public void handleAppList(List<CategoryData> list) {
                MessageServiceFactory.getMessageService().publish("/AppsGalleryChannel", list);
            }
        });
    }

    public static void dumpAppList() {
        AppsFetcher.getAppList(new Handler(){

            @Override
            public void handleAppList(List<CategoryData> list) {
                for (CategoryData categoryData : list) {
                    System.out.print(categoryData);
                }
            }
        });
    }

    public static void getAppList(final Handler handler) {
        ContributedToolsLoader.load(new ContributedToolsLoader.DoneListener(){

            @Override
            public void loadingDone(ContributedTools contributedTools) {
                handler.handleAppList(AppsFetcher.buildAppList());
            }
        });
    }

    private static List<CategoryData> buildAppList() {
        TSRegistry tSRegistry = MLDesktop.getInstance().getToolstripRegistry();
        TSToolSetContents tSToolSetContents = tSRegistry.getToolSetContents("apps_toolset");
        TSToolSetContents.Tool tool = tSToolSetContents.getTool("apps");
        ArrayList<CategoryData> arrayList = new ArrayList<CategoryData>();
        for (TSToolSetContents.Tool tool2 : tool.getChildren()) {
            List list = tool2.getChildren();
            if (list.size() <= 0) continue;
            CategoryData categoryData = new CategoryData();
            arrayList.add(categoryData);
            categoryData.id = tool2.getName();
            categoryData.label = tool2.getLabel();
            categoryData.apps = new ArrayList<AppData>();
            for (TSToolSetContents.Tool tool3 : list) {
                AppData appData = new AppData();
                categoryData.apps.add(appData);
                appData.id = tool3.getName();
                appData.label = tool3.getLabel();
                appData.description = tool3.getDescription();
                appData.code = tool3.getCode();
                Icon icon = tool3.getIcon();
                if (!(icon instanceof IconSet)) continue;
                appData.smallIcon = AppsFetcher.getBase64Encoding(((IconSet)icon).getSmallestIcon());
                appData.largeIcon = AppsFetcher.getBase64Encoding(((IconSet)icon).getLargestIcon());
            }
        }
        return arrayList;
    }

    private static String getBase64Encoding(Icon icon) {
        return "data:image/png;base64," + DatatypeConverter.printBase64Binary((byte[])AppsFetcher.getBytesFrom(AppsFetcher.getImage(icon)));
    }

    private static BufferedImage getImage(Icon icon) {
        int n = Math.max(1, icon.getIconWidth());
        int n2 = Math.max(1, icon.getIconHeight());
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(new JPanel(), graphics2D, 0, 0);
        graphics2D.dispose();
        return bufferedImage;
    }

    private static byte[] getBytesFrom(BufferedImage bufferedImage) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        }
        catch (IOException iOException) {
            Log.logException((Exception)iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static interface Handler {
        public void handleAppList(List<CategoryData> var1);
    }

    public static class CategoryData {
        public String id;
        public String label;
        public List<AppData> apps;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("id    : " + this.id + "\nlabel : " + this.label + "[\n");
            for (AppData appData : this.apps) {
                stringBuilder.append(appData.toString());
                stringBuilder.append('\n');
            }
            return stringBuilder.toString();
        }
    }

    public static class AppData {
        public String id;
        public String label;
        public String description;
        public String code;
        public String smallIcon;
        public String largeIcon;

        public String toString() {
            return "    id          : " + this.id + "\n    label       : " + this.label + "\n    description : " + this.description + "\n";
        }
    }
}

