/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.desk;

import com.google.common.base.Preconditions;
import com.mathworks.common.icons.IconEnumerationUtils;
import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.client.Client;
import com.mathworks.desktop.client.ClientCollection;
import com.mathworks.jmi.Matlab;
import com.mathworks.mde.array.ArrayEditorToolstripTabFactory;
import com.mathworks.mde.desk.CodeReportActionProvider;
import com.mathworks.mde.desk.CommonToolRegistrar;
import com.mathworks.mde.desk.ContributedTools;
import com.mathworks.mde.desk.HomePlotGalleryManager;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.desk.MLMultipleClientFrame;
import com.mathworks.mde.desk.MLSingleClientFrame;
import com.mathworks.mde.desk.PlotGalleryManager;
import com.mathworks.mde.desk.actions.NewSysObjAdvancedTemplate;
import com.mathworks.mde.desk.actions.NewSysObjBasicTemplate;
import com.mathworks.mde.desk.actions.NewSysObjSimulinkTemplate;
import com.mathworks.mde.vrd.LicenseToolSetFactory;
import com.mathworks.mde.webintegration.startpage.StartPageFactory;
import com.mathworks.mlwidgets.graphics.PlotToolSet;
import com.mathworks.mlwidgets.graphics.PlotToolSetFactory;
import com.mathworks.mlwidgets.shortcuts.ShortcutDropListener;
import com.mathworks.mlwidgets.shortcuts.ShortcutsToolstripTabFactory;
import com.mathworks.mlwidgets.toolstrip.MatlabToolSet;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.IconSet;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.SimpleDOMUtils;
import com.mathworks.services.Prefs;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.services.mlx.MlxFileUtils;
import com.mathworks.toolstrip.DefaultToolstrip;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.ToolstripSection;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.components.TSButton;
import com.mathworks.toolstrip.components.TSLabel;
import com.mathworks.toolstrip.components.TSUtil;
import com.mathworks.toolstrip.components.gallery.model.Category;
import com.mathworks.toolstrip.components.gallery.model.GalleryModel;
import com.mathworks.toolstrip.components.gallery.model.Item;
import com.mathworks.toolstrip.components.gallery.view.GalleryView;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.ContextTargetingManager;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.factory.TSRegistry;
import com.mathworks.toolstrip.factory.TSTabConfiguration;
import com.mathworks.toolstrip.factory.TSToolPath;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.util.Log;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTLayoutToolSetFactory;
import com.mathworks.widgets.desk.DTMultipleClientFrame;
import com.mathworks.widgets.desk.DTToolstripFactory;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.desk.RecentFiles;
import com.mathworks.widgets.desk.ToolstripInfoRegistrar;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.zip.DataFormatException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MLToolstripFactory
extends DTToolstripFactory {
    private static TSTabConfiguration sHomeTabConfig;
    private static TSTabConfiguration sPlotTabConfig;
    private static TSTabConfiguration sAppsTabConfig;
    private static TSToolSetContents sHomeToolSetContents;
    private static TSToolSetContents sPlotSupportSetContents;
    private static TSToolSetContents sAppsToolSetContents;
    private static TSToolSet sHomeToolSet;
    private static TSToolSet sLayoutToolSet;
    private static TSRegistry sRegistry;
    private static boolean sFileReadSucceeded;
    private static String sGlobalPlotGalleryLocation;
    private static final int VARIABLE_FIELD_WIDTH = 160;
    private GalleryView fAppsGalleryView;
    private PlotToolSet fMainPlotToolSet;
    private TSToolSet fAppsToolSet;
    private Boolean fShowShortcutsTab;
    private MJAbstractAction fToggleShortcutsTabAction;

    private static boolean isTrialVersion() {
        return StartPageFactory.getStartPage().isEnabled();
    }

    void setContributedTools(ContributedTools contributedTools) {
        for (RecentFiles.Tool object : contributedTools.getRecentFileTools()) {
            this.getMLDesktop().getRecentFiles().addTool(object);
        }
        sRegistry.getToolSet(CommonToolRegistrar.sCommonToolSetName).getAction("switch_windows").setEnabled(true);
        HashMap hashMap = new HashMap();
        hashMap.put(this.fAppsToolSet.getName(), this.fAppsToolSet);
        for (TSToolSet tSToolSet : contributedTools.getToolSetList()) {
            hashMap.put(tSToolSet.getName(), tSToolSet);
        }
        if (this.fAppsGalleryView != null) {
            TSToolSet tSToolSet;
            TSToolPath tSToolPath = (TSToolPath)this.fAppsGalleryView.getClientProperty((Object)"tool path");
            tSToolSet = TSFactory.createGalleryModel((TSToolSetContents.Tool)sAppsToolSetContents.getTool("apps"), (TSToolPath)tSToolPath, (Map)hashMap, (TSRegistry)sRegistry, (boolean)false);
            this.fAppsGalleryView.setModel((GalleryModel)tSToolSet);
            this.fAppsGalleryView.setBusy(false);
            contributedTools.getUserAppsToolSet().addListener(new TSToolSet.Listener((GalleryModel)tSToolSet){
                final /* synthetic */ GalleryModel val$model;
                {
                    this.val$model = galleryModel;
                }

                public void actionRemoved(TSToolSet tSToolSet, String string) {
                    sAppsToolSetContents.removeTool(string, new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("my_apps", "apps_toolset")});
                    Item item = this.val$model.getItem(tSToolSet.getName() + ":" + string);
                    if (item != null) {
                        if (this.val$model.isFavorite(item)) {
                            this.val$model.removeFromFavorites(item);
                        }
                        this.val$model.removeItem(this.val$model.getCategory("apps_toolset:my_apps"), item);
                    }
                }

                public void actionAdded(TSToolSet tSToolSet, String string) {
                    int n;
                    sAppsToolSetContents.addDependent(tSToolSet.getContents(), string);
                    Action action = tSToolSet.getAction(string);
                    Item item = TSFactory.createGalleryItemFromAction((GalleryView)MLToolstripFactory.this.fAppsGalleryView, (Action)action, (String)string, (String)tSToolSet.getName(), (String)"my_apps", (String)"apps_toolset");
                    if (this.val$model.getCategory("apps_toolset:my_apps") == null) {
                        this.val$model.insertCategory(new Category("apps_toolset:my_apps", "My Apps"), 1);
                    }
                    Category category = this.val$model.getCategory("apps_toolset:my_apps");
                    this.val$model.addItem(category, item);
                    TSToolSetContents.Tool tool = sAppsToolSetContents.getTool("my_apps");
                    List list = tool.getChildren();
                    for (n = 0; n < list.size() && !string.equals(((TSToolSetContents.Tool)list.get(n)).getName()); ++n) {
                    }
                    if (n != this.val$model.getItems(category).size() - 1) {
                        this.val$model.moveItem(category, item, n);
                    }
                }
            });
        }
    }

    MLToolstripFactory(MLDesktop mLDesktop) {
        super((Desktop)mLDesktop);
    }

    void setShowShortcutsTab(boolean bl) {
        this.fShowShortcutsTab = bl;
        this.updateShortcutsTabVisibility(this.fDesktop.getMainFrame().getToolstrip(), false);
    }

    Boolean showShortcutsTab() {
        return this.fShowShortcutsTab;
    }

    static boolean includePlotsOnHome() {
        return "home".equalsIgnoreCase(sGlobalPlotGalleryLocation) || "both".equalsIgnoreCase(sGlobalPlotGalleryLocation);
    }

    static boolean showGlobalPlotTab() {
        return "tab".equalsIgnoreCase(sGlobalPlotGalleryLocation) || "both".equalsIgnoreCase(sGlobalPlotGalleryLocation);
    }

    private MLDesktop getMLDesktop() {
        return (MLDesktop)this.fDesktop;
    }

    public Toolstrip createToolstrip(DTFrame dTFrame) {
        DefaultToolstrip defaultToolstrip = new DefaultToolstrip();
        if (sFileReadSucceeded && dTFrame.isMainFrame()) {
            ToolstripTab toolstripTab = this.createHomeTab(dTFrame, (Toolstrip)defaultToolstrip);
            defaultToolstrip.getModel().add((Client)toolstripTab);
            defaultToolstrip.setCurrentTab(toolstripTab.getName());
            if (MLToolstripFactory.showGlobalPlotTab()) {
                defaultToolstrip.getModel().add((Client)this.createPlotTab(dTFrame));
            }
            defaultToolstrip.getModel().add((Client)this.createAppsTab());
            if (this.shouldShowShortcutsTab()) {
                defaultToolstrip.getModel().add((Client)this.createShortcutsTab());
                if (this.fToggleShortcutsTabAction != null) {
                    this.fToggleShortcutsTabAction.setSelected(true);
                }
            }
            ShortcutsToolstripTabFactory.addChangeListener((ChangeListener)new ChangeListener((Toolstrip)defaultToolstrip){
                final /* synthetic */ Toolstrip val$toolstrip;
                {
                    this.val$toolstrip = toolstrip;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    ToolstripTab toolstripTab;
                    ClientCollection clientCollection = this.val$toolstrip.getModel();
                    ToolstripTab toolstripTab2 = (ToolstripTab)clientCollection.get("shortcuts");
                    boolean bl = "shortcuts".equals(this.val$toolstrip.getCurrentTab());
                    ToolstripTab toolstripTab3 = toolstripTab = MLToolstripFactory.this.shouldShowShortcutsTab() ? MLToolstripFactory.this.createShortcutsTab() : null;
                    if (toolstripTab2 != toolstripTab) {
                        if (toolstripTab2 != null) {
                            clientCollection.remove((Client)toolstripTab2);
                        }
                        if (toolstripTab != null) {
                            MLToolstripFactory.this.addShortcutsTab((ClientCollection<ToolstripTab>)clientCollection, toolstripTab);
                        }
                    }
                    if (MLToolstripFactory.this.fToggleShortcutsTabAction != null) {
                        MLToolstripFactory.this.fToggleShortcutsTabAction.setSelected(toolstripTab != null);
                    }
                    if (toolstripTab != null) {
                        this.val$toolstrip.setCurrentTab("shortcuts");
                    } else if (bl) {
                        this.val$toolstrip.setCurrentTab(((ToolstripTab)clientCollection.get(0)).getName());
                    }
                }
            });
            new DropTarget(defaultToolstrip.getComponent(), (DropTargetListener)new ShortcutDropListener());
        } else if (dTFrame.getGroup() != null && "Array Editor".equals(dTFrame.getGroup().getName())) {
            defaultToolstrip.getModel().add((Client)this.createPlotTab(dTFrame));
        }
        return defaultToolstrip;
    }

    private ToolstripTab createHomeTab(DTFrame dTFrame, Toolstrip toolstrip) {
        TSToolSet tSToolSet;
        Object object;
        if (sHomeToolSet == null) {
            sHomeToolSet = new MatlabToolSet(sHomeToolSetContents);
            this.populateHomeToolSet(dTFrame, sHomeToolSet);
            if (sRegistry != null) {
                sRegistry.addToolSet(sHomeToolSet);
            }
        }
        sLayoutToolSet = DTLayoutToolSetFactory.createToolSet((Desktop)this.fDesktop, (DTMultipleClientFrame)((DTMultipleClientFrame)dTFrame), (Toolstrip)toolstrip);
        if (sRegistry != null) {
            sRegistry.addToolSetContents(sLayoutToolSet.getContents());
        }
        this.addCurrentFolderBarOptions(sLayoutToolSet);
        this.addShortcutsTabOption(toolstrip, sLayoutToolSet);
        TSToolSet tSToolSet2 = LicenseToolSetFactory.getToolSet();
        dTFrame.addBindings(MatlabKeyBindings.getManager(), new TSToolSet[]{sHomeToolSet});
        Object object2 = null;
        PlotToolSet plotToolSet = null;
        if (MLToolstripFactory.includePlotsOnHome()) {
            plotToolSet = PlotToolSetFactory.createToolSet();
            object2 = object = new HomePlotGalleryManager(this.getMLDesktop(), plotToolSet);
            plotToolSet.addDecorator("plots", new TSToolSet.ToolDecorator((PlotGalleryManager)object){
                final /* synthetic */ PlotGalleryManager val$manager;
                {
                    this.val$manager = plotGalleryManager;
                }

                public void decorateTool(JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
                    this.val$manager.setGalleryView((GalleryView)jComponent);
                }
            });
        }
        object = this.getParallelToolSet();
        if (this.fAppsToolSet == null) {
            this.fAppsToolSet = this.createAppsToolSet();
        }
        if ((tSToolSet = MLToolstripFactory.getSupportPackageInstallerToolSet()) != null && sRegistry != null) {
            sRegistry.addToolSetContents(tSToolSet.getContents());
            sRegistry.addToolSet(tSToolSet);
        }
        ToolstripTab toolstripTab = TSFactory.createTab((TSTabConfiguration)sHomeTabConfig, (boolean)true, (ContextTargetingManager)dTFrame.getTargetingManager(), (TSRegistry)sRegistry, (TSToolSet[])new TSToolSet[]{sHomeToolSet, sLayoutToolSet, tSToolSet2, plotToolSet, object, this.fAppsToolSet, tSToolSet});
        toolstripTab.setAttribute((Attribute)IS_GLOBAL_TAB, (Object)true);
        if (object2 != null) {
            ((PlotGalleryManager)object2).setPlotSection((ToolstripSection)toolstripTab.getModel().get("plot"));
            ((MLMultipleClientFrame)dTFrame).addPlotGalleryManager((PlotGalleryManager)object2);
        }
        return toolstripTab;
    }

    private void addCurrentFolderBarOptions(TSToolSet tSToolSet) {
        TSToolSetContents tSToolSetContents = tSToolSet.getContents();
        ResourceBundle resourceBundle = MLDesktop.sMLRes;
        tSToolSetContents.addTool(new TSToolSetContents.ToolParameters("cfb_location").setType(TSToolSetContents.ToolType.DROP_DOWN).setLabel(resourceBundle.getString("Tool.cfb_location.Label")), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("show")});
        tSToolSetContents.addTool(new TSToolSetContents.ToolParameters("cfb_in_browser").setType(TSToolSetContents.ToolType.CHECK_BOX).setLabel(resourceBundle.getString("Tool.cfb_in_browser.Label")).setDescription(resourceBundle.getString("Tool.cfb_in_browser.Description")), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("cfb_location")});
        tSToolSetContents.addTool(new TSToolSetContents.ToolParameters("cfb_below_toolstrip").setType(TSToolSetContents.ToolType.CHECK_BOX).setLabel(resourceBundle.getString("Tool.cfb_below_toolstrip.Label")).setDescription(resourceBundle.getString("Tool.cfb_below_toolstrip.Description")), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("cfb_location")});
        tSToolSet.configureAndAdd("cfb_in_browser", this.getMLDesktop().getMoveCurrentFolderBarToBrowserAction());
        tSToolSet.configureAndAdd("cfb_below_toolstrip", this.getMLDesktop().getMoveCurrentFolderBarBelowToolstripAction());
    }

    private void addShortcutsTabOption(Toolstrip toolstrip, TSToolSet tSToolSet) {
        TSToolSetContents tSToolSetContents = tSToolSet.getContents();
        ResourceBundle resourceBundle = MLDesktop.sMLRes;
        tSToolSetContents.addTool(new TSToolSetContents.ToolParameters("toggle_shortcuts").setType(TSToolSetContents.ToolType.CHECK_BOX).setLabel(resourceBundle.getString("Tool.toggle_shortcuts.Label")).setDescription(resourceBundle.getString("Tool.toggle_shortcuts.Description")), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("show").setReferenceToolName("toggle_titles").setReferencePosition(TSToolSetContents.Position.AFTER)});
        this.fToggleShortcutsTabAction = new ToggleShortcutsTabAction(toolstrip);
        tSToolSet.configureAndAdd("toggle_shortcuts", (Action)this.fToggleShortcutsTabAction);
    }

    private void updateShortcutsTabVisibility(Toolstrip toolstrip, boolean bl) {
        boolean bl2;
        ClientCollection clientCollection = toolstrip.getModel();
        ToolstripTab toolstripTab = (ToolstripTab)clientCollection.get("shortcuts");
        boolean bl3 = toolstripTab != null;
        if (bl3 != (bl2 = this.shouldShowShortcutsTab())) {
            if (!bl2) {
                boolean bl4 = "shortcuts".equals(toolstrip.getCurrentTab());
                clientCollection.remove((Client)toolstripTab);
                if (bl4) {
                    toolstrip.setCurrentTab(((ToolstripTab)clientCollection.get(0)).getName());
                }
            } else {
                toolstripTab = this.createShortcutsTab();
                this.addShortcutsTab((ClientCollection<ToolstripTab>)clientCollection, toolstripTab);
                if (bl) {
                    toolstrip.setCurrentTab("shortcuts");
                }
            }
            if (this.fToggleShortcutsTabAction != null) {
                this.fToggleShortcutsTabAction.setSelected(bl2);
            }
        }
    }

    private void addShortcutsTab(ClientCollection<ToolstripTab> clientCollection, ToolstripTab toolstripTab) {
        int n;
        for (n = 0; n < clientCollection.size() && ((Boolean)((ToolstripTab)clientCollection.get(n)).getAttribute((Attribute)DTToolstripFactory.IS_GLOBAL_TAB)).booleanValue(); ++n) {
        }
        clientCollection.add(n, (Client)toolstripTab);
    }

    private TSToolSet createAppsToolSet() {
        MatlabToolSet matlabToolSet = new MatlabToolSet(sAppsToolSetContents);
        matlabToolSet.configureAndAdd("get_more", (Action)new ChildAction(this.getMLDesktop().getVisitAppsAction()));
        matlabToolSet.configureAndAdd("install", (Action)new ChildAction(this.getMLDesktop().getInstallAppAction()));
        return matlabToolSet;
    }

    private ToolstripTab createAppsTab() {
        if (this.fAppsToolSet == null) {
            this.fAppsToolSet = this.createAppsToolSet();
        }
        this.fAppsToolSet.addDecorator("apps", new TSToolSet.ToolDecorator(){

            public void decorateTool(JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
                Preconditions.checkArgument((boolean)(jComponent instanceof GalleryView));
                MLToolstripFactory.this.fAppsGalleryView = (GalleryView)jComponent;
                MLToolstripFactory.this.fAppsGalleryView.setBusy(true);
            }
        });
        ToolstripTab toolstripTab = TSFactory.createTab((TSTabConfiguration)sAppsTabConfig, (boolean)true, null, (TSRegistry)sRegistry, (TSToolSet[])new TSToolSet[]{this.fAppsToolSet});
        toolstripTab.setAttribute((Attribute)IS_GLOBAL_TAB, (Object)true);
        return toolstripTab;
    }

    ToolstripTab createPlotTab(DTFrame dTFrame) {
        final PlotToolSet plotToolSet = PlotToolSetFactory.createToolSet();
        final TSToolSet tSToolSet = new TSToolSet(sPlotSupportSetContents);
        final PlotGalleryManager plotGalleryManager = new PlotGalleryManager((MLDesktop)dTFrame.getDesktop(), plotToolSet);
        if (!dTFrame.isMainFrame()) {
            plotGalleryManager.setEmptyVariableMessage(MLDesktop.sMLRes.getString("message.SelectElementsToPlot"));
        }
        plotToolSet.addDecorator("plots", new TSToolSet.ToolDecorator(){

            public void decorateTool(JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
                GalleryView galleryView = (GalleryView)jComponent;
                plotGalleryManager.setGalleryView(galleryView);
                galleryView.getOptions().setMaxColumnCount(12);
            }
        });
        tSToolSet.addDecorator("variable_1", (TSToolSet.ToolDecorator)new VariableLabelDecorator(plotGalleryManager, 0));
        tSToolSet.addDecorator("variable_3", (TSToolSet.ToolDecorator)new VariableLabelDecorator(plotGalleryManager, 2));
        tSToolSet.addSupplier("variable_2_or_swap", new TSToolSet.ToolSupplier(){

            public JComponent createTool(TSToolSet.ToolLocation toolLocation) {
                TSLabel tSLabel = new TSLabel((Icon)IconEnumerationUtils.getIcon((String)"variable_matrix.png"));
                TSButton tSButton = new TSButton();
                tSLabel.setName(tSToolSet.getName() + ":variable_2");
                tSButton.setName(tSToolSet.getName() + ":swap");
                TSUtil.keyPopupsOpenFollowingAction((JComponent)tSButton);
                plotGalleryManager.setVariableLabel((JLabel)tSLabel, 1);
                plotGalleryManager.setSwapVariablesButton((JButton)tSButton);
                MJPanel mJPanel = new MJPanel(){

                    public void doLayout() {
                        Component component = this.getComponent(0);
                        int n = component.getPreferredSize().width + 3;
                        component.setBounds(0, 0, Math.min(n, 160), this.getHeight());
                        Component component2 = this.getComponent(1);
                        n = component2.getPreferredSize().width;
                        component2.setBounds(0, 0, n, this.getHeight());
                    }

                    public Dimension getPreferredSize() {
                        return new Dimension(160, Math.max(this.getComponent((int)0).getPreferredSize().height, this.getComponent((int)1).getPreferredSize().height));
                    }
                };
                mJPanel.add((Component)tSLabel);
                mJPanel.add((Component)tSButton);
                return mJPanel;
            }
        });
        if (dTFrame.isMainFrame()) {
            this.fMainPlotToolSet = plotToolSet;
        } else if (this.fMainPlotToolSet != null) {
            plotToolSet.setReuseFigure(this.fMainPlotToolSet.willReuseFigure());
        }
        MJAbstractAction mJAbstractAction = new MJAbstractAction("", plotToolSet.willReuseFigure()){

            public void actionPerformed(ActionEvent actionEvent) {
                plotToolSet.setReuseFigure(this.isSelected());
            }
        };
        tSToolSet.configureAndAdd("reuse_figure", (Action)mJAbstractAction);
        MJAbstractAction mJAbstractAction2 = new MJAbstractAction("", !plotToolSet.willReuseFigure()){

            public void actionPerformed(ActionEvent actionEvent) {
                plotToolSet.setReuseFigure(!this.isSelected());
            }
        };
        tSToolSet.configureAndAdd("create_figure", (Action)mJAbstractAction2);
        final ButtonGroup buttonGroup = new ButtonGroup();
        tSToolSet.addDecorator("reuse_figure", new TSToolSet.ToolDecorator(){

            public void decorateTool(JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
                buttonGroup.add((AbstractButton)jComponent);
            }
        });
        tSToolSet.addDecorator("create_figure", new TSToolSet.ToolDecorator(){

            public void decorateTool(JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
                buttonGroup.add((AbstractButton)jComponent);
            }
        });
        ToolstripTab toolstripTab = TSFactory.createTab((TSTabConfiguration)sPlotTabConfig, (TSToolSet[])new TSToolSet[]{plotToolSet, tSToolSet});
        toolstripTab.setAttribute((Attribute)IS_GLOBAL_TAB, (Object)true);
        plotGalleryManager.setPlotSection((ToolstripSection)toolstripTab.getModel().get("plot"));
        if (dTFrame instanceof MLSingleClientFrame) {
            ((MLSingleClientFrame)dTFrame).setPlotGalleryManager(plotGalleryManager);
        } else if (dTFrame instanceof MLMultipleClientFrame) {
            ((MLMultipleClientFrame)dTFrame).addPlotGalleryManager(plotGalleryManager);
        }
        return toolstripTab;
    }

    private boolean shouldShowShortcutsTab() {
        return this.fShowShortcutsTab != null ? this.fShowShortcutsTab : !ShortcutsToolstripTabFactory.isTabEmpty();
    }

    private ToolstripTab createShortcutsTab() {
        ToolstripTab toolstripTab = ShortcutsToolstripTabFactory.getTab();
        toolstripTab.setAttribute((Attribute)IS_GLOBAL_TAB, (Object)true);
        return toolstripTab;
    }

    private void populateHomeToolSet(final DTFrame dTFrame, TSToolSet tSToolSet) {
        MLToolstripFactory.populateNewEditorFileActions(tSToolSet, this.getMLDesktop(), "new_matlab");
        tSToolSet.addDecorator("new_script", new TSToolSet.ToolDecorator(){

            public void decorateTool(JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
                if (jComponent instanceof TSButton) {
                    TSButton tSButton = (TSButton)jComponent;
                    tSButton.setText(MLDesktop.sMLRes.getString("Tool.new_script2.Label"));
                    tSButton.setIcon((Icon)new IconSet(new Icon[]{IconEnumerationUtils.getIcon((String)"new_script_ts_16.png"), IconEnumerationUtils.getIcon((String)"new_script_plus_ts_24.png")}));
                    dTFrame.getTargetingManager().unregister("new_script", (AbstractButton)tSButton);
                }
            }
        });
        tSToolSet.configureAndAdd("new_shortcut", (Action)new ShortcutsToolstripTabFactory.CreateAction());
        tSToolSet.configureAndAdd("open", (Action)((Object)new NamelessChildAction(this.getMLDesktop().getOpenAction())));
        tSToolSet.configureAndAdd("default_open", (Action)new ChildAction(this.getMLDesktop().getOpenAction()));
        tSToolSet.configureAndAdd("find_files", (Action)((Object)new NamelessChildAction(this.getMLDesktop().getFindFilesAction())));
        tSToolSet.configureAndAdd("compare", (Action)new ChildAction(this.getMLDesktop().getLaunchComparisonToolAction()));
        tSToolSet.addListDecorator("open", new TSToolSet.ListDecorator(){

            public void decorateList(PopupList popupList) {
                RecentFiles recentFiles = MLToolstripFactory.this.fDesktop.getRecentFiles();
                for (String string : recentFiles.getToolNames()) {
                    List list = recentFiles.getReopenActions(string);
                    if (list.isEmpty()) continue;
                    DefaultListModel defaultListModel = (DefaultListModel)popupList.getModel();
                    defaultListModel.addElement(ListItem.newHeader((String)recentFiles.getToolLabel(string)));
                    TSFactory.addToPopupList((PopupList)popupList, (List)list, (ListStyle)ListStyle.SINGLE_LINE_DESCRIPTION);
                }
            }
        });
        tSToolSet.configureAndAdd("import", (Action)new ChildAction(this.getMLDesktop().getImportAction()));
        tSToolSet.configureAndAdd("save_workspace", (Action)new ChildAction(this.getMLDesktop().getSaveWorkspaceAction()));
        tSToolSet.configureAndAdd("new_variable", (Action)((Object)new ArrayEditorToolstripTabFactory.NewVariableAction()));
        tSToolSet.configureAndAdd("open_variable", (Action)((Object)new ArrayEditorToolstripTabFactory.OpenWorkspaceVariableAction()));
        tSToolSet.configureAndAdd("clear_workspace", (Action)new ChildAction(this.getMLDesktop().getClearWorkspaceAction()));
        tSToolSet.configureAndAdd("clear_variables", (Action)new ChildAction(this.getMLDesktop().getClearWorkspaceAction()));
        tSToolSet.configureAndAdd("clear_all", (Action)new ChildAction(this.getMLDesktop().getClearAllAction()));
        tSToolSet.configureAndAdd("analyze", CodeReportActionProvider.getActions().get(0));
        tSToolSet.configureAndAdd("launch_profiler", (Action)new ChildAction(this.getMLDesktop().getLaunchProfilerAction()));
        tSToolSet.configureAndAdd("clear_commands", (Action)new ChildAction(this.getMLDesktop().getClearCommandAction()));
        tSToolSet.configureAndAdd("clear_command", (Action)new ChildAction(this.getMLDesktop().getClearCommandAction()));
        tSToolSet.configureAndAdd("clear_history", (Action)new ChildAction(this.getMLDesktop().getClearHistoryAction()));
        tSToolSet.configureAndAdd("settings", (Action)new ChildAction(this.getMLDesktop().getPreferencesAction()));
        tSToolSet.configureAndAdd("set_path", (Action)new ChildAction(this.getMLDesktop().getSetPathAction()));
        tSToolSet.configureAndAdd("add_ons", (Action)((Object)new AddOnsAction("launchGetAddons")));
        tSToolSet.configureAndAdd("get_add_ons", (Action)((Object)new AddOnsAction("launchGetAddons")));
        tSToolSet.configureAndAdd("manage_add_ons", (Action)((Object)new AddOnsAction("launchAddonsManager")));
        tSToolSet.configureAndAdd("package_toolbox", (Action)((Object)new PackageToolboxAction()));
        tSToolSet.configureAndAdd("community", (Action)new ChildAction(this.getMLDesktop().getVisitMatlabCentralAction()));
        tSToolSet.configureAndAdd("support_request", (Action)new ChildAction(this.getMLDesktop().getSupportRequestAction()));
        tSToolSet.configureAndAdd("help", (Action)new ChildAction(this.getMLDesktop().getProductHelpAction()));
        tSToolSet.configureAndAdd("product_help", (Action)new ChildAction(this.getMLDesktop().getProductHelpAction()));
        tSToolSet.configureAndAdd("examples", (Action)new ChildAction(this.getMLDesktop().getExamplesAction()));
        tSToolSet.configureAndAdd("training", (Action)new ChildAction(this.getMLDesktop().getVisitTrainingAction()));
        tSToolSet.configureAndAdd("support", (Action)new ChildAction(this.getMLDesktop().getVisitTechSupportAction()));
        tSToolSet.configureAndAdd("get_products", (Action)new ChildAction(this.getMLDesktop().getVisitTrialsAction()));
        tSToolSet.configureAndAdd("mathworks_site", (Action)new ChildAction(this.getMLDesktop().getVisitWebSiteAction()));
        tSToolSet.configureAndAdd("updates", (Action)new ChildAction(this.getMLDesktop().getCheckForUpdatesAction()));
        tSToolSet.configureAndAdd("terms_of_use", (Action)new ChildAction(this.getMLDesktop().getTermsOfUseAction()));
        tSToolSet.configureAndAdd("patents", (Action)new ChildAction(this.getMLDesktop().getPatentsAction()));
        tSToolSet.configureAndAdd("about", (Action)new ChildAction(this.getMLDesktop().getAboutAction()));
        if (MLToolstripFactory.isTrialVersion()) {
            tSToolSet.configureAndAdd("my_trials", (Action)new ChildAction(this.getMLDesktop().getStartPageAction()));
        } else {
            tSToolSet.getContents().removeTool("my_trials", new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("add_ons")});
        }
    }

    public static void populateNewEditorFileActions(TSToolSet tSToolSet, MLDesktop mLDesktop, String string) {
        tSToolSet.configureAndAdd("new_script", (Action)new ChildAction(mLDesktop.getNewBlankMFileAction()));
        tSToolSet.configureAndAdd("new_function", (Action)new ChildAction(mLDesktop.getNewFunctionMFileAction()));
        tSToolSet.configureAndAdd("new_example", (Action)new ChildAction(mLDesktop.getNewExampleMFileAction()));
        tSToolSet.configureAndAdd("new_class", (Action)new ChildAction(mLDesktop.getNewClassMFileAction()));
        tSToolSet.configureAndAdd("new_enum", (Action)new ChildAction(mLDesktop.getNewEnumerationMFileAction()));
        if (MLDesktop.hasSystemToolbox()) {
            tSToolSet.configureAndAdd("new_basic_template", (Action)((Object)new NewSysObjBasicTemplate()));
            tSToolSet.configureAndAdd("new_advanced_template", (Action)((Object)new NewSysObjAdvancedTemplate()));
            if (MLDesktop.hasSimulinkProjectPlugin()) {
                tSToolSet.configureAndAdd("new_simulink_template", (Action)((Object)new NewSysObjSimulinkTemplate()));
            } else {
                tSToolSet.getContents().removeTool("new_simulink_template", new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("new_system_object")});
            }
        } else {
            tSToolSet.getContents().removeTool("new_system_object", new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency(string)});
        }
        MLToolstripFactory.populateNewRichEditorFileActions(tSToolSet, mLDesktop, string);
    }

    private static void populateNewRichEditorFileActions(TSToolSet tSToolSet, MLDesktop mLDesktop, String string) {
        tSToolSet.configureAndAdd("new_rich_script", (Action)new ChildAction(mLDesktop.getNewRichScriptFileAction()));
        TSToolSetContents.Tool tool = tSToolSet.getContents().getTool("new_rich_script");
        MLToolstripFactory.enableNewRichScriptTool(MlxFileUtils.isRichScriptEnabled(), tSToolSet, tool, string);
    }

    private static void enableNewRichScriptTool(boolean bl, TSToolSet tSToolSet, TSToolSetContents.Tool tool, String string) {
        TSToolSetContents.Dependency dependency = new TSToolSetContents.Dependency(string);
        dependency.setReferenceToolName("new_script");
        dependency.setReferencePosition(TSToolSetContents.Position.AFTER);
        if (tSToolSet.getContents().getTool("new_rich_script") == null && bl) {
            tSToolSet.getContents().addTool(tool, new TSToolSetContents.Dependency[]{dependency});
        }
        if (tSToolSet.getContents().getTool("new_rich_script") != null && !bl) {
            tSToolSet.getContents().removeTool("new_rich_script", new TSToolSetContents.Dependency[]{dependency});
        }
    }

    private TSToolSet getParallelToolSet() {
        if (this.getMLDesktop().hasDCTLicense()) {
            try {
                Class<?> clazz = Class.forName("com.mathworks.toolbox.distcomp.ui.desk.ParallelToolSetFactory");
                Method method = clazz.getMethod("createToolSet", new Class[0]);
                return (TSToolSet)method.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static TSToolSet getSupportPackageInstallerToolSet() {
        try {
            Class<?> clazz = Class.forName("com.mathworks.toolbox.shared.hwconnectinstaller.util.SupportPkgInstallerToolSetFactory");
            Method method = clazz.getMethod("getToolSet", new Class[0]);
            return (TSToolSet)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static Class getAddOnsLauncher() {
        try {
            return Class.forName("com.mathworks.addons.AddonsLauncher");
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        sGlobalPlotGalleryLocation = Prefs.getStringPref((String)"GlobalPlotGalleryLocation", (String)"tab");
        try {
            sHomeTabConfig = new TSTabConfiguration(SimpleDOMUtils.read((URL)MLToolstripFactory.class.getResource("resources/HomeTab.xml")));
            sPlotTabConfig = new TSTabConfiguration(SimpleDOMUtils.read((URL)MLToolstripFactory.class.getResource("resources/PlotTab.xml")));
            sAppsTabConfig = new TSTabConfiguration(SimpleDOMUtils.read((URL)MLToolstripFactory.class.getResource("resources/AppsTab.xml")));
            sHomeToolSetContents = new TSToolSetContents(SimpleDOMUtils.read((URL)MLToolstripFactory.class.getResource("resources/HomeToolset.xml")));
            sPlotSupportSetContents = new TSToolSetContents(SimpleDOMUtils.read((URL)MLToolstripFactory.class.getResource("resources/PlotSupportToolset.xml")));
            sAppsToolSetContents = new TSToolSetContents(SimpleDOMUtils.read((URL)MLToolstripFactory.class.getResource("resources/AppsToolset.xml")));
            if (sHomeTabConfig != null) {
                if (!MLToolstripFactory.includePlotsOnHome()) {
                    sHomeTabConfig.removeSection("plot");
                }
                if (!Matlab.isSimulinkAvailable()) {
                    sHomeTabConfig.removeSection("simulink");
                }
                if (!MLDesktop.hasSystemToolbox()) {
                    sHomeToolSetContents.removeTool("new_system_object", new TSToolSetContents.Dependency[0]);
                } else if (!Matlab.isSimulinkAvailable()) {
                    sHomeToolSetContents.removeTool("new_simulink_template", new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("new_system_object")});
                }
                if (MLToolstripFactory.isTrialVersion()) {
                    sHomeTabConfig.removeTool("resources", "support_request", "home_toolset");
                }
            }
            if (sPlotTabConfig != null && !MLToolstripFactory.showGlobalPlotTab()) {
                sPlotTabConfig.removeSection("selection");
            }
            sFileReadSucceeded = true;
        }
        catch (IOException iOException) {
            Log.logException((Exception)iOException);
        }
        catch (DataFormatException dataFormatException) {
            Log.logException((Exception)dataFormatException);
        }
    }

    private static class NamelessChildAction
    extends ChildAction {
        private NamelessChildAction(Action action) {
            super(action);
            this.putValue("ComponentName", ChildAction.NULL_VALUE);
        }
    }

    private static class PackageToolboxAction
    extends MJAbstractAction {
        private PackageToolboxAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Class<?> clazz = Class.forName("com.mathworks.toolbox_packaging.desktop.ToolboxPackagingClient");
                Method method = clazz.getMethod("launch", new Class[0]);
                method.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class AddOnsAction
    extends MJAbstractAction {
        private final String fMethodName;

        private AddOnsAction(String string) {
            this.fMethodName = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Class clazz = MLToolstripFactory.getAddOnsLauncher();
                clazz.getMethod(this.fMethodName, new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class VariableLabelDecorator
    implements TSToolSet.ToolDecorator {
        private PlotGalleryManager fManager;
        private int fIndex;

        private VariableLabelDecorator(PlotGalleryManager plotGalleryManager, int n) {
            this.fManager = plotGalleryManager;
            this.fIndex = n;
        }

        public void decorateTool(JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
            JLabel jLabel = (JLabel)jComponent;
            jLabel.setPreferredSize(new Dimension(160, 16));
            if (MLToolstripFactory.showGlobalPlotTab()) {
                this.fManager.setVariableLabel(jLabel, this.fIndex);
            }
        }
    }

    private class ToggleShortcutsTabAction
    extends MJAbstractAction {
        private final Toolstrip fToolstrip;

        private ToggleShortcutsTabAction(Toolstrip toolstrip) {
            this.fToolstrip = toolstrip;
            ToolstripTab toolstripTab = (ToolstripTab)toolstrip.getModel().get("shortcuts");
            this.setSelected(toolstripTab != null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLToolstripFactory.this.fShowShortcutsTab = this.isSelected();
            MLToolstripFactory.this.updateShortcutsTabVisibility(this.fToolstrip, true);
        }
    }

    static class Registrar
    implements ToolstripInfoRegistrar {
        Registrar() {
        }

        public void registerToolstripInfo(TSRegistry tSRegistry) {
            if (sFileReadSucceeded) {
                tSRegistry.addTabConfiguration(sHomeTabConfig);
                tSRegistry.addTabConfiguration(sPlotTabConfig);
                tSRegistry.addTabConfiguration(sAppsTabConfig);
                tSRegistry.addToolSetContents(sHomeToolSetContents);
                tSRegistry.addToolSetContents(sAppsToolSetContents);
                if (sHomeToolSet != null) {
                    tSRegistry.addToolSet(sHomeToolSet);
                }
                if (sLayoutToolSet != null) {
                    tSRegistry.addToolSetContents(sLayoutToolSet.getContents());
                }
                sRegistry = tSRegistry;
            }
        }
    }
}

