/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.difftool;

import com.mathworks.mde.difftool.DiffAction;
import com.mathworks.mde.difftool.DiffAgainstAutosaveAction;
import com.mathworks.mde.difftool.DiffAgainstBrowseAction;
import com.mathworks.mde.difftool.DiffToolControl;
import com.mathworks.mde.difftool.DiffToolUtils;
import com.mathworks.mde.difftool.FileDiffToolInfo;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.services.binding.MatlabKeyBindings;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JComponent;

public class FileDiffToolMenu
extends DiffToolControl {
    private final DiffAction fFileDiffSubmenuAction;
    private final DiffAction fDiffAgainstAutosaveAction;
    private final DiffAction fBrowseAndDiffAction;

    public FileDiffToolMenu(FileDiffToolInfo fileDiffToolInfo) {
        this.fFileDiffSubmenuAction = new FileDiffSubmenu(fileDiffToolInfo);
        this.fDiffAgainstAutosaveAction = (DiffAction)new DiffAgainstAutosaveAction(fileDiffToolInfo).getAction();
        this.fBrowseAndDiffAction = (DiffAction)new DiffAgainstBrowseAction(fileDiffToolInfo).getAction();
    }

    public MJMenu getMenu() {
        MJMenu mJMenu = new MJMenu((Action)((Object)this.fFileDiffSubmenuAction));
        mJMenu.add((Action)((Object)this.fDiffAgainstAutosaveAction));
        mJMenu.add((Action)((Object)this.fBrowseAndDiffAction));
        return mJMenu;
    }

    @Override
    public void updateActionStatus() {
        this.fFileDiffSubmenuAction.updateState();
        this.fDiffAgainstAutosaveAction.updateState();
        this.fBrowseAndDiffAction.updateState();
    }

    public void installKeyBindings(JComponent jComponent, int n) {
        MatlabKeyBindings.getManager().addKeyBindings(jComponent, n, (ExtendedAction)this.fDiffAgainstAutosaveAction);
        MatlabKeyBindings.getManager().addKeyBindings(jComponent, n, (ExtendedAction)this.fBrowseAndDiffAction);
    }

    private static boolean isSuitableItemSelected(FileDiffToolInfo fileDiffToolInfo) {
        return fileDiffToolInfo.isSingleFileActive();
    }

    private class FileDiffSubmenu
    extends DiffAction {
        FileDiffSubmenu(FileDiffToolInfo fileDiffToolInfo) {
            super(fileDiffToolInfo);
            this.setComponentName("FileDiffSubmenu");
        }

        @Override
        public void updateState() {
            if (this.iFileInfo.isDirty() || this.iFileInfo.isBuffer()) {
                this.setName(DiffToolUtils.intlString("fileDiffAction.submenuNameDirty"));
            } else {
                this.setName(DiffToolUtils.intlString("fileDiffAction.submenuNameClean"));
            }
            this.setEnabled(FileDiffToolMenu.isSuitableItemSelected(this.iFileInfo));
        }

        @Override
        public DiffToolControl getControl() {
            return FileDiffToolMenu.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

