/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.matlab.api.editor.actions.EditorToolTipDelegate;
import com.mathworks.mde.desk.MLMainFrame;
import com.mathworks.mde.editor.EditorOptions;
import com.mathworks.mde.editor.EditorTabCompletion;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionAction;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionInterface;
import com.mathworks.mlwidgets.text.mcode.MatlabMKit;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.services.Prefs;
import com.mathworks.util.Log;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.osgi.ClasspathOSGiManager;
import com.mathworks.widgets.debug.DebuggerManager;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.text.MWKit;
import com.mathworks.widgets.text.MWToolTipSupport;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.mcode.MTokenUtils;
import com.mathworks.widgets.text.mcode.variables.VariableStatusBarUtils;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtUtilities;

public class EditorMKit
extends MatlabMKit {
    public String getContentType() {
        return MLanguage.INSTANCE.getMimeType();
    }

    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new EditorBuildToolTipAction(), new WordCompletionAction()};
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    protected boolean supportsCodeFolding() {
        return true;
    }

    private static boolean shouldPerformTabCompletion(JTextComponent jTextComponent) {
        return EditorOptions.isTabCompletionEnabled() && EditorMKit.noSelection(jTextComponent) && EditorMKit.isAtEndOfWord(jTextComponent);
    }

    private static boolean noSelection(JTextComponent jTextComponent) {
        return jTextComponent.getSelectionStart() == jTextComponent.getSelectionEnd();
    }

    private static boolean isAtEndOfWord(JTextComponent jTextComponent) {
        boolean bl = false;
        try {
            int n = jTextComponent.getCaretPosition();
            int n2 = Utilities.getWordStart((JTextComponent)jTextComponent, (int)n);
            if (n2 != -1 && n > 0) {
                char c;
                int n3;
                for (n3 = Utilities.getWordEnd((JTextComponent)jTextComponent, (int)(n - 1)); n3 > n && !Character.isLetterOrDigit(c = jTextComponent.getDocument().getText(n3 - 1, 1).charAt(0)); --n3) {
                }
                String string = jTextComponent.getDocument().getText(n2, n - n2);
                if (n == n3 && string.length() > 0) {
                    char c2 = string.charAt(string.length() - 1);
                    bl = Character.isLetter(string.charAt(0)) && (Character.isLetterOrDigit(c2) || c2 == '_') || string.equals(".") || (c2 == '\'' || c2 == ':') && EditorMKit.isUnterminatedString(jTextComponent, n);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            assert (false) : "BadLocationException: " + badLocationException;
            bl = false;
        }
        return bl;
    }

    private static boolean isUnterminatedString(JTextComponent jTextComponent, int n) throws BadLocationException {
        boolean bl = false;
        int n2 = Utilities.getRowStart((BaseDocument)((BaseDocument)jTextComponent.getDocument()), (int)n);
        String string = jTextComponent.getDocument().getText(n2, n - n2);
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\'') continue;
            bl = !bl;
        }
        return bl;
    }

    private static String variableUnderPoint(Point point, STPBaseInterface sTPBaseInterface) {
        try {
            String string;
            int n;
            int n2;
            int n3;
            int n4 = n3 = sTPBaseInterface.getPosFromPoint(point);
            if (n3 < sTPBaseInterface.getLength() - 1) {
                ++n4;
            }
            if ((n2 = sTPBaseInterface.getWordStartFromPos(n4)) == -1) {
                n2 = 0;
            }
            if ((n = sTPBaseInterface.getWordEndFromPos(n3)) == -1) {
                n = sTPBaseInterface.getLength();
            }
            if (n2 > n) {
                n2 = sTPBaseInterface.getWordStartFromPos(n);
            }
            if (n2 == -1) {
                n2 = 0;
            }
            if ((string = EditorMKit.getIdentifier(n2, n, point, sTPBaseInterface)) == null) {
                int n5 = sTPBaseInterface.getWordStartFromPos(n2);
                if (n5 == -1) {
                    n5 = 0;
                }
                if (n5 != n2) {
                    int n6 = sTPBaseInterface.getWordEndFromPos(n5);
                    if (n6 == -1) {
                        n6 = sTPBaseInterface.getLength();
                    }
                    string = EditorMKit.getIdentifier(n5, n6, point, sTPBaseInterface);
                }
            }
            return string;
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            return null;
        }
    }

    private static String getIdentifier(int n, int n2, Point point, STPBaseInterface sTPBaseInterface) {
        try {
            Point point2 = sTPBaseInterface.getPointFromPos(n);
            Point point3 = sTPBaseInterface.getPointFromPos(n2);
            int n3 = 3;
            if (n < n2 && point3.x >= point.x - n3 && point2.x <= point.x + n3 && MTokenUtils.isIdentifier((BaseDocument)((BaseDocument)sTPBaseInterface.getDocument()), (int)n, (int)n2)) {
                String string = sTPBaseInterface.getTextStartEnd(n, n2);
                assert (string != null && string.length() > 0) : "An identifier has been found, word cannot be empty";
                return string;
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        return null;
    }

    private static EditorToolTipDelegate getApplicableEditorToolTipDelegateToUse() {
        ArrayList<EditorToolTipDelegate> arrayList = new ArrayList<EditorToolTipDelegate>();
        for (EditorToolTipDelegate editorToolTipDelegate : ClasspathOSGiManager.getInstance().getImplementors(EditorToolTipDelegate.class)) {
            if (!editorToolTipDelegate.isApplicable()) continue;
            arrayList.add(editorToolTipDelegate);
        }
        EditorUtils.sortPrioritizables(arrayList);
        return (EditorToolTipDelegate)arrayList.get(0);
    }

    static {
        VariableStatusBarUtils.setStatusInfoProvider((VariableStatusBarUtils.VariableHighlightingLayerStatusInfoProvider)new VariableStatusBarUtils.VariableHighlightingLayerStatusInfoProvider(){

            public boolean matchesMatlabStatusText(String string) {
                DTFrame dTFrame;
                Desktop desktop = MatlabDesktopServices.getDesktop();
                boolean bl = false;
                if (desktop != null && (dTFrame = desktop.getMainFrame()) != null && dTFrame instanceof MLMainFrame) {
                    String string2 = ((MLMainFrame)dTFrame).getMatlabStatusText();
                    bl = string2 != null && string2.equals(string);
                }
                return bl;
            }
        });
    }

    public static class EditorBuildToolTipAction
    extends MWKit.MWBuildToolTipAction {
        private Font fDataTipFont = new Font("Monospaced", 0, 12);

        public void actionPerformed(final ActionEvent actionEvent, final JTextComponent jTextComponent) {
            String string;
            MWToolTipSupport mWToolTipSupport;
            boolean bl = false;
            if (EditorBuildToolTipAction.shouldShowDataTip() && jTextComponent != null && (mWToolTipSupport = (MWToolTipSupport)ExtUtilities.getExtEditorUI((JTextComponent)jTextComponent).getToolTipSupport()) != null && (string = EditorMKit.variableUnderPoint(mWToolTipSupport.getLastMouseEvent().getPoint(), (STPBaseInterface)jTextComponent)) != null) {
                bl = true;
                EditorToolTipDelegate editorToolTipDelegate = EditorMKit.getApplicableEditorToolTipDelegateToUse();
                editorToolTipDelegate.computeTooltip(string, (ParameterRunnable)new ParameterRunnable<String>(){

                    public void run(String string) {
                        if (string.length() > 0) {
                            if (EditorBuildToolTipAction.this.fDataTipFont.getSize() != jTextComponent.getFont().getSize()) {
                                EditorBuildToolTipAction.this.fDataTipFont = EditorBuildToolTipAction.this.fDataTipFont.deriveFont((float)jTextComponent.getFont().getSize());
                            }
                            mWToolTipSupport.setToolTipTextAndFont(string, EditorBuildToolTipAction.this.fDataTipFont);
                        } else {
                            EditorBuildToolTipAction.super.actionPerformed(actionEvent, jTextComponent);
                        }
                    }
                });
            }
            if (!bl) {
                super.actionPerformed(actionEvent, jTextComponent);
            }
        }

        private static boolean shouldShowDataTip() {
            return Prefs.getBooleanPref((String)"EditorEnableDataTips") || DebuggerManager.isDebugging();
        }
    }

    public static class WordCompletionAction
    extends MWKit.TabKeyAction {
        private final MJAbstractAction iCompletion = new TabCompletionAction((TabCompletionInterface)new EditorTabCompletion());

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EditorMKit.shouldPerformTabCompletion(jTextComponent)) {
                this.iCompletion.actionPerformed(actionEvent);
            } else {
                super.actionPerformed(actionEvent, jTextComponent);
            }
        }
    }
}

