/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.common.icons.ApplicationIcon;
import com.mathworks.common.icons.IconContainer;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorLanguage;
import com.mathworks.matlab.api.editor.EditorToolstripTabContributor;
import com.mathworks.matlab.api.editor.actions.Prioritizable;
import com.mathworks.matlab.api.toolbars.ToolBarID;
import com.mathworks.mde.editor.DialogFactory;
import com.mathworks.mde.editor.EditorAction;
import com.mathworks.mde.editor.EditorMatlab;
import com.mathworks.mde.editor.MatlabEditorApplication;
import com.mathworks.mde.editor.RealMatlab;
import com.mathworks.mde.editor.plugins.matlab.ConfigurationPopupMenuCustomizer;
import com.mathworks.mde.editor.plugins.matlab.MatlabPluginUtils;
import com.mathworks.mde.editor.plugins.matlab.MatlabToolBarContributor;
import com.mathworks.mde.editor.plugins.matlab.RunMenu;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlservices.MatlabExecutionErrorHandler;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.dialog.filters.CodeGenProductFileExtensionFilter;
import com.mathworks.mlwidgets.mlservices.scc.SccFileProvider;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.FileExtensionFilter;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.datatransfer.MJDataFlavor;
import com.mathworks.services.mlx.MlxFileUtils;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.factory.TSRegistry;
import com.mathworks.toolstrip.factory.TSTabConfiguration;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import com.mathworks.util.osgi.ClasspathOSGiManager;
import com.mathworks.widgets.text.EditorLanguageUtils;
import com.mathworks.widgets.text.EditorPreferences;
import com.mathworks.widgets.text.STPModelInterface;
import com.mathworks.widgets.text.mcode.MDocumentUtils;
import com.mathworks.widgets.text.mcode.MTokenUtils;
import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.toolbars.DefaultToolBarID;
import java.awt.Component;
import java.awt.Frame;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.Nullable;
import org.netbeans.editor.BaseDocument;

public final class EditorUtils {
    private static final String EDITOR_GROUP_NAME = "Editor";
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(EditorUtils.class.getPackage().getName() + ".resources.RES_Editor");
    private static final ResourceBundle PREFS_BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
    public static final String RUN_ACTION_ID = "run-from-toolbar";
    public static final String STOP_ACTION_ID = "stop-from-toolbar";
    public static final String EDITOR_TITLE = EditorUtils.lookup("MATLABEditor");
    static final Icon EDITOR_ICON = PlatformInfo.isWindows() ? ApplicationIcon.EDITOR_32x32.getIcon() : ApplicationIcon.EDITOR_48x48.getIcon();
    static final Icon SMALL_ICON = ApplicationIcon.EDITOR.getIcon();
    private static int sUntitledCount;
    private static EditorMatlab sMatlab;
    public static final String DOT_M = ".m";
    public static final String DOT_SSC = ".ssc";
    public static final String PATH_DIALOG_HELP_PREFIX = "ml_env_ed";
    public static final String TEXT_MENU_NAME = "TextMenu";
    public static final String CODE_FOLD_MENU_NAME = "CodeFoldingMenu";
    public static final String GO_MENU_NAME = "GoMenu";
    public static final String TOOLS_MENU_NAME = "ToolsMenu";
    public static final ToolBarID MAIN_TOOLBAR_ID;

    private EditorUtils() {
    }

    public static EditorMatlab getMatlab() {
        return sMatlab;
    }

    private static void setMatlab(EditorMatlab editorMatlab) {
        sMatlab = editorMatlab;
    }

    static boolean isMatlabAvailable() {
        return sMatlab != null;
    }

    static void exitDebugMode() {
        assert (EditorUtils.isMatlabAvailable()) : "MATLAB not available";
        EditorUtils.getMatlab().eval("dbquit all", null, 1024);
    }

    public static String lookup(String string) throws MissingResourceException {
        try {
            return BUNDLE.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            throw missingResourceException;
        }
    }

    public static String lookupInPrefsBundle(String string) {
        return PREFS_BUNDLE.getString(string);
    }

    public static String previewUntitledFilename() {
        return EditorUtils.createUntitledFilename(sUntitledCount + 1);
    }

    static String getNextUntitledFilename() {
        ++sUntitledCount;
        return EditorUtils.getLastGeneratedUntitledFilename();
    }

    public static String getLastGeneratedUntitledFilename() {
        return EditorUtils.createUntitledFilename(sUntitledCount);
    }

    private static String createUntitledFilename(int n) {
        String string = EditorUtils.getUntitledString();
        if (n > 1) {
            string = string + n;
        }
        return string;
    }

    public static String getUntitledString() {
        return PlatformInfo.isWindows() ? EditorUtils.lookup("name.untitled.pc") : EditorUtils.lookup("name.untitled.unix");
    }

    public static CompletionObserver getShowErrorDialogCompletionObserver(final Frame frame) {
        return new CompletionObserver(){

            public void completed(int n, final Object object) {
                if (object == null || ((CharSequence)object).length() == 0) {
                    return;
                }
                if (Matlab.getExecutionStatus((int)n) != 0) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            this.dispatchError((String)object);
                        }
                    });
                } else {
                    this.dispatchInfo((String)object);
                }
            }

            private void dispatchInfo(String string) {
                try {
                    String string2 = "['" + StringUtils.quoteSingleQuotes((String)string) + "']";
                    string2 = StringUtils.replaceAllStrings((String)string2, (String)"\n", (String)"' char(10) '");
                    EditorUtils.getMatlab().evalConsoleOutput("disp(" + string2 + ")");
                }
                catch (Exception exception) {
                    Log.logException((Exception)exception);
                }
            }

            private void dispatchError(String string) {
                DialogFactory.showErrorMessage(frame, string);
            }
        };
    }

    public static MatlabListener createErrorListener(final Component component) {
        return new MatlabListener(){

            public void matlabEvent(MatlabEvent matlabEvent) {
                String string;
                if ((Matlab.getExecutionStatus((int)matlabEvent.getStatus()) == 1 || Matlab.getExecutionStatus((int)matlabEvent.getStatus()) == 2) && matlabEvent.getResult() instanceof String && (string = (String)matlabEvent.getResult()).length() > 0) {
                    DialogFactory.showErrorMessage(component, string);
                }
            }
        };
    }

    static String getFunctionName(STPModelInterface sTPModelInterface, int n) {
        return MDocumentUtils.getFunctionName((MTree)MDocumentUtils.getMTree((BaseDocument)((BaseDocument)sTPModelInterface.getDocument())), (int)n);
    }

    static String getClassName(STPModelInterface sTPModelInterface) {
        return MDocumentUtils.getFirstClassName((MTree)MDocumentUtils.getMTree((BaseDocument)((BaseDocument)sTPModelInterface.getDocument())));
    }

    static void invokeAndWait(Runnable runnable) {
        try {
            AWTUtilities.invokeAndWait((Runnable)runnable);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static Object invokeAndWait(AWTUtilities.InvocationRunnable invocationRunnable) {
        try {
            return AWTUtilities.invokeAndWait((AWTUtilities.InvocationRunnable)invocationRunnable);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static boolean processFileDrop(DropTargetDropEvent dropTargetDropEvent) {
        boolean bl = false;
        try {
            if (MJDataFlavor.isDecodableFileFlavor((DropTargetDropEvent)dropTargetDropEvent)) {
                File[] fileArray;
                dropTargetDropEvent.acceptDrop(1);
                for (File file : fileArray = MJDataFlavor.decodeJavaFileListFlavor((Transferable)dropTargetDropEvent.getTransferable())) {
                    if (!file.isFile()) continue;
                    EditorUtils.openFileInAppropriateEditor(file);
                }
                dropTargetDropEvent.dropComplete(true);
                bl = true;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }

    public static Editor openFileInAppropriateEditor(File file) {
        Editor editor = null;
        if (!MlxFileUtils.isMlxExtensionFile((String)file.getAbsolutePath()) || MlxFileUtils.isPlainTextMlx((File)file) || !MlxFileUtils.isRichScriptEnabled()) {
            editor = MLEditorServices.getEditorApplication().openEditor(file);
        } else {
            try {
                Class<?> clazz = Class.forName("com.mathworks.mde.richeditor.RichEditorApplication");
                Method method = clazz.getMethod("getInstance", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                Method method2 = object.getClass().getMethod("openRichEditor", File.class);
                method2.invoke(object, file);
            }
            catch (Exception exception) {
                editor = MLEditorServices.getEditorApplication().openEditor(file);
            }
        }
        return editor;
    }

    public static void openFileInAppropriateEditorAndGoToLine(File file, int n, int n2) {
        Editor editor = EditorUtils.openFileInAppropriateEditor(file);
        if (editor != null) {
            editor.goToLine(n, n2);
        }
    }

    public static SccFileProvider getSccFileProvider() {
        return MatlabEditorApplication.getInstance().getSccFileProvider();
    }

    static String getFullLineText(STPModelInterface sTPModelInterface, int n) throws BadLocationException {
        assert (sTPModelInterface.getDocument() instanceof BaseDocument);
        int n2 = sTPModelInterface.getLineEndNoEOL(n);
        int n3 = MTokenUtils.getMLineStart((BaseDocument)((BaseDocument)sTPModelInterface.getDocument()), (int)n2);
        int n4 = MTokenUtils.getMLineEnd((BaseDocument)((BaseDocument)sTPModelInterface.getDocument()), (int)n2);
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = sTPModelInterface.getTextStartEnd(n3, n4).split("\n");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuilder.append(EditorUtils.stripContinuesAndComments(stringArray[i]));
        }
        if (stringArray.length > 0) {
            stringBuilder.append(stringArray[stringArray.length - 1]);
        }
        return stringBuilder.toString();
    }

    private static String stripContinuesAndComments(String string) {
        int n = string.indexOf("...");
        int n2 = string.indexOf("%");
        if (n == -1 && n2 == -1) {
            return string;
        }
        n = n == -1 || n2 == -1 ? Math.max(n, n2) : Math.min(n, n2);
        return string.substring(0, n);
    }

    public static MJFileChooserPerPlatform createFileChooser(File file) {
        MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform(file);
        mJFileChooserPerPlatform.setDialogTitle(EditorUtils.lookup("title.OpenFile"));
        mJFileChooserPerPlatform.setMultiSelectionEnabled(true);
        mJFileChooserPerPlatform.setFileMustExist(true);
        HashSet<List> hashSet = new HashSet<List>();
        for (EditorLanguage editorLanguage : EditorLanguageUtils.getLanguages()) {
            List list = EditorPreferences.getFileExtensions((EditorLanguage)editorLanguage);
            if (hashSet.contains(list) || list.isEmpty()) continue;
            String string = MessageFormat.format(EditorUtils.lookup("fileFilter"), editorLanguage.getName());
            mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)new FileExtensionFilter(string, list, true));
            hashSet.add(list);
        }
        mJFileChooserPerPlatform.setAllowMacBundles(false);
        mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)CodeGenProductFileExtensionFilter.getCodeGenFileFilter());
        return mJFileChooserPerPlatform;
    }

    public static String getEditorGroupTitle() {
        return EditorUtils.lookup("find.title");
    }

    public static String getEditorGroupName() {
        return EDITOR_GROUP_NAME;
    }

    public static String createCannotOpenDirectoryMessage(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("The given file must be a directory.");
        }
        return MessageFormat.format(EditorUtils.lookup("error.CannotOpenDirectory"), file.getName());
    }

    static Collection<EditorToolstripTabContributor> getEditorToolstripTabContributors() {
        return ClasspathOSGiManager.getInstance().getImplementors(EditorToolstripTabContributor.class);
    }

    public static List<EditorToolstripTabContributor> getEditorToolstripTabContributorsOfType(Collection<EditorToolstripTabContributor> collection, EditorToolstripTabContributor.Tab tab) {
        ArrayList<EditorToolstripTabContributor> arrayList = new ArrayList<EditorToolstripTabContributor>();
        for (EditorToolstripTabContributor editorToolstripTabContributor : collection) {
            if (tab != editorToolstripTabContributor.getTabToContribute()) continue;
            arrayList.add(editorToolstripTabContributor);
        }
        return arrayList;
    }

    public static List<EditorToolstripTabContributor> getOrderedApplicableEditorTabContributorsOfType(Editor editor, Collection<EditorToolstripTabContributor> collection, EditorToolstripTabContributor.Tab tab) {
        ArrayList<EditorToolstripTabContributor> arrayList = new ArrayList<EditorToolstripTabContributor>();
        List<EditorToolstripTabContributor> list = EditorUtils.getEditorToolstripTabContributorsOfType(collection, tab);
        for (EditorToolstripTabContributor editorToolstripTabContributor : list) {
            if (!editorToolstripTabContributor.isApplicable(editor)) continue;
            arrayList.add(editorToolstripTabContributor);
        }
        EditorUtils.sortPrioritizables(arrayList);
        return arrayList;
    }

    public static void registerEditorTabContributorToolsets(TSRegistry tSRegistry, TSTabConfiguration tSTabConfiguration, EditorToolstripTabContributor.Tab tab) {
        List<EditorToolstripTabContributor> list = EditorUtils.getEditorToolstripTabContributorsOfType(EditorUtils.getEditorToolstripTabContributors(), tab);
        for (EditorToolstripTabContributor editorToolstripTabContributor : list) {
            TSTabConfiguration tSTabConfiguration2 = editorToolstripTabContributor.getTSTabConfiguration();
            tSTabConfiguration2.setContributeToName(tSTabConfiguration.getName());
            tSRegistry.addTabConfiguration(tSTabConfiguration2);
            for (TSToolSet tSToolSet : editorToolstripTabContributor.getSupportingToolSets()) {
                tSRegistry.addToolSetContents(tSToolSet.getContents());
            }
        }
    }

    public static <T extends Prioritizable> void sortPrioritizables(List<T> list) {
        Collections.sort(list, EditorUtils.createPrioritizerComparator());
    }

    static <T extends Prioritizable> Comparator<T> createPrioritizerComparator() {
        return new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                Integer n = t.getPriority();
                return n.compareTo(t2.getPriority()) * -1;
            }
        };
    }

    public static Action createRunOrPublishAction(Editor editor, EditorAction editorAction, String string, IconContainer iconContainer, AbstractFileConfiguration.Type<?> type) {
        return EditorUtils.createRunOrPublishAction(editor, editorAction, string, iconContainer, type, null);
    }

    public static Action createRunOrPublishAction(final Editor editor, EditorAction editorAction, String string, IconContainer iconContainer, final AbstractFileConfiguration.Type<?> type, final @Nullable RunMenu runMenu) {
        EditorAction.ObservableAction observableAction = editorAction.getAction();
        observableAction.setObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                MatlabExecutionErrorHandler matlabExecutionErrorHandler = runMenu != null ? runMenu.getMatlabExecutionErrorHandler() : null;
                MatlabPluginUtils.executeDefaultConfiguration(editor, type, matlabExecutionErrorHandler);
            }
        });
        ChildAction childAction = new ChildAction((Action)((Object)observableAction), false);
        childAction.setName(string);
        childAction.putValue("buttonIcon", (Object)iconContainer.getIcon());
        childAction.putValue("toolTipProvider", (Object)MatlabToolBarContributor.createToolTipProvider(editor, type));
        childAction.putValue("PopupListener", (Object)new PopupListener(){

            public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                if (runMenu == null) {
                    ConfigurationPopupMenuCustomizer configurationPopupMenuCustomizer = MatlabPluginUtils.createMenuCustomizer(editor, type);
                    MJPopupMenu mJPopupMenu = new MJPopupMenu();
                    configurationPopupMenuCustomizer.customize((JPopupMenu)mJPopupMenu);
                    popupCallback.show((JComponent)mJPopupMenu);
                } else {
                    runMenu.show(popupCallback);
                }
            }
        });
        return childAction;
    }

    static {
        sMatlab = Matlab.isMatlabAvailable() ? new RealMatlab() : null;
        MAIN_TOOLBAR_ID = new DefaultToolBarID("Editor Toolbar", EditorUtils.lookup("toolbar.editor"));
    }
}

