/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorToolstripTabContributor;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.editor.ActionID;
import com.mathworks.mde.editor.ActionManager;
import com.mathworks.mde.editor.EditorGroup;
import com.mathworks.mde.editor.EditorOptions;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.EditorViewClient;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.SimpleDOMUtils;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.toolstrip.factory.TSRegistry;
import com.mathworks.toolstrip.factory.TSTabConfiguration;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.widgets.desk.ToolstripInfoRegistrar;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.zip.DataFormatException;
import javax.swing.Action;
import javax.swing.text.EditorKit;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.ext.ExtKit;

public class EditorViewToolSetFactory {
    private static final TSTabConfiguration TAB_CONFIG = EditorViewToolSetFactory.readTabConfiguration("ViewTab.xml");
    private static final TSToolSetContents CONTENTS = TSToolSetContents.readToolSetContents(EditorViewToolSetFactory.class, (String)"resources/ViewToolset.xml");
    private final ActionManager fActionManager;
    private final Editor fEditor;
    private TSToolSet fToolSet;
    private MJAbstractAction fHighlightAction;
    private MJAbstractAction fShowLineNumbersAction;
    private MJAbstractAction fEnableDataTipsAction;
    private PrefListener fPrefListener;
    private TSToolSet fDefaultToolSet;

    public EditorViewToolSetFactory(Editor editor, ActionManager actionManager) {
        Validate.notNull((Object)editor, (String)"'editor' cannot be null");
        Validate.notNull((Object)actionManager, (String)"'actionManager' cannot be null");
        this.fEditor = editor;
        this.fActionManager = actionManager;
        this.fDefaultToolSet = MLDesktop.getInstance().getDefaultViewTabFactory().createToolSet(EditorUtils.getEditorGroupName());
        this.fToolSet = new TSToolSet(CONTENTS);
        this.populateSplitSection();
        this.populateCodeFoldingSection();
        this.populateDisplaySection();
    }

    public TSTabConfiguration getTabConfig() {
        TSTabConfiguration tSTabConfiguration = EditorViewToolSetFactory.readTabConfiguration("ViewTab.xml");
        if (!this.includeDockedControls()) {
            tSTabConfiguration.removeSection("tiles");
            tSTabConfiguration.removeSection("document_bar");
        }
        return tSTabConfiguration;
    }

    public TSToolSet[] getToolSets() {
        if (this.includeDockedControls()) {
            return new TSToolSet[]{this.fToolSet, this.fDefaultToolSet};
        }
        return new TSToolSet[]{this.fToolSet};
    }

    private boolean includeDockedControls() {
        Component component = this.fEditor.getComponent();
        MLDesktop mLDesktop = MLDesktop.getInstance();
        return mLDesktop.hasClient(component) ? mLDesktop.isClientDocked(component) : mLDesktop.willDockNewDocumentInGroup(EditorGroup.getTitle());
    }

    public void dispose() {
        Prefs.removeListener((PrefListener)this.fPrefListener);
    }

    private void populateSplitSection() {
        this.fToolSet.configureAndAdd("split_left_right", (Action)new ChildAction(this.fActionManager.getSplitScreenActions().getSplitLeftRightAction()));
        this.fToolSet.configureAndAdd("split_top_bottom", (Action)new ChildAction(this.fActionManager.getSplitScreenActions().getSplitTopBottomAction()));
        this.fToolSet.configureAndAdd("split_none", (Action)new ChildAction(this.fActionManager.getSplitScreenActions().getSplitNoneAction()));
    }

    private void populateCodeFoldingSection() {
        EditorKit editorKit = ((EditorViewClient)((Object)this.fEditor.getComponent())).getEditorView().getSyntaxTextPane().getEditorKit();
        boolean bl = editorKit instanceof ExtKit && ((ExtKit)editorKit).isCodeFoldingEnabled();
        this.populateCodeFoldingAction("fold_expand", ActionID.EXPAND_FOLD, bl);
        this.populateCodeFoldingAction("fold_collapse", ActionID.COLLAPSE_FOLD, bl);
        this.populateCodeFoldingAction("fold_expand_all", ActionID.EXPAND_ALL_FOLDS, bl);
        this.populateCodeFoldingAction("fold_collapse_all", ActionID.COLLAPSE_ALL_FOLDS, bl);
    }

    private void populateCodeFoldingAction(String string, ActionID actionID, boolean bl) {
        ChildAction childAction = new ChildAction((Action)this.fActionManager.getAction(actionID), false);
        childAction.setEnabled(bl);
        this.fToolSet.configureAndAdd(string, (Action)childAction);
    }

    private void populateDisplaySection() {
        this.fHighlightAction = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorOptions.setCaretRowHighlightingOptions(this.isSelected(), EditorOptions.getHighlightCaretRowColor());
            }
        };
        this.fToolSet.configureAndAdd("highlight_line", (Action)this.fHighlightAction);
        this.fShowLineNumbersAction = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorOptions.setShowLineNumbers(this.isSelected());
            }
        };
        this.fToolSet.configureAndAdd("show_line_numbers", (Action)this.fShowLineNumbersAction);
        this.fEnableDataTipsAction = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorOptions.setDataTips(this.isSelected());
            }
        };
        this.fToolSet.configureAndAdd("enable_datatips", (Action)this.fEnableDataTipsAction);
        this.fPrefListener = new PrefListener(){

            public void prefChanged(PrefEvent prefEvent) {
                EditorViewToolSetFactory.this.updateCheckBoxes();
            }
        };
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorShowLineNumbers");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"Editorhighlight-caret-row-boolean");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorEnableDataTips");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"CodepadModeOn2");
        this.updateCheckBoxes();
    }

    private void updateCheckBoxes() {
        this.fHighlightAction.setSelected(EditorOptions.isCaretRowHighlightingOn());
        this.fShowLineNumbersAction.setSelected(EditorOptions.getShowLineNumbers());
        this.fEnableDataTipsAction.setSelected(EditorOptions.getDataTips());
    }

    private static TSTabConfiguration readTabConfiguration(String string) {
        try {
            return new TSTabConfiguration(SimpleDOMUtils.read((URL)EditorViewToolSetFactory.class.getResource("resources/" + string)));
        }
        catch (DataFormatException dataFormatException) {
            throw new RuntimeException(dataFormatException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static class Registrar
    implements ToolstripInfoRegistrar {
        public void registerToolstripInfo(TSRegistry tSRegistry) {
            tSRegistry.addTabConfiguration(TAB_CONFIG);
            tSRegistry.addToolSetContents(CONTENTS);
            EditorUtils.registerEditorTabContributorToolsets(tSRegistry, TAB_CONFIG, EditorToolstripTabContributor.Tab.VIEW);
        }
    }
}

