/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.recordlist.AbstractRecordlistModel;
import com.mathworks.widgets.recordlist.IRecordlistModel;
import com.mathworks.widgets.recordlist.RecordlistModelEvent;
import com.mathworks.widgets.recordlist.RecordlistTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class GoToDialogPanel
extends MJPanel {
    public static final String GOTO_LINE_OPTION_NAME = "radiobutton-goto-line";
    public static final String GOTO_LINE_FIELD_NAME = "textfield-goto-line";
    public static final String GOTO_FUNCTION_CELL_OPTION_NAME = "radiobutton-goto-function-cell";
    public static final String TABLE_NAME = "table-function-cell";
    public static final String SHOW_CELLS_NAME = "checkbox-show-cells-in-table";
    public static final String SHOW_FUNCTIONS_NAME = "checkbox-show-functions-in-table";
    public static final String OK_NAME = "button-ok";
    public static final String CANCEL_NAME = "button-cancel";
    private RecordlistTable fFunctionCellTable;
    private FunctionCellModel fFunctionCellModel;
    private MJRadioButton fLineNumberButton;
    private MJLabel fLineNumberLabel;
    private MJRadioButton fFunctionCellButton;
    private MJTextField fLineTextField;
    private MJCheckBox fShowFunctionsCheckBox;
    private MJCheckBox fShowCellsCheckBox;
    private MJPanel fFunctionCellPanel;
    private WindowAdapter fWindowListener = new GotoDialogListener();
    private MJButton fOKButton;
    private MJButton fCancelButton;
    private int fSelectedLineNumber;
    private Object fCompareObject = null;
    static final int GAP_SIZE = 8;
    private MJDialog fParentDialog;

    GoToDialogPanel(Component component, Object[] objectArray, int[] nArray, Object[] objectArray2, int[] nArray2, int n, Object object, MJDialog mJDialog) {
        this.fCompareObject = object;
        this.fSelectedLineNumber = -1;
        this.setLayout(new GridBagLayout());
        this.fFunctionCellModel = new FunctionCellModel(objectArray, nArray, objectArray2, nArray2, true, true);
        this.fFunctionCellTable = new RecordlistTable((IRecordlistModel)this.fFunctionCellModel){

            public Dimension getPreferredScrollableViewportSize() {
                int n = this.getRowHeight();
                int n2 = this.getRowCount() * n;
                n2 = Math.max(n2, 3 * n);
                return new Dimension(230, Math.min(8 * n, n2));
            }
        };
        this.fFunctionCellTable.setName(TABLE_NAME);
        this.fFunctionCellTable.setColumnComparator(0, GoToDialogPanel.getGotoObjectComparator());
        this.fFunctionCellTable.getAccessibleContext().setAccessibleName(EditorUtils.lookup("dialog.gotoTable.acc"));
        this.fFunctionCellTable.setFullCellSelection(true);
        this.fLineNumberButton = new MJRadioButton(EditorUtils.lookup("dialog.gotoLineNumber"));
        this.fLineNumberButton.setName(GOTO_LINE_OPTION_NAME);
        this.fLineTextField = new MJTextField(new PositiveNumberDocument(), String.valueOf(n), 6){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.fLineTextField.setName(GOTO_LINE_FIELD_NAME);
        this.fLineTextField.getAccessibleContext().setAccessibleName(EditorUtils.lookup("dialog.gotoLineNumber.acc"));
        this.fFunctionCellButton = new MJRadioButton();
        this.fFunctionCellButton.setName(GOTO_FUNCTION_CELL_OPTION_NAME);
        this.fFunctionCellTable.setColumnSelectionAllowed(false);
        this.fFunctionCellTable.setAutoResizeMode(4);
        this.fFunctionCellTable.setFillEmptyColumnHeader(false);
        this.fFunctionCellTable.setShowGrid(false);
        this.fFunctionCellTable.getColumnModel().getColumn(0).setPreferredWidth(190);
        this.fFunctionCellTable.getSelectionModel().setSelectionMode(0);
        this.fFunctionCellTable.sortByColumn(0, 0);
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fFunctionCellTable);
        mJScrollPane.getViewport().getAccessibleContext().setAccessibleName(EditorUtils.lookup("dialog.gotoTableScrollPane.acc"));
        mJScrollPane.setHorizontalScrollBarPolicy(30);
        mJScrollPane.getViewport().setBackground(this.fFunctionCellTable.getBackground());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fLineNumberButton);
        buttonGroup.add((AbstractButton)this.fFunctionCellButton);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GoToDialogPanel.this.enableOptions();
            }
        };
        this.fLineNumberButton.addActionListener(actionListener);
        this.fFunctionCellButton.addActionListener(actionListener);
        this.fFunctionCellTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (GoToDialogPanel.this.fLineNumberButton.isSelected()) {
                    int n = GoToDialogPanel.this.fFunctionCellTable.rowAtPoint(mouseEvent.getPoint());
                    if (n != -1) {
                        GoToDialogPanel.this.fFunctionCellTable.setRowSelectionInterval(n, n);
                    }
                    GoToDialogPanel.this.fFunctionCellButton.doClick();
                }
            }
        });
        this.fLineTextField.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (GoToDialogPanel.this.fFunctionCellButton.isSelected()) {
                    GoToDialogPanel.this.fLineNumberButton.doClick();
                }
            }
        });
        this.fFunctionCellTable.setDefaultAction(new MJAbstractAction("enter action"){

            public void actionPerformed(ActionEvent actionEvent) {
                GoToDialogPanel.this.fOKButton.doClick();
            }
        });
        this.fFunctionCellTable.setSelectionPopupMenu(null);
        String string = "escape action";
        this.fFunctionCellTable.getInputMap().put(KeyStroke.getKeyStroke(27, 0), string);
        this.fFunctionCellTable.getActionMap().put(string, (Action)new MJAbstractAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                GoToDialogPanel.this.fCancelButton.doClick();
            }
        });
        this.fShowFunctionsCheckBox = new MJCheckBox(EditorUtils.lookup("dialog.gotoShowFunctions"), true);
        this.fShowFunctionsCheckBox.setName(SHOW_FUNCTIONS_NAME);
        this.fShowCellsCheckBox = new MJCheckBox(EditorUtils.lookup("dialog.gotoShowCells"), true);
        this.fShowCellsCheckBox.setName(SHOW_CELLS_NAME);
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GoToDialogPanel.this.fFunctionCellModel.setUseFunctionCellInfo(GoToDialogPanel.this.fShowFunctionsCheckBox.isSelected(), GoToDialogPanel.this.fShowCellsCheckBox.isSelected());
            }
        };
        this.fShowFunctionsCheckBox.addActionListener(actionListener2);
        this.fShowCellsCheckBox.addActionListener(actionListener2);
        GridBagConstraints gridBagConstraints = this.addLineNumberLabel((JComponent)this.fLineNumberButton, false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 8);
        this.add((Component)this.fLineTextField, gridBagConstraints);
        this.addFunctionCellLabel((JComponent)this.fFunctionCellButton);
        this.fFunctionCellPanel = new MJPanel((LayoutManager)new GridBagLayout());
        this.fFunctionCellPanel.setBorder(BorderFactory.createEmptyBorder(0, 24, 0, 24));
        GridBagConstraints gridBagConstraints2 = this.addFunctionCellTable((JComponent)this.fFunctionCellPanel);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        this.fFunctionCellPanel.add((Component)mJScrollPane, (Object)gridBagConstraints2);
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout());
        this.fOKButton = new MJButton(MJUtilities.intlString((String)"labelOK"));
        this.fOKButton.setName(OK_NAME);
        this.fCancelButton = new MJButton(MJUtilities.intlString((String)"labelCancel"));
        this.fCancelButton.setName(CANCEL_NAME);
        this.fOKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                try {
                    GoToDialogPanel.this.updateSelectedLineNumber();
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
                if (bl) {
                    GoToDialogPanel.this.closeParentDialog();
                }
            }
        });
        this.fCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GoToDialogPanel.this.closeParentDialog();
            }
        });
        if (PlatformInfo.isMacintosh()) {
            mJPanel.add((Component)this.fCancelButton);
            mJPanel.add((Component)this.fOKButton);
        } else {
            mJPanel.add((Component)this.fOKButton);
            mJPanel.add((Component)this.fCancelButton);
        }
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridwidth = 3;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.insets = new Insets(8, 0, 8, 0);
        this.add((Component)mJPanel, gridBagConstraints2);
        mJScrollPane.setFocusable(false);
        mJScrollPane.getHorizontalScrollBar().setFocusable(false);
        mJScrollPane.getVerticalScrollBar().setFocusable(false);
        this.updateVisibleGUIOptions(objectArray, objectArray2);
        this.fLineNumberButton.setSelected(true);
        this.parentDialog(component, mJDialog);
        this.fParentDialog.setFocusTarget((Component)this.fLineTextField);
    }

    private static Comparator<Object> getGotoObjectComparator() {
        return new GotoObjectComparator();
    }

    private boolean updateVisibleGUIOptions(Object[] objectArray, Object[] objectArray2) {
        boolean bl;
        boolean bl2 = false;
        if (MLDesktop.getInstance().useToolstrip()) {
            objectArray = new Object[]{};
            objectArray2 = new Object[]{};
        }
        if (objectArray.length > 0 && objectArray2.length > 0) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            this.fFunctionCellPanel.add((Component)this.fShowFunctionsCheckBox, (Object)gridBagConstraints);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 1;
            this.fFunctionCellPanel.add((Component)this.fShowCellsCheckBox, (Object)gridBagConstraints);
            this.fFunctionCellButton.setText(EditorUtils.lookup("dialog.gotoFunctionCellTitle"));
            if (this.fLineNumberLabel != null) {
                bl2 = true;
            }
            bl = true;
        } else {
            this.fFunctionCellPanel.remove((Component)this.fShowFunctionsCheckBox);
            this.fFunctionCellPanel.remove((Component)this.fShowCellsCheckBox);
            if (objectArray2.length > 0) {
                this.fFunctionCellButton.setText(EditorUtils.lookup("dialog.gotoCellTitle"));
            } else {
                this.fFunctionCellButton.setText(EditorUtils.lookup("dialog.gotoFunctionTitle"));
            }
            if (objectArray.length == 0 && objectArray2.length == 0 && this.fLineNumberLabel == null) {
                this.remove((Component)this.fLineNumberButton);
                this.fLineNumberLabel = new MJLabel(this.fLineNumberButton.getText());
                this.addLineNumberLabel((JComponent)this.fLineNumberLabel, true);
                this.remove((Component)this.fFunctionCellButton);
                this.remove((Component)this.fFunctionCellPanel);
            } else if ((objectArray.length > 0 || objectArray2.length > 0) && this.fLineNumberLabel != null) {
                bl2 = true;
            }
            bl = false;
        }
        if (bl2) {
            this.remove((Component)this.fLineNumberLabel);
            this.fLineNumberLabel = null;
            this.addLineNumberLabel((JComponent)this.fLineNumberButton, false);
            this.addFunctionCellLabel((JComponent)this.fFunctionCellButton);
            this.addFunctionCellTable((JComponent)this.fFunctionCellPanel);
        }
        return bl;
    }

    private void closeParentDialog() {
        this.fParentDialog.hide();
        this.fWindowListener.windowClosing(null);
    }

    private void parentDialog(Component component, MJDialog mJDialog) {
        this.fParentDialog = mJDialog;
        this.fParentDialog.addWindowListener((WindowListener)this.fWindowListener);
        this.fParentDialog.getContentPane().add((Component)((Object)this));
        this.fParentDialog.getRootPane().setDefaultButton((JButton)this.fOKButton);
        this.fParentDialog.pack();
        this.fParentDialog.setLocationRelativeTo((Component)MJFrame.getFrame((Component)component));
        this.enableOptions();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width < 180 && dimension.height < 120) {
            dimension.width += 16;
            dimension.height += 16;
        }
        return dimension;
    }

    private GridBagConstraints addLineNumberLabel(JComponent jComponent, boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        if (!bl) {
            gridBagConstraints.insets = new Insets(8, 8, 0, 4);
            gridBagConstraints.weighty = 0.0;
        } else {
            gridBagConstraints.insets = new Insets(8, 16, 0, 4);
            gridBagConstraints.weighty = 1.0;
        }
        this.add(jComponent, gridBagConstraints);
        return gridBagConstraints;
    }

    private GridBagConstraints addFunctionCellLabel(JComponent jComponent) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(8, 8, 2, 8);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        this.add(jComponent, gridBagConstraints);
        return gridBagConstraints;
    }

    private GridBagConstraints addFunctionCellTable(JComponent jComponent) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        this.add(jComponent, gridBagConstraints);
        return gridBagConstraints;
    }

    int getLineNumber() {
        return this.fSelectedLineNumber;
    }

    private void updateSelectedLineNumber() throws NumberFormatException {
        if (this.fLineNumberButton.isSelected() || this.fLineNumberLabel != null) {
            try {
                this.fSelectedLineNumber = Integer.parseInt(this.fLineTextField.getText());
                return;
            }
            catch (NumberFormatException numberFormatException) {
                MJOptionPane.showMessageDialog((Component)this.fParentDialog, (Object)MJUtilities.intlString((String)"labelError1"), (String)EditorUtils.EDITOR_TITLE, (int)0);
                this.fSelectedLineNumber = -1;
                this.fLineTextField.requestFocus();
                this.fLineTextField.selectAll();
                throw numberFormatException;
            }
        }
        int n = this.fFunctionCellTable.getSelectedRow();
        if (n != -1) {
            this.fSelectedLineNumber = (Integer)this.fFunctionCellTable.getModel().getValueAt(n, 1);
            return;
        }
        this.fSelectedLineNumber = -1;
    }

    void setTableInfo(Component component, Object[] objectArray, int[] nArray, Object[] objectArray2, int[] nArray2, int n, Object object, MJDialog mJDialog) {
        boolean bl = object.equals(this.fCompareObject);
        if (!bl) {
            this.fLineTextField.setText(String.valueOf(n));
        }
        this.fFunctionCellModel.setTableInfo(objectArray, nArray, objectArray2, nArray2);
        boolean bl2 = this.updateVisibleGUIOptions(objectArray, objectArray2);
        this.fFunctionCellModel.setUseFunctionCellInfo(bl2 ? this.fShowFunctionsCheckBox.isSelected() : true, bl2 ? this.fShowCellsCheckBox.isSelected() : true);
        if (objectArray.length == 0 && objectArray2.length == 0) {
            this.fLineNumberButton.setSelected(true);
        }
        this.parentDialog(component, mJDialog);
        if (!bl) {
            this.fFunctionCellTable.clearSelection();
            if (this.fFunctionCellButton.isSelected() && this.fFunctionCellTable.getRowCount() > 0) {
                this.fFunctionCellTable.setRowSelectionInterval(0, 0);
                this.fFunctionCellTable.scrollRectToVisible(this.fFunctionCellTable.getCellRect(0, 0, false));
            }
        }
        this.fCompareObject = object;
        this.fSelectedLineNumber = -1;
    }

    private void enableOptions() {
        if (this.fLineNumberButton.isSelected()) {
            this.fLineTextField.setEnabled(true);
            this.fLineTextField.selectAll();
            this.fFunctionCellTable.setEnabled(false);
            this.fShowFunctionsCheckBox.setEnabled(false);
            this.fShowCellsCheckBox.setEnabled(false);
            this.fLineTextField.requestFocus();
        } else {
            this.fLineTextField.setEnabled(false);
            this.fFunctionCellTable.setEnabled(true);
            this.fShowFunctionsCheckBox.setEnabled(true);
            this.fShowCellsCheckBox.setEnabled(true);
            if (this.fFunctionCellTable.getRowCount() > 0 && this.fFunctionCellTable.getSelectedRowCount() == 0) {
                this.fFunctionCellTable.setRowSelectionInterval(0, 0);
                this.fFunctionCellTable.scrollRectToVisible(this.fFunctionCellTable.getCellRect(0, 0, false));
            }
            this.fFunctionCellTable.requestFocus();
        }
    }

    private static class GotoObjectComparator
    implements Comparator<Object> {
        private GotoObjectComparator() {
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof String || object2 instanceof String) {
                return object.toString().compareTo(object2.toString());
            }
            if (object instanceof Comparable) {
                return ((Comparable)object).compareTo(object2);
            }
            return 0;
        }
    }

    private static class FunctionCellModel
    extends AbstractRecordlistModel {
        private Object fObject = new Object();
        private Object[] fFunctionNames;
        private int[] fFunctionLines;
        private Object[] fCellDividerNames;
        private int[] fCellDividerLines;
        private boolean fUseFunctionInfo;
        private boolean fUseCellInfo;

        FunctionCellModel(Object[] objectArray, int[] nArray, Object[] objectArray2, int[] nArray2, boolean bl, boolean bl2) {
            this.setTableInfo(objectArray, nArray, objectArray2, nArray2);
            this.setUseFunctionCellInfo(bl, bl2);
        }

        private void setTableInfo(Object[] objectArray, int[] nArray, Object[] objectArray2, int[] nArray2) {
            this.fFunctionNames = objectArray;
            this.fFunctionLines = nArray;
            this.fCellDividerNames = objectArray2;
            this.fCellDividerLines = nArray2;
        }

        private void setUseFunctionCellInfo(boolean bl, boolean bl2) {
            this.fUseFunctionInfo = bl;
            this.fUseCellInfo = bl2;
            this.fireRecordlistModelEvent(new RecordlistModelEvent());
        }

        public int getPrimaryFieldIndex() {
            return 0;
        }

        public int getPresortFieldOrder() {
            return 0;
        }

        public int getPresortFieldIndex() {
            return -1;
        }

        public int getFieldCount() {
            return 2;
        }

        public int getRecordCount() {
            int n = 0;
            if (this.fUseFunctionInfo) {
                n += this.fFunctionNames.length;
            }
            if (this.fUseCellInfo) {
                n += this.fCellDividerLines.length;
            }
            return n;
        }

        public String getFieldName(int n) {
            if (n == 0) {
                return EditorUtils.lookup("dialog.gotoTableName");
            }
            return EditorUtils.lookup("dialog.gotoTableLine");
        }

        public Object getSemaphore() {
            return this.fObject;
        }

        public Class<?> getFieldClass(int n) {
            if (n == 0) {
                return Object.class;
            }
            return Integer.class;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                if (this.fUseFunctionInfo) {
                    if (n < this.fFunctionNames.length) {
                        return this.fFunctionNames[n];
                    }
                    if (this.fUseCellInfo) {
                        return this.fCellDividerNames[n - this.fFunctionNames.length];
                    }
                } else if (this.fUseCellInfo) {
                    return this.fCellDividerNames[n];
                }
            } else if (this.fUseFunctionInfo) {
                if (n < this.fFunctionLines.length) {
                    return this.fFunctionLines[n];
                }
                if (this.fUseCellInfo) {
                    return this.fCellDividerLines[n - this.fFunctionLines.length];
                }
            } else if (this.fUseCellInfo) {
                return this.fCellDividerLines[n];
            }
            return null;
        }
    }

    private static class PositiveNumberDocument
    extends PlainDocument {
        private PositiveNumberDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isDigit(string.charAt(i))) continue;
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }

    private class GotoDialogListener
    extends WindowAdapter {
        private GotoDialogListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (GoToDialogPanel.this.fParentDialog != null) {
                GoToDialogPanel.this.fParentDialog.removeWindowListener((WindowListener)this);
                GoToDialogPanel.this.enableOptions();
                GoToDialogPanel.this.fParentDialog.remove((Component)((Object)GoToDialogPanel.this));
                GoToDialogPanel.this.fParentDialog.dispose();
                GoToDialogPanel.this.fParentDialog = null;
            }
        }
    }
}

