/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.actions.SelectionDelegate;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mwswing.TextComponentUtils;
import com.mathworks.util.Log;
import com.mathworks.util.osgi.ClasspathOSGiManager;
import com.mathworks.widgets.SyntaxTextPaneUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.JumpList;

public class SelectionAction {
    private final SelectionDelegate.ActionType fType;
    private final DelegateProvider fDelegateProvider;
    private Thread fCurrentDelegateRunner;

    public SelectionAction(SelectionDelegate.ActionType actionType) {
        this(actionType, new OsgiDelegateProvider());
    }

    public SelectionAction(SelectionDelegate.ActionType actionType, DelegateProvider delegateProvider) {
        Validate.notNull((Object)actionType, (String)"'type' cannot be null");
        Validate.notNull((Object)actionType, (String)"'provider' cannot be null");
        this.fType = actionType;
        this.fDelegateProvider = delegateProvider;
    }

    public void doAction(final Editor editor) {
        assert (SwingUtilities.isEventDispatchThread()) : "This method must be called from the EDT.";
        SelectionAction.addEntryToJumpListIfPossible(editor);
        final String string = SelectionAction.getTrimmedSelectionOrIdentifierFromCaretLocation(editor);
        this.fCurrentDelegateRunner = new Thread(new Runnable(){

            @Override
            public void run() {
                SelectionDelegate selectionDelegate = SelectionAction.this.getDelegate(editor, string);
                selectionDelegate.handle(SelectionAction.this.fType, editor, string);
            }
        }, "SelectionAction");
        this.fCurrentDelegateRunner.start();
    }

    public void waitForActionToFinish() {
        if (this.fCurrentDelegateRunner == null) {
            throw new IllegalStateException("doAction has not yet been called.");
        }
        try {
            this.fCurrentDelegateRunner.join();
        }
        catch (InterruptedException interruptedException) {
            Log.logException((Exception)interruptedException);
        }
    }

    private SelectionDelegate getDelegate(Editor editor, String string) {
        for (SelectionDelegate selectionDelegate : this.getSelectionDelegates()) {
            if (!selectionDelegate.wouldLikeToHandle(this.fType, editor, string)) continue;
            return selectionDelegate;
        }
        throw new IllegalStateException("A SelectionDelegate was not found.");
    }

    static String getOpenSelectionString(Editor editor) {
        String string = SelectionAction.getTrimmedSelectionOrIdentifierFromCaretLocation(editor);
        return string == null || SelectionAction.isOpenSelectionStringInvalid(string) ? null : string;
    }

    public static boolean isOpenSelectionStringInvalid(String string) {
        return string.contains("\n");
    }

    private static String getTrimmedSelectionOrIdentifierFromCaretLocation(Editor editor) {
        Validate.notNull((Object)editor, (String)"Editor cannot be null.");
        String string = editor.getSelection();
        String string2 = string.length() == 0 ? TextComponentUtils.getFunctionAt((Document)editor.getDocument(), (int)editor.getCaretPosition(), (boolean)true) : string;
        return string2 == null ? null : string2.trim();
    }

    private static void addEntryToJumpListIfPossible(Editor editor) {
        JTextComponent jTextComponent = SyntaxTextPaneUtilities.getLastActiveComponent();
        if (jTextComponent != null) {
            JumpList.checkAddEntry((JTextComponent)jTextComponent, (int)editor.getCaretPosition());
        }
    }

    public List<SelectionDelegate> getSelectionDelegates() {
        Collection<SelectionDelegate> collection = this.fDelegateProvider.getDelegates();
        ArrayList<SelectionDelegate> arrayList = new ArrayList<SelectionDelegate>(collection);
        EditorUtils.sortPrioritizables(arrayList);
        return arrayList;
    }

    private static class OsgiDelegateProvider
    implements DelegateProvider {
        private OsgiDelegateProvider() {
        }

        public List<SelectionDelegate> getDelegates() {
            return (List)ClasspathOSGiManager.getInstance().getImplementors(SelectionDelegate.class);
        }
    }

    public static interface DelegateProvider {
        public Collection<SelectionDelegate> getDelegates();
    }
}

