/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.breakpoints;

import com.mathworks.matlab.api.debug.Breakpoint;
import com.mathworks.mde.editor.breakpoints.BreakpointDisplayUtils;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpointUtils;
import com.mathworks.util.FileUtils;
import java.io.File;
import org.apache.commons.lang.Validate;

public final class MatlabBreakpoint
implements Breakpoint {
    private final int fZeroBasedLineNumber;
    private final String fExpression;
    private final int fAnonymousIndex;
    private final File fFile;
    public static final int LINE_BREAKPOINT = 0;

    private MatlabBreakpoint(int n, int n2, String string, File file) {
        Validate.isTrue((n >= 0 ? 1 : 0) != 0, (String)"The line number cannot be negative.");
        Validate.notNull((Object)string, (String)"The expression cannot be null.");
        Validate.notNull((Object)file, (String)"The file cannot be null.");
        this.fZeroBasedLineNumber = n;
        this.fAnonymousIndex = n2;
        this.fExpression = string;
        this.fFile = file;
    }

    public static MatlabBreakpoint create(int n, File file) {
        return new MatlabBreakpoint(n, 0, "", file);
    }

    public static MatlabBreakpoint create(int n, String string, File file) {
        return new MatlabBreakpoint(n, 0, string, file);
    }

    public static MatlabBreakpoint createAnonymous(int n, int n2, File file) {
        MatlabBreakpoint.checkAnonymousIndex(n2);
        return new MatlabBreakpoint(n, n2, "", file);
    }

    public static MatlabBreakpoint createConditional(int n, String string, File file) {
        return new MatlabBreakpoint(n, 0, string, file);
    }

    public static MatlabBreakpoint createAnonymousConditional(int n, int n2, String string, File file) {
        MatlabBreakpoint.checkAnonymousIndex(n2);
        return new MatlabBreakpoint(n, n2, string, file);
    }

    public int getZeroBasedLineNumber() {
        return this.fZeroBasedLineNumber;
    }

    public int getOneBasedLineNumber() {
        return this.fZeroBasedLineNumber + 1;
    }

    public boolean isEnabled() {
        return !MatlabBreakpointUtils.expressionIncludesDisabled(this.fExpression);
    }

    public String getWrappedExpression() {
        return this.fExpression;
    }

    public String getExpression() {
        return MatlabBreakpointUtils.stripDisabled(this.fExpression);
    }

    public boolean hasExpression() {
        return this.getExpression().length() != 0;
    }

    public boolean isAnonymous() {
        return this.fAnonymousIndex != 0;
    }

    public int getAnonymousIndex() {
        return this.fAnonymousIndex;
    }

    public File getFile() {
        return this.fFile;
    }

    public String toString() {
        return BreakpointDisplayUtils.createBreakpointDisplayString(this);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof MatlabBreakpoint && ((Breakpoint)object).getZeroBasedLineNumber() == this.fZeroBasedLineNumber && ((MatlabBreakpoint)object).getAnonymousIndex() == this.fAnonymousIndex && ((MatlabBreakpoint)object).getWrappedExpression().equals(this.fExpression) && FileUtils.areFilesTheSame((File)((MatlabBreakpoint)object).getFile(), (File)this.fFile);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.fZeroBasedLineNumber;
        n = 37 * n + this.fAnonymousIndex;
        n = 37 * n + this.fExpression.hashCode();
        n = 37 * n + this.fFile.hashCode();
        return n;
    }

    public MatlabBreakpoint deriveBreakpoint(int n) {
        return new MatlabBreakpoint(n, this.fAnonymousIndex, this.fExpression, this.fFile);
    }

    public MatlabBreakpoint deriveBreakpoint(boolean bl) {
        String string = bl ? MatlabBreakpointUtils.stripDisabled(this.fExpression) : MatlabBreakpointUtils.createDisabledExpressionIfNecessary(this.fExpression);
        return new MatlabBreakpoint(this.fZeroBasedLineNumber, this.fAnonymousIndex, string, this.fFile);
    }

    public MatlabBreakpoint deriveBreakpoint(String string) {
        String string2 = this.isEnabled() ? string : MatlabBreakpointUtils.createDisabledExpressionIfNecessary(string);
        return new MatlabBreakpoint(this.fZeroBasedLineNumber, this.fAnonymousIndex, MatlabBreakpointUtils.cleanupExpression(string2), this.fFile);
    }

    private static void checkAnonymousIndex(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("The cannot be less than 1.");
        }
    }

    public static boolean isLineBreakpoint(int n) {
        return n == 0;
    }

    public static boolean isLineBreakpoint(MatlabBreakpoint matlabBreakpoint) {
        return MatlabBreakpoint.isLineBreakpoint(matlabBreakpoint.getAnonymousIndex());
    }
}

