/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.breakpoints;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.matchers.Matcher;
import com.mathworks.mde.editor.MFilePathUtil;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpoint;
import com.mathworks.mde.editor.breakpoints.MatlabDebugger;
import com.mathworks.services.message.MWMessage;
import com.mathworks.util.FileUtils;
import com.mathworks.widgets.glazedlists.DisposableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import org.apache.commons.lang.Validate;

public final class MatlabBreakpointUtils {
    private static final String DISABLED_CONDITION = "false";
    private static final String DISABLED_PREFIX = "false&&(";
    private static final String DISABLED_SUFFIX = ")";
    private static MatlabDebugger sDebugger = new MatlabDebugger();
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(MatlabBreakpointUtils.class.getPackage().getName() + ".resources.RES_Breakpoints");

    private MatlabBreakpointUtils() {
    }

    public static MatlabDebugger getDebugger() {
        return sDebugger;
    }

    public static String lookup(String string) {
        return BUNDLE.getString(string);
    }

    public static String createAnonymousTag(int n) {
        return n > 0 ? "@" + n : "";
    }

    public static boolean expressionIncludesDisabled(String string) {
        Validate.notNull((Object)string, (String)"The expression cannot be null.");
        return string.equals(DISABLED_CONDITION) || string.startsWith(DISABLED_PREFIX) && string.endsWith(DISABLED_SUFFIX);
    }

    public static String stripDisabled(String string) {
        Validate.notNull((Object)string, (String)"The expression cannot be null.");
        String string2 = string.equals(DISABLED_CONDITION) ? "" : (MatlabBreakpointUtils.expressionIncludesDisabled(string) ? string.substring(DISABLED_PREFIX.length(), string.length() - DISABLED_SUFFIX.length()) : string);
        return string2;
    }

    public static String createDisabledExpressionIfNecessary(String string) {
        Validate.notNull((Object)string, (String)"The given expression cannot be null.");
        return MatlabBreakpointUtils.expressionIncludesDisabled(string) ? string : MatlabBreakpointUtils.makeExpressionDisabled(string);
    }

    private static String makeExpressionDisabled(String string) {
        assert (!MatlabBreakpointUtils.expressionIncludesDisabled(string));
        return string.length() == 0 ? DISABLED_CONDITION : DISABLED_PREFIX + string + DISABLED_SUFFIX;
    }

    public static String cleanupExpression(String string) {
        String string2 = string == null ? "" : string;
        return string2.replaceAll("[;,\\s]*\\Z", "").trim();
    }

    public static void runUntil(int n, File file, MatlabDebugger matlabDebugger) {
        Validate.notNull((Object)file, (String)"The given File cannot be null.");
        Validate.notNull((Object)matlabDebugger, (String)"The given Debugger cannot be null.");
        MatlabBreakpoint matlabBreakpoint = MatlabBreakpointUtils.findLineBreakpointOnLine(n, file, matlabDebugger);
        MatlabBreakpoint matlabBreakpoint2 = MatlabBreakpoint.create(n, file);
        sDebugger.setBreakpoint(matlabBreakpoint2, null);
        sDebugger.continueExecution();
        if (matlabBreakpoint == null) {
            sDebugger.clearBreakpoint(matlabBreakpoint2);
        } else {
            sDebugger.setBreakpoint(matlabBreakpoint, null);
        }
    }

    public static String convertFileToStringPath(File file) {
        Validate.notNull((Object)file, (String)"The given File cannot be null.");
        return MFilePathUtil.getFullPathname(file.getPath());
    }

    public static File convertStringPathToFile(String string) {
        Validate.notNull((Object)string, (String)"The given path cannot be null.");
        return new File(MFilePathUtil.getFullPathname(string));
    }

    public static Collection<MatlabBreakpoint> extractBreakpoints(MWMessage[] mWMessageArray) {
        Validate.notNull((Object)mWMessageArray, (String)"The MWMessage array should not be null.");
        Validate.isTrue((mWMessageArray.length > 0 ? 1 : 0) != 0, (String)"The number of messages should be greater than 0.");
        ArrayList<MatlabBreakpoint> arrayList = new ArrayList<MatlabBreakpoint>();
        for (MWMessage mWMessage : mWMessageArray) {
            arrayList.add(MatlabBreakpointUtils.extractBreakpoint(mWMessage));
        }
        return arrayList;
    }

    private static MatlabBreakpoint extractBreakpoint(MWMessage mWMessage) {
        File file = MatlabBreakpointUtils.convertStringPathToFile((String)mWMessage.get((Object)"string"));
        Integer n = (Integer)mWMessage.get((Object)"lineno") - 1;
        String string = (String)mWMessage.get((Object)"value");
        string = string == null ? "" : string;
        Integer n2 = (Integer)mWMessage.get((Object)"anonymous");
        return MatlabBreakpoint.isLineBreakpoint(n2) ? MatlabBreakpoint.create(n, string, file) : MatlabBreakpoint.createAnonymousConditional(n, n2, string, file);
    }

    public static Collection<MatlabBreakpoint> getBreakpointsOnLine(int n, Collection<MatlabBreakpoint> collection) {
        Validate.notNull(collection, (String)"The given collection of Breakpoints cannot be null.");
        ArrayList<MatlabBreakpoint> arrayList = new ArrayList<MatlabBreakpoint>();
        for (MatlabBreakpoint matlabBreakpoint : collection) {
            if (matlabBreakpoint.getZeroBasedLineNumber() != n) continue;
            arrayList.add(matlabBreakpoint);
        }
        return arrayList;
    }

    private static MatlabBreakpoint findLineBreakpointOnLine(int n, File file, MatlabDebugger matlabDebugger) {
        DisposableList<MatlabBreakpoint> disposableList = matlabDebugger.getBreakpoints();
        FilterList<MatlabBreakpoint> filterList = MatlabBreakpointUtils.createFilterList(disposableList, file);
        MatlabBreakpoint matlabBreakpoint = MatlabBreakpointUtils.findBreakpointOnLineAtAnonymousIndex(n, 0, filterList);
        filterList.dispose();
        disposableList.dispose();
        return matlabBreakpoint;
    }

    public static MatlabBreakpoint findBreakpointOnLineAtAnonymousIndex(int n, int n2, Collection<MatlabBreakpoint> collection) {
        Validate.notNull(collection, (String)"Collection of breakpoints cannot be null.");
        MatlabBreakpoint matlabBreakpoint = null;
        for (MatlabBreakpoint matlabBreakpoint2 : collection) {
            if (matlabBreakpoint2.getZeroBasedLineNumber() != n || matlabBreakpoint2.getAnonymousIndex() != n2) continue;
            matlabBreakpoint = matlabBreakpoint2;
            break;
        }
        return matlabBreakpoint;
    }

    public static Collection<Integer> getAnonymousFunctionIndciesWithoutBreakpoints(int n, Collection<MatlabBreakpoint> collection) {
        Validate.notNull(collection, (String)"Collection of breakpoints cannot be null.");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 1; i <= n; ++i) {
            arrayList.add(i);
        }
        Integer n2 = null;
        for (MatlabBreakpoint matlabBreakpoint : collection) {
            int n3 = matlabBreakpoint.getAnonymousIndex();
            if (arrayList.contains(n3)) {
                arrayList.remove((Object)n3);
            }
            if (n2 != null && n2.intValue() != matlabBreakpoint.getZeroBasedLineNumber()) {
                throw new IllegalArgumentException("The given breakpoints should all have the same line number.");
            }
            n2 = matlabBreakpoint.getZeroBasedLineNumber();
        }
        return arrayList;
    }

    public static FilterList<MatlabBreakpoint> createFilterList(EventList<MatlabBreakpoint> eventList, File file) {
        return new FilterList(eventList, MatlabBreakpointUtils.createBreakpointsForFileMatcher(file));
    }

    private static Matcher<MatlabBreakpoint> createBreakpointsForFileMatcher(final File file) {
        return new Matcher<MatlabBreakpoint>(){

            public boolean matches(MatlabBreakpoint matlabBreakpoint) {
                return FileUtils.areFilesTheSame((File)file, (File)matlabBreakpoint.getFile());
            }
        };
    }
}

