/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.java;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.matlab.api.editor.EditorLanguage;
import com.mathworks.matlab.api.editor.EditorSyntaxHighlighting;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.text.AbstractEditorLanguagePanel;
import com.mathworks.widgets.text.MWKit;
import com.mathworks.widgets.text.MethodStyle;
import com.mathworks.widgets.text.java.JavaKit;
import com.mathworks.widgets.text.java.JavaLanguage;
import com.mathworks.widgets.text.java.JavaSyntaxHighlighting;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class JavaPreferencesPanel
extends AbstractEditorLanguagePanel {
    public static final String JAVA_METHOD_COMBOBOX_NAME = "JavaMethodComboBox";
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(JavaPreferencesPanel.class.getPackage().getName() + ".resources.RES_java");
    private JComboBox fMethodCombo;

    public void build() {
        this.fMethodCombo = this.createMethodComboBox();
        this.setSyntaxHighlightingComponent(this.createMethodPanel());
    }

    private JComponent createMethodPanel() {
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("pref, 3dlu, pref", "pref"));
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(BUNDLE.getString("prefs.showMethods"), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.fMethodCombo, cellConstraints.xy(3, 1));
        return panelBuilder.getPanel();
    }

    private JComboBox createMethodComboBox() {
        MJComboBox mJComboBox = new MJComboBox((Object[])MethodStyle.values());
        mJComboBox.setName(JAVA_METHOD_COMBOBOX_NAME);
        mJComboBox.getAccessibleContext().setAccessibleName(BUNDLE.getString("prefs.showMethodsDescription"));
        this.setPreviewPaneCreationListener(new AbstractEditorLanguagePanel.PreviewPaneCreationListener((JComboBox)mJComboBox){
            final /* synthetic */ JComboBox val$methods;
            {
                this.val$methods = jComboBox;
            }

            public void previewPaneCreated(final SyntaxTextPane syntaxTextPane) {
                this.val$methods.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        syntaxTextPane.setJavaMethodType((MethodStyle)val$methods.getSelectedItem());
                    }
                });
                this.val$methods.setSelectedItem(JavaSyntaxHighlighting.getJavaMethodStyle());
            }
        });
        return mJComboBox;
    }

    public MWKit getModifiableKit() {
        return new JavaKit(){

            public String getContentType() {
                return JavaLanguage.INSTANCE.getMimeType();
            }
        };
    }

    public EditorSyntaxHighlighting getSyntaxHighlighting() {
        return new JavaSyntaxHighlighting();
    }

    public String getSampleCode() {
        return "switch(getCurrentState()){\n    case 'a':\n        return \"alive\"; // active state\n# end of test";
    }

    public EditorLanguage getLanguage() {
        return JavaLanguage.INSTANCE;
    }

    public void commit() {
        super.commit();
        JavaSyntaxHighlighting.setJavaMethodStylePreference((MethodStyle)((MethodStyle)this.fMethodCombo.getSelectedItem()));
    }
}

