/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.examples.addons;

import com.mathworks.help.helpui.json.JsonArray;
import com.mathworks.help.helpui.json.JsonEntity;
import com.mathworks.help.helpui.json.JsonObject;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.product.util.ProductIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddonUtils {
    private AddonUtils() {
    }

    public static List<GalleryInstalledAddOnMetadata> getInstalledAddons() {
        return AddonUtils.getInstalledAddonsMock();
    }

    public static String getInstalledAddonsJsonArray() {
        JsonArray jsonArray = new JsonArray();
        for (GalleryInstalledAddOnMetadata galleryInstalledAddOnMetadata : AddonUtils.getInstalledAddons()) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addStringProperty("addOnType", galleryInstalledAddOnMetadata.getAddOnType());
            jsonObject.addStringProperty("identifier", galleryInstalledAddOnMetadata.getIdentifier());
            jsonObject.addStringProperty("version", galleryInstalledAddOnMetadata.getVersion() == null ? "" : galleryInstalledAddOnMetadata.getVersion());
            jsonObject.addStringProperty("installedDate", galleryInstalledAddOnMetadata.getInstalledDate());
            jsonArray.addEntity((JsonEntity)jsonObject);
        }
        return jsonArray.getJsonString();
    }

    private static List<GalleryInstalledAddOnMetadata> getInstalledAddonsMock() {
        try {
            Collection collection = HelpPrefs.getInstalledProducts();
            ArrayList<GalleryInstalledAddOnMetadata> arrayList = new ArrayList<GalleryInstalledAddOnMetadata>();
            for (ProductIdentifier productIdentifier : collection) {
                if (productIdentifier.getBaseCode().equals("ST")) continue;
                GalleryInstalledAddOnMetadata galleryInstalledAddOnMetadata = new GalleryInstalledAddOnMetadata(AddonType.PRODUCT, productIdentifier.getBaseCode(), "", "");
                arrayList.add(galleryInstalledAddOnMetadata);
            }
            return arrayList;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final class GalleryInstalledAddOnMetadata {
        private String addOnType;
        private String identifier;
        private String version;
        private String installedDate;

        public GalleryInstalledAddOnMetadata(AddonType addonType, String string, String string2, String string3) {
            this.addOnType = addonType.toString();
            this.identifier = string;
            this.version = string2;
            this.installedDate = string3;
        }

        public String getAddOnType() {
            return this.addOnType;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getVersion() {
            return this.version;
        }

        public String getInstalledDate() {
            return this.installedDate;
        }
    }

    private static enum AddonType {
        TOOLBOX,
        PRODUCT;

    }
}

