/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.explorer;

import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.mde.explorer.Explorer;
import com.mathworks.mde.explorer.ToolbarUtils;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.actions.ActionManager;
import com.mathworks.mlwidgets.explorer.widgets.buttons.BrowseAction;
import com.mathworks.widgets.desk.DTToolBarConfiguration;
import com.mathworks.widgets.desk.DTToolBarFactory;
import com.mathworks.widgets.desk.DTToolBarInfo;
import com.mathworks.widgets.desk.DTToolSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToolBar;

final class ExplorerToolbar {
    private final JToolBar fComponent;
    private final String fCustomizationPanelKey;
    private static final List<String> DO_NOT_ADD = new ArrayList<String>();

    ExplorerToolbar(ActionManager actionManager, String string) {
        this.fCustomizationPanelKey = string;
        DTToolSet dTToolSet = new DTToolSet();
        if (Explorer.getInstance().getActionButton() != null) {
            dTToolSet.add("cwd.actions", ExplorerResources.getString((String)"tooltip.actions"), (Component)Explorer.getInstance().getActionButton().getComponent(), (Icon)DocumentIcon.ACTIONS.getIcon());
        }
        dTToolSet.add("cwd.address", ExplorerResources.getString((String)"toolbar.address"), (Component)Explorer.getInstance().getAddressBar().getComponent(), (Icon)DocumentIcon.ADDRESS_BAR.getIcon());
        dTToolSet.add("cwd.browse", (Action)new BrowseAction());
        Map map = actionManager.getActionsAllowedOnToolbar();
        for (Map.Entry dTToolBarConfiguration2 : map.entrySet()) {
            if (DO_NOT_ADD.contains(dTToolBarConfiguration2.getKey())) continue;
            dTToolSet.add((String)dTToolBarConfiguration2.getKey(), (Action)dTToolBarConfiguration2.getValue());
        }
        Vector vector = new Vector();
        vector.add(actionManager.getActionDefinition(CoreActionID.BACK_NO_TEXT).getToolbarId());
        vector.add(actionManager.getActionDefinition(CoreActionID.FORWARD_NO_TEXT).getToolbarId());
        vector.add(actionManager.getActionDefinition(CoreActionID.UP_ONE_LEVEL_NO_TEXT).getToolbarId());
        vector.add("cwd.browse");
        vector.add("cwd.address");
        DTToolBarConfiguration dTToolBarConfiguration = new DTToolBarConfiguration((List)vector);
        DTToolBarInfo dTToolBarInfo = new DTToolBarInfo(this.fCustomizationPanelKey, ExplorerResources.getString((String)"toolbar.cwd.label"), dTToolSet, dTToolBarConfiguration);
        this.fComponent = ToolbarUtils.fixLook(DTToolBarFactory.createToolBar((DTToolBarInfo)dTToolBarInfo, (DTToolBarConfiguration)dTToolBarConfiguration, (Object)((Object)Explorer.getInstance())));
        ToolbarUtils.register(dTToolBarInfo, this.fComponent);
    }

    public JToolBar getComponent() {
        return this.fComponent;
    }

    public String getCustomizationPanelKey() {
        return this.fCustomizationPanelKey;
    }

    static {
        DO_NOT_ADD.add("context.delete");
        DO_NOT_ADD.add("context.cut");
        DO_NOT_ADD.add("context.copy");
        DO_NOT_ADD.add("context.paste");
        DO_NOT_ADD.add("context.FindinFiles");
    }
}

