/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.find;

import com.mathworks.mde.find.DefaultFileTypeContentsProvider;
import com.mathworks.mde.find.FileTypeContentsProvider;
import com.mathworks.util.osgi.ClasspathOSGiManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class Grep {
    private static boolean sStop = false;
    private Pattern fPattern;
    private ArrayList<String[]> fResults = new ArrayList();

    public void compile(String string, boolean bl) throws PatternSyntaxException {
        this.fPattern = Pattern.compile(string, bl ? 2 : 0);
        sStop = false;
    }

    public static void setStop(boolean bl) {
        sStop = bl;
    }

    public List<String[]> grepFile(File file) {
        this.fResults.clear();
        this.fResults.ensureCapacity(1000);
        if (file.canRead() && file.isFile() && file.exists()) {
            this.grepInLargeFile(file);
        }
        return Collections.unmodifiableList(this.fResults);
    }

    private static Iterator<InputStream> getInputStreams(File file) throws IOException {
        Collection collection = ClasspathOSGiManager.getInstance().getImplementors(FileTypeContentsProvider.class);
        FileTypeContentsProvider fileTypeContentsProvider = null;
        for (FileTypeContentsProvider fileTypeContentsProvider2 : collection) {
            if (!fileTypeContentsProvider2.appliesTo(file)) continue;
            fileTypeContentsProvider = fileTypeContentsProvider2;
        }
        if (fileTypeContentsProvider == null) {
            fileTypeContentsProvider = new DefaultFileTypeContentsProvider();
        }
        Map<String, InputStream> map = fileTypeContentsProvider.getContents(file);
        return map.values().iterator();
    }

    private void grepInLargeFile(File file) {
        try {
            Iterator<InputStream> iterator = Grep.getInputStreams(file);
            while (iterator.hasNext()) {
                InputStream inputStream = iterator.next();
                this.grepThroughEachStream(inputStream);
            }
        }
        catch (IOException iOException) {
            this.fResults.clear();
        }
    }

    private void grepThroughEachStream(InputStream inputStream) throws IOException {
        try (InputStream inputStream2 = inputStream;){
            ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream2);
            int n = 1;
            int n2 = 1;
            while (n > 0 && !sStop) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);
                n = readableByteChannel.read(byteBuffer);
                if (n <= 0) continue;
                byteBuffer.flip();
                n2 = this.grepInBuffer(byteBuffer, n2);
                byteBuffer.flip();
            }
        }
    }

    private int grepInBuffer(ByteBuffer byteBuffer, int n) throws CharacterCodingException {
        int n2 = n;
        Charset charset = Charset.defaultCharset();
        String string = new String(byteBuffer.array(), charset).trim();
        String[] stringArray = string.split("\\r\\n|\\n|\\r");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (i > 0) {
                ++n2;
            }
            if (!this.fPattern.matcher(string2).find()) continue;
            String[] stringArray2 = new String[]{Integer.toString(n2), string2};
            this.fResults.add(stringArray2);
        }
        return n2;
    }
}

