/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.functionhints;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.mdt.MatlabCallable;
import com.mathworks.jmi.mdt.MatlabEventQueue;
import com.mathworks.mde.functionhints.FunctionHints;
import com.mathworks.mde.functionhints.FunctionHintsPanel;
import com.mathworks.mde.functionhints.InvalidFunctionHintsPanel;
import com.mathworks.mlwidgets.help.functioncall.MFunctionCall;
import com.mathworks.mwswing.MJUtilities;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.ParseException;
import java.util.ResourceBundle;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

class QueuedMatlabWorker
extends MatlabWorker {
    private volatile boolean fBusy = false;
    private volatile boolean fCancelled = false;
    private WorkUnit fWorkUnit;
    private WorkUnit fQueuedWorkUnit;
    private static final String RES_STR = "com.mathworks.mlwidgets.help.resources.RES_FunctionCall";
    private static ResourceBundle resources = ResourceBundle.getBundle("com.mathworks.mlwidgets.help.resources.RES_FunctionCall");

    QueuedMatlabWorker() {
    }

    void startAsynchronous(String string, JTextComponent jTextComponent) {
        this.fBusy = true;
        this.fWorkUnit = new WorkUnit(string, jTextComponent);
        this.start();
    }

    static void startSynchronous(final String string, JTextComponent jTextComponent) {
        Cursor cursor = jTextComponent.getCursor();
        jTextComponent.setCursor(new Cursor(3));
        final AtomicReference<ParseException> atomicReference = new AtomicReference<ParseException>();
        Future future = MatlabEventQueue.invoke((MatlabCallable)new MatlabCallable<Object>(){

            public void callOnEdt(Object object, boolean bl) {
            }

            public Object call() throws Exception {
                try {
                    return MFunctionCall.getInstance((String)string);
                }
                catch (ParseException parseException) {
                    atomicReference.set(parseException);
                    return null;
                }
            }
        });
        Object var5_5 = null;
        try {
            var5_5 = future.get(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException exception) {
            atomicReference.set(new ParseException(resources.getString("MFunctionCall.MATLABTimeout"), 0));
        }
        catch (Exception exception) {
            atomicReference.set(new ParseException(resources.getString("MFunctionCall.CatchAll"), 0));
        }
        if (atomicReference.get() != null) {
            var5_5 = atomicReference.get();
        }
        if (var5_5 != null) {
            QueuedMatlabWorker.openFunctionHintsSynchronously(jTextComponent, var5_5, string);
        }
        jTextComponent.setCursor(cursor);
    }

    void queueAsynchronous(String string, JTextComponent jTextComponent) {
        this.cancel();
        this.fQueuedWorkUnit = new WorkUnit(string, jTextComponent);
    }

    JTextComponent getTextAreaHost() {
        if (this.fWorkUnit != null) {
            return this.fWorkUnit.getiTextAreaHost();
        }
        return null;
    }

    String getMCode() {
        if (this.fWorkUnit != null) {
            return this.fWorkUnit.getiMCode();
        }
        return null;
    }

    boolean isBusy() {
        return this.fBusy;
    }

    private void maybeProcessQueuedItem() {
        if (this.fQueuedWorkUnit != null) {
            WorkUnit workUnit = this.fQueuedWorkUnit;
            this.fQueuedWorkUnit = null;
            this.startAsynchronous(workUnit.getiMCode(), workUnit.getiTextAreaHost());
        } else {
            this.fCancelled = false;
            this.fBusy = false;
        }
    }

    void cancel() {
        this.fCancelled = true;
        this.fQueuedWorkUnit = null;
    }

    private void resetAllFlags() {
        this.fQueuedWorkUnit = null;
        this.fWorkUnit = null;
        this.fCancelled = false;
        this.fBusy = false;
    }

    private static void openFunctionHintsSynchronously(JTextComponent jTextComponent, Object object, String string) {
        String string2;
        Rectangle rectangle;
        assert (SwingUtilities.isEventDispatchThread());
        try {
            rectangle = jTextComponent.modelToView(jTextComponent.getCaretPosition());
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        if (rectangle == null) {
            return;
        }
        Point point = new Point(rectangle.x, rectangle.y);
        SwingUtilities.convertPointToScreen(point, jTextComponent);
        if (object instanceof ParseException) {
            if (!FunctionHints.isOpen()) {
                FunctionHints.triggerPopup(jTextComponent, new InvalidFunctionHintsPanel((ParseException)object), null, string, point, true);
            }
            return;
        }
        try {
            string2 = ((MFunctionCall)object).createSignatureString();
        }
        catch (ParseException parseException) {
            FunctionHints.triggerPopup(jTextComponent, new InvalidFunctionHintsPanel(parseException), null, string, point, true);
            return;
        }
        FunctionHints.triggerPopup(jTextComponent, new FunctionHintsPanel(jTextComponent, (MFunctionCall)object, string2), (MFunctionCall)object, string, point, true);
    }

    public Object runOnMatlabThread() {
        if (this.fCancelled) {
            return null;
        }
        try {
            return MFunctionCall.getInstance((String)this.fWorkUnit.getiMCode());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void runOnAWTEventDispatchThread(Object object) {
        boolean bl;
        Rectangle rectangle;
        if (this.fCancelled) {
            this.fCancelled = false;
            this.maybeProcessQueuedItem();
            return;
        }
        try {
            rectangle = this.fWorkUnit.getiTextAreaHost().modelToView(this.fWorkUnit.getiTextAreaHost().getCaretPosition());
        }
        catch (BadLocationException badLocationException) {
            FunctionHints.hidePopup();
            this.resetAllFlags();
            return;
        }
        if (rectangle == null) {
            FunctionHints.hidePopup();
            this.resetAllFlags();
            return;
        }
        final Point point = new Point(rectangle.x, rectangle.y);
        SwingUtilities.convertPointToScreen(point, this.fWorkUnit.getiTextAreaHost());
        final MFunctionCall mFunctionCall = (MFunctionCall)object;
        if (mFunctionCall == null) {
            FunctionHints.hidePopup();
            this.resetAllFlags();
            return;
        }
        boolean bl2 = bl = FunctionHints.getFunctionName() != null && FunctionHints.getFunctionName().equals(mFunctionCall.getFunctionName());
        if (bl && FunctionHints.isOpen() && FunctionHints.getMFunctionCall() != null && FunctionHints.getMFunctionCall().equals((MFunctionCall)object) && FunctionHints.getLastTriggerPoint() != null && FunctionHints.getLastTriggerPoint().y == point.y) {
            this.maybeProcessQueuedItem();
            return;
        }
        if (bl && FunctionHints.isOpen() && FunctionHints.getLocation() != null) {
            point.x = FunctionHints.getLocation().x;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string;
                if (QueuedMatlabWorker.this.fCancelled) {
                    QueuedMatlabWorker.this.fCancelled = false;
                    QueuedMatlabWorker.this.maybeProcessQueuedItem();
                    return;
                }
                ParseException parseException = null;
                try {
                    string = mFunctionCall.createSignatureString();
                }
                catch (ParseException parseException2) {
                    string = null;
                    parseException = parseException2;
                }
                final String string2 = string;
                final ParseException parseException3 = parseException;
                if (QueuedMatlabWorker.this.fCancelled) {
                    QueuedMatlabWorker.this.fCancelled = false;
                    QueuedMatlabWorker.this.maybeProcessQueuedItem();
                    return;
                }
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (QueuedMatlabWorker.this.fCancelled) {
                            QueuedMatlabWorker.this.fCancelled = false;
                            QueuedMatlabWorker.this.maybeProcessQueuedItem();
                            return;
                        }
                        if (string2 == null) {
                            FunctionHints.hidePopup();
                            if (parseException3 != null && !QueuedMatlabWorker.this.isNoRefPaseException(parseException3)) {
                                FunctionHints.triggerPopup(QueuedMatlabWorker.this.fWorkUnit.getiTextAreaHost(), new InvalidFunctionHintsPanel(parseException3), null, QueuedMatlabWorker.this.fWorkUnit.getiMCode(), point, false);
                            }
                        } else if (!FunctionHints.isOpen()) {
                            FunctionHintsPanel functionHintsPanel = new FunctionHintsPanel(QueuedMatlabWorker.this.fWorkUnit.getiTextAreaHost(), mFunctionCall, string2);
                            FunctionHints.triggerPopup(QueuedMatlabWorker.this.fWorkUnit.getiTextAreaHost(), functionHintsPanel, mFunctionCall, QueuedMatlabWorker.this.fWorkUnit.getiMCode(), point, false);
                        } else if (!mFunctionCall.getFullyQualifiedFuncionName().equals(FunctionHints.getFullyQualifiedFuncionName()) || !string2.equals(FunctionHints.getContent())) {
                            FunctionHints.hidePopupWindow();
                            FunctionHintsPanel functionHintsPanel = new FunctionHintsPanel(QueuedMatlabWorker.this.fWorkUnit.getiTextAreaHost(), mFunctionCall, string2);
                            FunctionHints.triggerPopup(QueuedMatlabWorker.this.fWorkUnit.getiTextAreaHost(), functionHintsPanel, mFunctionCall, QueuedMatlabWorker.this.fWorkUnit.getiMCode(), point, false);
                        }
                        QueuedMatlabWorker.this.maybeProcessQueuedItem();
                    }
                });
            }
        };
        new Thread(runnable, "QueuedMatlabWorker").start();
    }

    private boolean isNoRefPaseException(ParseException parseException) {
        return parseException.getMessage().equals(resources.getString("MFunctionCall.NoRef"));
    }

    private static class WorkUnit {
        private volatile String iMCode;
        private volatile JTextComponent iTextAreaHost;

        WorkUnit(String string, JTextComponent jTextComponent) {
            this.setiMCode(string);
            this.setiTextAreaHost(jTextComponent);
        }

        public String getiMCode() {
            return this.iMCode;
        }

        public void setiMCode(String string) {
            this.iMCode = string;
        }

        public JTextComponent getiTextAreaHost() {
            return this.iTextAreaHost;
        }

        public void setiTextAreaHost(JTextComponent jTextComponent) {
            this.iTextAreaHost = jTextComponent;
        }
    }
}

