/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.help.helpui.DocConfig;
import com.mathworks.help.helpui.DocPage;
import com.mathworks.help.helpui.DocRoot;
import com.mathworks.html.FileUrl;
import com.mathworks.html.RelativeUrl;
import com.mathworks.html.Url;
import com.mathworks.html.WebUrl;
import com.mathworks.mde.help.DocCenterBrowserHandler;
import com.mathworks.mde.help.HelpBrowserHandler;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Set;

public class AddressLocator {
    private static final Set<String> INVALID_LOCATIONS = new HashSet<String>();
    private final HelpLocatorInfoProvider fHelpInfoProvider;
    private DocPage fCurrentDocPage = null;

    public AddressLocator() {
        this(new DocCenterInfoProvider());
    }

    public AddressLocator(HelpLocatorInfoProvider helpLocatorInfoProvider) {
        this.fHelpInfoProvider = helpLocatorInfoProvider;
        String string = this.fHelpInfoProvider.getCurrentLocation();
        this.setAddresses(string);
    }

    private void setAddresses(String string) {
        try {
            Url url = Url.parse((String)string);
            this.setAddresses(url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    void setAddresses(Url url) {
        this.fCurrentDocPage = this.getDocPageForLocation(url);
    }

    private DocPage getDocPageForLocation(String string) {
        try {
            Url url = Url.parse((String)string);
            return this.getDocPageForLocation(url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private DocPage getDocPageForLocation(Url url) {
        DocConfig<? extends Url> docConfig = this.fHelpInfoProvider.getCurrentDocConfig();
        return docConfig.getDocUrlParser().resolve(url);
    }

    public DocPage getDocPage() {
        return this.fCurrentDocPage;
    }

    public WebUrl getWebAddress() {
        DocConfig<WebUrl> docConfig = this.fHelpInfoProvider.getWebDocConfig();
        return this.getPageAddress(docConfig);
    }

    public FileUrl getInstalledAddress() {
        DocConfig<FileUrl> docConfig = this.fHelpInfoProvider.getLocalDocConfig();
        return this.getPageAddress(docConfig);
    }

    private <T extends Url> T getPageAddress(DocConfig<T> docConfig) {
        if (this.fCurrentDocPage != null && docConfig != null) {
            DocRoot docRoot = docConfig.getDocRoot();
            return (T)docRoot.buildDocPageUrl(this.fCurrentDocPage);
        }
        return null;
    }

    public String getInstalledWebCommand() {
        DocConfig<? extends Url> docConfig = this.fHelpInfoProvider.getCurrentDocConfig();
        if (AddressLocator.isLandingPage(docConfig, this.fCurrentDocPage)) {
            return "doc";
        }
        RelativeUrl relativeUrl = this.fCurrentDocPage.getRelativeUrlFromDocRoot();
        if (relativeUrl != null) {
            return "web(fullfile(docroot, '" + relativeUrl.getRelativePath() + "'))";
        }
        return "";
    }

    private static <T extends Url> boolean isLandingPage(DocConfig<T> docConfig, DocPage docPage) {
        Url url;
        Url url2 = docConfig.getDocRoot().buildGlobalLandingPageUrl();
        return !url2.diffTo(url = docConfig.getDocRoot().buildDocPageUrl(docPage)).contains(Url.UrlPart.BASE);
    }

    public boolean isValidLocation(String string) {
        DocPage docPage = this.getDocPageForLocation(string);
        if (docPage != null) {
            String string2 = docPage.getRelativeUrl().getRelativePath();
            String[] stringArray = string2.split("/");
            return stringArray.length == 0 || !INVALID_LOCATIONS.contains(stringArray[stringArray.length - 1]);
        }
        return false;
    }

    static {
        INVALID_LOCATIONS.add("begin_here.html");
        INVALID_LOCATIONS.add("nofunc.html");
    }

    private static class DocCenterInfoProvider
    implements HelpLocatorInfoProvider {
        private final HelpBrowserHandler fDocCenterHandler = new DocCenterBrowserHandler();

        private DocCenterInfoProvider() {
        }

        @Override
        public String getCurrentLocation() {
            return this.fDocCenterHandler.getCurrentLocation();
        }

        @Override
        public DocConfig<? extends Url> getCurrentDocConfig() {
            return DocCenterDocConfig.getInstance();
        }

        @Override
        public DocConfig<FileUrl> getLocalDocConfig() {
            return DocCenterDocConfig.getLocalConfig();
        }

        @Override
        public DocConfig<WebUrl> getWebDocConfig() {
            try {
                return DocCenterDocConfig.getWebConfig();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
    }

    public static interface HelpLocatorInfoProvider {
        public String getCurrentLocation();

        public DocConfig<? extends Url> getCurrentDocConfig();

        public DocConfig<FileUrl> getLocalDocConfig();

        public DocConfig<WebUrl> getWebDocConfig();
    }
}

