/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.help.helpui.DocConfig;
import com.mathworks.help.helpui.DocRoot;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.html.FileUrl;
import com.mathworks.html.Url;
import com.mathworks.html.WebUrl;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.Matlab;
import com.mathworks.mde.help.ClassicHelpBrowserHandler;
import com.mathworks.mde.help.DocCommandHelpBrowserTask;
import com.mathworks.mde.help.HelpBrowserHandler;
import com.mathworks.mde.help.InstalledFileUrlResolver;
import com.mathworks.mde.help.MLHelpBrowser;
import com.mathworks.mde.help.MLHelpBrowserActiveTab;
import com.mathworks.mde.help.MLHelpBrowserTask;
import com.mathworks.mde.help.OpenBrowserUrlDisplayBehaviorFactory;
import com.mathworks.mde.help.UrlDisplayBehavior;
import com.mathworks.mlwidgets.help.CSHelpTopicMap;
import com.mathworks.mlwidgets.help.DemoTreeItem;
import com.mathworks.mlwidgets.help.DemosData;
import com.mathworks.mlwidgets.help.DemosDataListener;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.mlwidgets.help.DocCenterUtils;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mwswing.MJOptionPane;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;

public class DocCenterBrowserHandler
implements HelpBrowserHandler {
    private static final ResourceBundle RES = ResourceBundle.getBundle("com.mathworks.mde.help.resources.RES_HelpBrowser");
    private HelpBrowserHandler fClassicHelpBrowserHandler = new ClassicHelpBrowserHandler();

    private static void doHelpBrowserTask(MLHelpBrowserTask mLHelpBrowserTask) {
        DocCenterBrowserHandler.doHelpBrowserTask(mLHelpBrowserTask, UrlDisplayBehavior.Destination.UNKNOWN, true);
    }

    private static void doHelpBrowserTask(MLHelpBrowserTask mLHelpBrowserTask, UrlDisplayBehavior.Destination destination, boolean bl) {
        Runnable runnable = DocCenterBrowserHandler.getRunnable(mLHelpBrowserTask, destination, bl);
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static Runnable getRunnable(MLHelpBrowserTask mLHelpBrowserTask, UrlDisplayBehavior.Destination destination, boolean bl) {
        UrlDisplayBehavior urlDisplayBehavior = DocCenterBrowserHandler.getUrlDisplayBehavior(mLHelpBrowserTask, destination);
        switch (urlDisplayBehavior.getDestination()) {
            case SYSTEM_BROWSER: {
                return new SystemBrowserRunnable(urlDisplayBehavior.getUrl());
            }
            case NEW_HELP_BROWSER: {
                return new OpenInNewHelpBrowserRunnable(mLHelpBrowserTask, urlDisplayBehavior, bl);
            }
            case CURRENT_HELP_BROWSER: {
                return new OpenInCurrentHelpBrowserRunnable(mLHelpBrowserTask, urlDisplayBehavior);
            }
            case CANCEL: {
                return new Runnable(){

                    @Override
                    public void run() {
                    }
                };
            }
        }
        return new RequestFocusInHelpBrowserRunnable(mLHelpBrowserTask, urlDisplayBehavior);
    }

    private static UrlDisplayBehavior getUrlDisplayBehavior(MLHelpBrowserTask mLHelpBrowserTask, UrlDisplayBehavior.Destination destination) {
        boolean bl;
        Url url;
        Url url2;
        Url url3 = url2 = mLHelpBrowserTask == null ? null : mLHelpBrowserTask.getUrlToDisplay();
        if (url2 == null) {
            url2 = DocCenterDocConfig.getInstance().getDocRoot().buildGlobalLandingPageUrl();
        }
        Url url4 = url = url2.getType() == Url.UrlType.FILE ? DocCenterBrowserHandler.resolveFileUrl((FileUrl)url2) : url2;
        if (url == null) {
            return new UrlDisplayBehavior(url2, UrlDisplayBehavior.Destination.NEW_HELP_BROWSER);
        }
        if (url2.getType() == Url.UrlType.FILE && url.getType() == Url.UrlType.WEB && !(bl = DocCenterBrowserHandler.promptUserOnEDT())) {
            return new UrlDisplayBehavior(url, UrlDisplayBehavior.Destination.CANCEL);
        }
        OpenBrowserUrlDisplayBehaviorFactory openBrowserUrlDisplayBehaviorFactory = new OpenBrowserUrlDisplayBehaviorFactory(HelpPrefs.getDocCenterLocation(), destination);
        UrlDisplayBehavior urlDisplayBehavior = openBrowserUrlDisplayBehaviorFactory.transformUrl(url);
        if (urlDisplayBehavior == null) {
            urlDisplayBehavior = new UrlDisplayBehavior(url2, UrlDisplayBehavior.Destination.NEW_HELP_BROWSER);
        }
        return urlDisplayBehavior;
    }

    private static Url resolveFileUrl(FileUrl fileUrl) {
        DocRoot docRoot;
        try {
            DocCenterDocConfig.getInstance();
            docRoot = DocCenterDocConfig.getSystemBrowserDocUrlBuilder();
        }
        catch (MalformedURLException malformedURLException) {
            return fileUrl;
        }
        InstalledFileUrlResolver installedFileUrlResolver = new InstalledFileUrlResolver((DocConfig<FileUrl>)DocCenterDocConfig.getLocalConfig(), (DocRoot<WebUrl>)docRoot);
        return installedFileUrlResolver.resolveFileUrl(fileUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean promptUserOnEDT() {
        PromptUserCall promptUserCall = new PromptUserCall();
        try {
            AWTUtilities.invokeAndWait((Runnable)promptUserCall);
        }
        finally {
            return promptUserCall.isiOpenLink();
        }
    }

    private static OpenBrowserHandler createOpenInNewBrowserHandler(Url url, boolean bl) {
        return new OpenInNewBrowser(url, bl);
    }

    private static OpenBrowserHandler createOpenInCurrentBrowserHandler(Url url, MLHelpBrowser mLHelpBrowser) {
        if (mLHelpBrowser == null) {
            return new OpenInNewBrowser(url);
        }
        return new OpenInCurrentBrowser(url, mLHelpBrowser);
    }

    private static OpenBrowserHandler createRequestFocusInBrowser(Url url, MLHelpBrowser mLHelpBrowser) {
        if (mLHelpBrowser == null) {
            return new OpenInNewBrowser(url);
        }
        return new RequestFocusInBrowser(mLHelpBrowser);
    }

    @Override
    public void invoke() {
        DocCenterBrowserHandler.doHelpBrowserTask(null);
    }

    @Override
    public void setCurrentLocation(String string) {
        DocCenterBrowserHandler.doHelpBrowserTask(new UrlOnlyTask(string));
    }

    @Override
    public void openInCurrentBrowser(Url url) {
        DocCenterBrowserHandler.doHelpBrowserTask(new UrlOnlyTask(url), UrlDisplayBehavior.Destination.CURRENT_HELP_BROWSER, true);
    }

    @Override
    public void setCurrentLocationAndHighlightKeywords(String string, String[] stringArray) {
        this.setCurrentLocation(string);
    }

    @Override
    public void openInNewBrowser(String string, boolean bl) {
        UrlOnlyTask urlOnlyTask = new UrlOnlyTask(string);
        DocCenterBrowserHandler.doHelpBrowserTask(urlOnlyTask, UrlDisplayBehavior.Destination.NEW_HELP_BROWSER, bl);
    }

    @Override
    public void openInNewBrowser(Url url, boolean bl) {
        UrlOnlyTask urlOnlyTask = new UrlOnlyTask(url);
        DocCenterBrowserHandler.doHelpBrowserTask(urlOnlyTask, UrlDisplayBehavior.Destination.NEW_HELP_BROWSER, bl);
    }

    @Override
    public void showHelpPage(String string, String string2) {
        try {
            DocCenterDocConfig docCenterDocConfig = DocCenterDocConfig.getInstance();
            DocumentationSet documentationSet = docCenterDocConfig.getDocumentationSet();
            DocProduct docProduct = documentationSet.getProductByShortName(string);
            DocRoot docRoot = docCenterDocConfig.getDocRoot();
            Url url = docRoot.buildDocSetItemUrl((DocSetItem)docProduct, string2);
            this.setCurrentLocation(url.toString());
        }
        catch (Exception exception) {
            this.setCurrentLocation(HelpPrefs.getDocCenterRoot() + File.separator + string + File.separator + string2);
        }
    }

    @Override
    public void showHelpPageAndHighlightKeywords(String string, String string2, String[] stringArray) {
        this.showHelpPage(string, string2);
    }

    @Override
    public boolean showProductPage(String string) {
        return this.showHelpPageIfAvailable(string, "index.html");
    }

    private boolean showHelpPageIfAvailable(String string, String string2) {
        DocProduct docProduct;
        DocCenterDocConfig docCenterDocConfig = DocCenterDocConfig.getInstance();
        DocumentationSet documentationSet = docCenterDocConfig.getDocumentationSet();
        if (documentationSet != null && (docProduct = documentationSet.getProductByShortName(string)) != null) {
            Url url = docCenterDocConfig.getDocRoot().buildDocSetItemUrl((DocSetItem)docProduct, string2);
            this.setCurrentLocation(url.toString());
            return true;
        }
        return false;
    }

    @Override
    public boolean showReferencePage(String string, boolean bl) {
        DocCenterDocConfig docCenterDocConfig = DocCenterDocConfig.getInstance();
        DocCommandHelpBrowserTask docCommandHelpBrowserTask = new DocCommandHelpBrowserTask((DocConfig<? extends Url>)docCenterDocConfig);
        if (docCommandHelpBrowserTask.findReferencePages(string, bl)) {
            DocCenterBrowserHandler.doHelpBrowserTask(docCommandHelpBrowserTask);
            return true;
        }
        return false;
    }

    @Override
    public String getCurrentLocation() {
        MLHelpBrowser mLHelpBrowser = MLHelpBrowserActiveTab.getActiveHelpBrowserTab();
        return mLHelpBrowser != null ? mLHelpBrowser.getCurrentLocation() : null;
    }

    @Override
    public void setHtmlText(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MLHelpBrowser mLHelpBrowser = new MLHelpBrowser();
                mLHelpBrowser.showClientText(string);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void setHtmlTextAndHighlightKeywords(String string, String[] stringArray) {
        this.setHtmlText(string);
    }

    @Override
    public String getHtmlText() {
        MLHelpBrowser mLHelpBrowser = MLHelpBrowserActiveTab.getActiveHelpBrowserTab();
        return mLHelpBrowser != null ? mLHelpBrowser.getHtmlText() : null;
    }

    @Override
    public void setDemoText(String string) {
        this.setHtmlText(string);
    }

    @Override
    public void docSearch(String string) {
        if (string == null || string.isEmpty()) {
            this.invoke();
            return;
        }
        String string2 = DocCenterUtils.buildDocCenterSearchUrl((String)string);
        this.setCurrentLocation(string2);
    }

    @Override
    public void showDemos() {
        this.showDemos("", "");
    }

    @Override
    public void showDemos(String string) {
        this.showDemos(string, "");
    }

    @Override
    public void showDemos(String string, String string2) {
        String string3 = DocCenterUtils.getExamplesUrlForDemoCommand((String)string, (String)string2);
        if (string3 == null) {
            this.showClassicOrShowError(string, string2);
        } else {
            this.setCurrentLocation(string3);
        }
    }

    private void showClassicOrShowError(final String string, final String string2) {
        DemosDataListener demosDataListener = new DemosDataListener(){

            public void demosCleared() {
            }

            public void demosPopulated() {
                DemoTreeItem demoTreeItem = DemosData.findProduct((String)string, (String)string2);
                if (demoTreeItem != null) {
                    DocCenterBrowserHandler.this.fClassicHelpBrowserHandler.showDemos(string, string2);
                } else {
                    DocRoot docRoot = DocCenterDocConfig.getLocalConfig().getDocRoot();
                    FileUrl fileUrl = (FileUrl)docRoot.buildGlobalPageUrl("templates/noexample.html");
                    DocCenterBrowserHandler.setCurrentUrl((Url)fileUrl);
                }
                DemosData.removeDemosDataListener((DemosDataListener)this);
            }
        };
        DemosData.addDemosDataListener((DemosDataListener)demosDataListener, (boolean)true);
    }

    private static void setCurrentUrl(Url url) {
        DocCenterBrowserHandler.doHelpBrowserTask(new UrlOnlyTask(url));
    }

    @Override
    public void displayTopic(String string, String string2) {
        CSHelpTopicMap cSHelpTopicMap = new CSHelpTopicMap(string);
        if (cSHelpTopicMap.exists()) {
            String string3 = cSHelpTopicMap.mapID(string2);
            if (string3 != null) {
                this.setCurrentLocation(string3);
            } else {
                this.setHtmlText("<html><body>Topic " + string2 + " in " + cSHelpTopicMap.getFilePath() + " not found.</body></html>");
            }
        } else {
            this.setHtmlText("<html><body>Mapfile not found: " + cSHelpTopicMap.getFilePath() + "</body></html>");
        }
    }

    private static class UrlOnlyTask
    implements MLHelpBrowserTask {
        private final Url iUrl;

        private UrlOnlyTask(Url url) {
            this.iUrl = url;
        }

        private UrlOnlyTask(String string) {
            this(Url.parseSilently((String)string));
        }

        @Override
        public Url getUrlToDisplay() {
            return this.iUrl;
        }

        @Override
        public void updateHelpBrowser(MLHelpBrowser mLHelpBrowser) {
        }

        @Override
        public void cleanup() {
        }
    }

    private static class RequestFocusInBrowser
    implements OpenBrowserHandler {
        private final MLHelpBrowser iHelpBrowser;

        private RequestFocusInBrowser(MLHelpBrowser mLHelpBrowser) {
            this.iHelpBrowser = mLHelpBrowser;
        }

        @Override
        public MLHelpBrowser openBrowser() {
            this.iHelpBrowser.requestFocusInBrowser();
            return this.iHelpBrowser;
        }
    }

    private static class OpenInCurrentBrowser
    implements OpenBrowserHandler {
        private final Url iUrl;
        private final MLHelpBrowser iHelpBrowser;

        private OpenInCurrentBrowser(Url url, MLHelpBrowser mLHelpBrowser) {
            this.iUrl = url;
            this.iHelpBrowser = mLHelpBrowser;
        }

        @Override
        public MLHelpBrowser openBrowser() {
            this.iHelpBrowser.setCurrentLocation(this.iUrl);
            return this.iHelpBrowser;
        }
    }

    private static class OpenInNewBrowser
    implements OpenBrowserHandler {
        private final Url iUrl;
        private final boolean iSelect;

        private OpenInNewBrowser(Url url) {
            this(url, true);
        }

        private OpenInNewBrowser(Url url, boolean bl) {
            this.iUrl = url;
            this.iSelect = bl;
        }

        @Override
        public MLHelpBrowser openBrowser() {
            MLHelpBrowser mLHelpBrowser = new MLHelpBrowser();
            mLHelpBrowser.showClient(this.iUrl, this.iSelect);
            return mLHelpBrowser;
        }
    }

    private static interface OpenBrowserHandler {
        public MLHelpBrowser openBrowser();
    }

    private static class RequestFocusInHelpBrowserRunnable
    extends MLHelpBrowserRunnable {
        private RequestFocusInHelpBrowserRunnable(MLHelpBrowserTask mLHelpBrowserTask, UrlDisplayBehavior urlDisplayBehavior) {
            super(mLHelpBrowserTask, urlDisplayBehavior);
        }

        @Override
        OpenBrowserHandler getBrowserHandler(MLHelpBrowser mLHelpBrowser, Url url, boolean bl) {
            return DocCenterBrowserHandler.createRequestFocusInBrowser(url, mLHelpBrowser);
        }
    }

    private static class OpenInCurrentHelpBrowserRunnable
    extends MLHelpBrowserRunnable {
        private OpenInCurrentHelpBrowserRunnable(MLHelpBrowserTask mLHelpBrowserTask, UrlDisplayBehavior urlDisplayBehavior) {
            super(mLHelpBrowserTask, urlDisplayBehavior);
        }

        @Override
        OpenBrowserHandler getBrowserHandler(MLHelpBrowser mLHelpBrowser, Url url, boolean bl) {
            return DocCenterBrowserHandler.createOpenInCurrentBrowserHandler(url, mLHelpBrowser);
        }
    }

    private static class OpenInNewHelpBrowserRunnable
    extends MLHelpBrowserRunnable {
        private OpenInNewHelpBrowserRunnable(MLHelpBrowserTask mLHelpBrowserTask, UrlDisplayBehavior urlDisplayBehavior, boolean bl) {
            super(mLHelpBrowserTask, urlDisplayBehavior, bl);
        }

        @Override
        OpenBrowserHandler getBrowserHandler(MLHelpBrowser mLHelpBrowser, Url url, boolean bl) {
            return DocCenterBrowserHandler.createOpenInNewBrowserHandler(url, bl);
        }
    }

    private static abstract class MLHelpBrowserRunnable
    implements Runnable {
        private final MLHelpBrowserTask iTask;
        private final Url iUrl;
        private final OpenBrowserHandler iOpenBrowserHandler;

        private MLHelpBrowserRunnable(MLHelpBrowserTask mLHelpBrowserTask, UrlDisplayBehavior urlDisplayBehavior) {
            this(mLHelpBrowserTask, urlDisplayBehavior, true);
        }

        private MLHelpBrowserRunnable(MLHelpBrowserTask mLHelpBrowserTask, UrlDisplayBehavior urlDisplayBehavior, boolean bl) {
            this.iTask = mLHelpBrowserTask;
            this.iUrl = urlDisplayBehavior.getUrl();
            this.iOpenBrowserHandler = this.getBrowserHandler(urlDisplayBehavior.getHelpBrowser(), this.iUrl, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MLHelpBrowser mLHelpBrowser = this.createAndShowBrowser();
            if (this.iTask != null) {
                try {
                    this.iTask.updateHelpBrowser(mLHelpBrowser);
                }
                finally {
                    this.iTask.cleanup();
                }
            }
        }

        private MLHelpBrowser createAndShowBrowser() {
            return this.iOpenBrowserHandler.openBrowser();
        }

        abstract OpenBrowserHandler getBrowserHandler(MLHelpBrowser var1, Url var2, boolean var3);
    }

    private static class SystemBrowserRunnable
    implements Runnable {
        private final Url iUrl;

        private SystemBrowserRunnable(Url url) {
            this.iUrl = url;
        }

        @Override
        public void run() {
            final String string = "web('" + this.iUrl.toString() + "','-browser')";
            Matlab.whenMatlabReady((Runnable)new Runnable(){

                @Override
                public void run() {
                    SystemBrowserRunnable.this.doMatlabEval(string);
                }
            });
        }

        private synchronized void doMatlabEval(String string) {
            new Matlab().evalConsoleOutput(string);
        }
    }

    private static class PromptUserCall
    implements Runnable {
        private boolean iOpenLink = false;

        private PromptUserCall() {
        }

        @Override
        public void run() {
            int n = MJOptionPane.showConfirmDialog(null, (Object)RES.getString("doccenter.view-link-on-web.text"), (String)RES.getString("doccenter.view-link-on-web.title"), (int)0, (int)1);
            this.iOpenLink = n == 0;
        }

        boolean isiOpenLink() {
            return this.iOpenLink;
        }
    }
}

