/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.help.helpui.DocLocation;
import com.mathworks.mde.help.DocCenterSettingChangedEventDispatcher;
import com.mathworks.mde.help.DocCenterSettingListener;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.widgets.ComponentBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.border.Border;

class DocCenterLocationPanel
implements ComponentBuilder {
    private static DocCenterSettingListener sDocCenterSettingListener;
    private final MJPanel fPanel = new MJPanel();
    private final MJRadioButton fWebButton;
    private final MJRadioButton fInstalledButton;
    private String fSelectedLocation;

    DocCenterLocationPanel() {
        this.fPanel.putClientProperty((Object)"mwjavaguitest.instance", (Object)this);
        this.fPanel.setName("DocCenterLocationPanel");
        this.fPanel.setLayout((LayoutManager)new BorderLayout());
        boolean bl = HelpPrefs.getDocCenterLocation() == DocLocation.WEB;
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonActionListener buttonActionListener = new ButtonActionListener();
        this.fInstalledButton = new MJRadioButton(HelpUtils.getLocalizedString((String)"prefs.doc_location.installed"));
        this.fInstalledButton.setName("DocCenterLocationInstalledButton");
        this.fInstalledButton.setSelected(!bl);
        this.fInstalledButton.setActionCommand(DocLocation.INSTALLED.toString().toLowerCase(Locale.ENGLISH));
        this.fInstalledButton.addActionListener((ActionListener)buttonActionListener);
        buttonGroup.add((AbstractButton)this.fInstalledButton);
        this.fWebButton = new MJRadioButton(HelpUtils.getLocalizedString((String)"prefs.doc_location.web"));
        this.fWebButton.setName("DocCenterLocationWebButton");
        this.fWebButton.setSelected(bl);
        this.fWebButton.setActionCommand(DocLocation.WEB.toString().toLowerCase(Locale.ENGLISH));
        this.fWebButton.addActionListener((ActionListener)buttonActionListener);
        buttonGroup.add((AbstractButton)this.fWebButton);
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("2dlu, pref", "pref, pref"));
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.fInstalledButton, cellConstraints.xy(2, 1));
        panelBuilder.add((Component)this.fWebButton, cellConstraints.xy(2, 2));
        panelBuilder.getPanel().getAccessibleContext().setAccessibleName(HelpUtils.getLocalizedString((String)"prefs.doc_location.title"));
        panelBuilder.setBorder((Border)BorderFactory.createTitledBorder(HelpUtils.getLocalizedString((String)"prefs.doc_location.title")));
        this.fPanel.add((Component)panelBuilder.getPanel());
        sDocCenterSettingListener = new DocCenterSettingListener(){

            @Override
            public void docCenterSettingChanged(DocCenterSettingChangedEventDispatcher.DocCenterSettingChangedEvent docCenterSettingChangedEvent) {
                switch (docCenterSettingChangedEvent) {
                    case LOCATION_WEB: {
                        if (!DocCenterLocationPanel.this.fWebButton.isSelected()) {
                            DocCenterLocationPanel.this.fWebButton.setSelected(true);
                        }
                        if (!DocCenterLocationPanel.this.fInstalledButton.isSelected()) break;
                        DocCenterLocationPanel.this.fInstalledButton.setSelected(false);
                        break;
                    }
                    case LOCATION_INSTALLED: {
                        if (DocCenterLocationPanel.this.fWebButton.isSelected()) {
                            DocCenterLocationPanel.this.fWebButton.setSelected(false);
                        }
                        if (DocCenterLocationPanel.this.fInstalledButton.isSelected()) break;
                        DocCenterLocationPanel.this.fInstalledButton.setSelected(true);
                        break;
                    }
                }
            }
        };
        DocCenterSettingChangedEventDispatcher.getInstance().addDocCenterSettingListener(sDocCenterSettingListener);
    }

    public JComponent getComponent() {
        return this.fPanel;
    }

    String getSelectedLocation() {
        return this.fSelectedLocation;
    }

    static void removeListeners() {
        DocCenterSettingChangedEventDispatcher.getInstance().removeDocCenterSettingListener(sDocCenterSettingListener);
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            DocCenterLocationPanel.this.fSelectedLocation = string;
            DocCenterSettingChangedEventDispatcher.getInstance().docCenterLocationChanged(DocCenterLocationPanel.this.fSelectedLocation);
        }
    }
}

