/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.help.helpui.DocLocation;
import com.mathworks.mde.help.DocCenterSettingChangedEventDispatcher;
import com.mathworks.mde.help.DocCenterSettingListener;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mde.help.ProductTablePanel;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.product.util.ProductIdentifier;
import com.mathworks.widgets.ComponentBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

class DocCenterProductsPanel
implements ComponentBuilder {
    private static DocCenterSettingListener sDocCenterSettingListener;
    private final ProductsPanel fPanel;
    private final MJPanel fSelectPanel;
    private final MJButton fSelectAllButton;
    private final MJButton fClearAllButton;
    private final MJCheckBox fShowUninstalledCheckBox;
    private TableModelListener fTableModelListener;
    private ProductTablePanel fProductTablePanel;
    private int fNumTableRows;

    DocCenterProductsPanel() {
        this(10);
    }

    DocCenterProductsPanel(int n) {
        this.fNumTableRows = n;
        this.fPanel = new ProductsPanel();
        this.fPanel.putClientProperty("mwjavaguitest.instance", this);
        this.fPanel.setName("DocCenterProductsPanel");
        this.fPanel.setLayout(new BorderLayout());
        this.fPanel.setBorder(BorderFactory.createTitledBorder(HelpUtils.getLocalizedString((String)"prefs.doc_products.title")));
        this.fPanel.getAccessibleContext().setAccessibleName(HelpUtils.getLocalizedString((String)"prefs.doc_products.title"));
        boolean bl = this.shouldShowUninstalledProducts();
        this.fTableModelListener = this.createTableModelListener();
        this.fProductTablePanel = this.createProductTablePanel(bl, this.fTableModelListener);
        this.fPanel.add(this.fProductTablePanel.getComponent(), "Center");
        CheckBoxActionListener checkBoxActionListener = new CheckBoxActionListener();
        this.fShowUninstalledCheckBox = new MJCheckBox(HelpUtils.getLocalizedString((String)"prefs.doc_products.select_not_installed"));
        this.fShowUninstalledCheckBox.setName("ShowUninstalled");
        this.fShowUninstalledCheckBox.setSelected(bl);
        this.fShowUninstalledCheckBox.addActionListener((ActionListener)checkBoxActionListener);
        this.fShowUninstalledCheckBox.setEnabled(HelpPrefs.getDocCenterLocation() == DocLocation.WEB);
        this.fSelectAllButton = new MJButton(HelpUtils.getLocalizedString((String)"filter.select_all"));
        this.fSelectAllButton.setName("filter.select_all");
        this.fSelectAllButton.setEnabled(!this.fProductTablePanel.isAllSelected());
        this.fSelectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DocCenterProductsPanel.this.fProductTablePanel.selectAll();
            }
        });
        this.fClearAllButton = new MJButton(HelpUtils.getLocalizedString((String)"filter.clear_all"));
        this.fClearAllButton.setName("filter.clear_all");
        this.fClearAllButton.setEnabled(!this.fProductTablePanel.isAllCleared());
        this.fClearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DocCenterProductsPanel.this.fProductTablePanel.clearAll();
            }
        });
        MJPanel mJPanel = new MJPanel();
        mJPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        mJPanel.add((Component)this.fSelectAllButton);
        mJPanel.add((Component)this.fClearAllButton);
        FormLayout formLayout = new FormLayout("2dlu, left:pref, right:pref:grow", "pref");
        this.fSelectPanel = new MJPanel((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.fSelectPanel.add((Component)this.fShowUninstalledCheckBox, (Object)cellConstraints.xy(2, 1));
        this.fSelectPanel.add((Component)mJPanel, (Object)cellConstraints.xywh(3, 1, 1, 1, "r, b"));
        this.fPanel.add((Component)this.fSelectPanel, "South");
        sDocCenterSettingListener = new DocCenterSettingListener(){

            @Override
            public void docCenterSettingChanged(DocCenterSettingChangedEventDispatcher.DocCenterSettingChangedEvent docCenterSettingChangedEvent) {
                switch (docCenterSettingChangedEvent) {
                    case LOCATION_WEB: {
                        DocCenterProductsPanel.this.fShowUninstalledCheckBox.setEnabled(true);
                        if (!DocCenterProductsPanel.this.fShowUninstalledCheckBox.isSelected()) break;
                        DocCenterProductsPanel.this.reloadProductTable(true);
                        break;
                    }
                    case LOCATION_INSTALLED: {
                        DocCenterProductsPanel.this.fShowUninstalledCheckBox.setEnabled(false);
                        if (!DocCenterProductsPanel.this.fShowUninstalledCheckBox.isSelected()) break;
                        DocCenterProductsPanel.this.reloadProductTable(false);
                        break;
                    }
                    case SHOW_UNINSTALLED_PRODUCTS_TRUE: {
                        DocCenterProductsPanel.this.fShowUninstalledCheckBox.setSelected(true);
                        DocCenterProductsPanel.this.reloadProductTable(true);
                        DocCenterProductsPanel.this.fireTableDataChanged();
                        break;
                    }
                    case SHOW_UNINSTALLED_PRODUCTS_FALSE: {
                        DocCenterProductsPanel.this.fShowUninstalledCheckBox.setSelected(false);
                        DocCenterProductsPanel.this.reloadProductTable(false);
                        DocCenterProductsPanel.this.fireTableDataChanged();
                        break;
                    }
                }
            }
        };
        DocCenterSettingChangedEventDispatcher.getInstance().addDocCenterSettingListener(sDocCenterSettingListener);
    }

    private boolean shouldShowUninstalledProducts() {
        return HelpPrefs.getDocCenterLocation() == DocLocation.WEB && HelpPrefs.isShowUninstalledProducts();
    }

    boolean getShowUninstalledProducts() {
        return this.fShowUninstalledCheckBox.isSelected();
    }

    private void reloadProductTable(boolean bl) {
        assert (SwingUtilities.isEventDispatchThread()) : "ProductTable must be loaded on the EDT.";
        this.fProductTablePanel.removeTableModelListener(this.fTableModelListener);
        this.fPanel.remove(this.fProductTablePanel.getComponent());
        this.fTableModelListener = null;
        this.fProductTablePanel = null;
        this.fTableModelListener = this.createTableModelListener();
        this.fProductTablePanel = this.createProductTablePanel(bl, this.fTableModelListener);
        this.fPanel.add(this.fProductTablePanel.getComponent(), "Center");
        this.fPanel.validate();
    }

    private void fireTableDataChanged() {
        this.fProductTablePanel.fireTableDataChanged();
    }

    private TableModelListener createTableModelListener() {
        TableModelHandler tableModelHandler = new TableModelHandler();
        return tableModelHandler;
    }

    private ProductTablePanel createProductTablePanel(boolean bl, TableModelListener tableModelListener) {
        ProductTablePanel productTablePanel = new ProductTablePanel(bl);
        productTablePanel.enableProductTable(true);
        if (productTablePanel.isAllCleared()) {
            productTablePanel.selectAll();
        }
        productTablePanel.addTableModelListener(tableModelListener);
        return productTablePanel;
    }

    public JComponent getComponent() {
        return this.fPanel;
    }

    void resetSelectedProducts() {
        this.fProductTablePanel.resetProducts();
    }

    Set<ProductIdentifier> getSelectedProducts() {
        return this.fProductTablePanel.getSelectedProducts();
    }

    boolean isProductFilterEnabled() {
        return this.fProductTablePanel.isProductFilterEnabled();
    }

    static void removeListeners() {
        DocCenterSettingChangedEventDispatcher.getInstance().removeDocCenterSettingListener(sDocCenterSettingListener);
    }

    private class CheckBoxActionListener
    implements ActionListener {
        private CheckBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DocCenterSettingChangedEventDispatcher.getInstance().docCenterShowUninstalledProductsChanged(DocCenterProductsPanel.this.fShowUninstalledCheckBox.isSelected());
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            DocCenterProductsPanel.this.fSelectAllButton.setEnabled(!DocCenterProductsPanel.this.fProductTablePanel.isAllSelected());
            DocCenterProductsPanel.this.fClearAllButton.setEnabled(!DocCenterProductsPanel.this.fProductTablePanel.isAllCleared());
        }
    }

    private class ProductsPanel
    extends MJPanel {
        private ProductsPanel() {
        }

        public Dimension getPreferredSize() {
            int n = DocCenterProductsPanel.this.fProductTablePanel.getTableRowHeight() * DocCenterProductsPanel.this.fNumTableRows + (int)DocCenterProductsPanel.this.fSelectPanel.getPreferredSize().getHeight() + 20;
            return new Dimension(250, n);
        }
    }
}

