/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.help.helpui.DocConfig;
import com.mathworks.help.helpui.search.index.DocCenterDomAdapter;
import com.mathworks.help.helpui.search.index.DocCenterProductCrawler;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.index.DocumentTracker;
import com.mathworks.helpsearch.index.HtmlToDomAdapter;
import com.mathworks.helpsearch.index.IndexerObserver;
import com.mathworks.helpsearch.index.LocaleFileLocator;
import com.mathworks.helpsearch.index.LocalizedFileLocator;
import com.mathworks.helpsearch.index.report.DocumentReportObserver;
import com.mathworks.helpsearch.index.report.SingleDocumentReport;
import com.mathworks.helpsearch.index.report.SingleDocumentReportBuilder;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.html.BrowserRequest;
import com.mathworks.html.CustomProtocolRequestHandler;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.RequestHandler;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mlwidgets.html.HtmlConversionUtils;
import com.mathworks.mlwidgets.html.MJHtmlPanel;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;

public class DocCrawlerDebugTool
extends DTClientBase {
    private final DocConfig<FileUrl> fConfig = DocCenterDocConfig.getLocalConfig();
    private final TopPanel fTopPanel;
    private final MJComboBox fProductCombo;
    private final MJComboBox fActionCombo;
    private final MJTextField fFileField;
    private final MJCheckBox fWebDocBox;
    private final HtmlComponent fHtmlComponent;

    private DocCrawlerDebugTool() {
        this.setDontReopen(true);
        this.setLayout(new BorderLayout());
        this.fProductCombo = this.buildProductCombo();
        this.fActionCombo = this.buildActionCombo();
        this.fWebDocBox = new MJCheckBox();
        this.fTopPanel = new TopPanel();
        this.fFileField = this.buildFileField();
        this.fHtmlComponent = HtmlComponentFactory.buildHtmlComponent((HtmlComponentFactory.HtmlComponentType[])new HtmlComponentFactory.HtmlComponentType[0]);
        HtmlConversionUtils.visitBrowser((HtmlComponent)this.fHtmlComponent, (HtmlConversionUtils.BrowserVisitor)new HtmlConversionUtils.BrowserVisitor(){

            public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
                mJHtmlPanel.addRequestHandler((RequestHandler)new CrawlActionRequestHandler("parse", CrawlAction.PARSE));
                mJHtmlPanel.addRequestHandler((RequestHandler)new CrawlActionRequestHandler("crawlTo", CrawlAction.CRAWL_TO_PAGE));
            }

            public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
            }
        });
        this.add((Component)((Object)this.fTopPanel), "North");
        this.add(this.fHtmlComponent.getComponent(), "Center");
        this.fHtmlComponent.setHtmlText(DocCrawlerDebugTool.getDescriptionHtml());
        this.validate();
    }

    private MJComboBox buildActionCombo() {
        final MJComboBox mJComboBox = new MJComboBox((Object[])CrawlAction.values());
        mJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = mJComboBox.getSelectedIndex();
                CrawlAction crawlAction = CrawlAction.values()[n];
                if (crawlAction == CrawlAction.CRAWL) {
                    DocCrawlerDebugTool.this.fTopPanel.removeFileField();
                } else {
                    DocCrawlerDebugTool.this.fTopPanel.addFileField();
                }
                DocCrawlerDebugTool.this.fTopPanel.revalidate();
                DocCrawlerDebugTool.this.fTopPanel.repaint();
            }
        });
        return mJComboBox;
    }

    private CrawlAction getSelectedAction() {
        int n = this.fActionCombo.getSelectedIndex();
        return CrawlAction.values()[n];
    }

    private MJComboBox buildProductCombo() {
        DocumentationSet documentationSet = this.fConfig.getDocumentationSet();
        ArrayList<String> arrayList = new ArrayList<String>(documentationSet.getAllProducts().size());
        for (DocProduct docProduct : documentationSet.getAllProducts()) {
            arrayList.add(docProduct.getDisplayName());
        }
        return new MJComboBox(arrayList);
    }

    private MJTextField buildFileField() {
        MJTextField mJTextField = new MJTextField();
        mJTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DocCrawlerDebugTool.this.execute();
            }
        });
        return mJTextField;
    }

    private void execute() {
        int n = this.fProductCombo.getSelectedIndex();
        final DocProduct docProduct = (DocProduct)this.fConfig.getDocumentationSet().getAllProducts().get(n);
        final String string = this.fFileField.getText();
        final CrawlAction crawlAction = this.getSelectedAction();
        this.fHtmlComponent.setHtmlText(crawlAction.getWaitMessage(docProduct, string));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DocCrawlerDebugTool.this.performAction(crawlAction, docProduct, string);
            }
        };
        new Thread(runnable).start();
    }

    private void performAction(CrawlAction crawlAction, DocProduct docProduct, String string) {
        try {
            switch (crawlAction) {
                case CRAWL: {
                    this.crawlDoc(docProduct);
                    return;
                }
                case CRAWL_TO_PAGE: {
                    this.crawlToPage(docProduct, string);
                    return;
                }
                case PARSE: {
                    this.parseDocPage(docProduct, string);
                }
            }
        }
        catch (Exception exception) {
            this.fHtmlComponent.setHtmlText(DocCrawlerDebugTool.buildErrorHtml(docProduct));
        }
    }

    private static String buildErrorHtml(DocProduct docProduct) {
        StringBuilder stringBuilder = new StringBuilder("<html>\n<body>\n");
        stringBuilder.append("<div>Sorry, an error occurred.</div>\n");
        stringBuilder.append("<div>Please be sure the ").append(docProduct.getDisplayName());
        stringBuilder.append(" documentation is available under your docroot.</div>\n");
        stringBuilder.append("</body>\n</html>");
        return stringBuilder.toString();
    }

    private void parseDocPage(DocProduct docProduct, String string) {
        LocaleFileLocator localeFileLocator = new LocaleFileLocator(this.fConfig.getDocumentationSet().getLanguage().getLocale());
        DocCenterDomAdapter docCenterDomAdapter = new DocCenterDomAdapter(this.fWebDocBox.isSelected());
        String string2 = MLHelpServices.getDocRoot();
        DocumentationSet documentationSet = this.fConfig.getDocumentationSet();
        SingleDocumentReportBuilder singleDocumentReportBuilder = new SingleDocumentReportBuilder(string2, documentationSet, (LocalizedFileLocator)localeFileLocator, (HtmlToDomAdapter)docCenterDomAdapter);
        try {
            SingleDocumentReport singleDocumentReport = singleDocumentReportBuilder.buildReport(docProduct, string);
            this.fHtmlComponent.setHtmlText(singleDocumentReport.toHtml());
        }
        catch (Exception exception) {
            StackTraceElement[] stackTraceElementArray;
            StringBuilder stringBuilder = new StringBuilder("<html>\n<body>\n");
            stringBuilder.append("An error occurred while parsing the page: ").append(exception.getMessage());
            stringBuilder.append("\n<pre>");
            for (StackTraceElement stackTraceElement : stackTraceElementArray = exception.getStackTrace()) {
                stringBuilder.append("\n").append(stackTraceElement.toString());
            }
            stringBuilder.append("\n</pre>\n</body>\n</html>");
            this.fHtmlComponent.setHtmlText(stringBuilder.toString());
        }
    }

    private void crawlToPage(DocProduct docProduct, String string) {
        DocumentReportObserver documentReportObserver = new DocumentReportObserver(string);
        this.doCrawl(docProduct, (IndexerObserver<DocumentationSearchField>)documentReportObserver);
        this.fHtmlComponent.setHtmlText(documentReportObserver.toHtml());
    }

    private void crawlDoc(DocProduct docProduct) {
        CrawlDocObserver crawlDocObserver = new CrawlDocObserver(docProduct);
        this.doCrawl(docProduct, crawlDocObserver);
        this.fHtmlComponent.setHtmlText(crawlDocObserver.toHtml());
    }

    private void doCrawl(DocProduct docProduct, IndexerObserver<DocumentationSearchField> indexerObserver) {
        String string = MLHelpServices.getDocRoot();
        boolean bl = this.fWebDocBox.isSelected();
        DocCenterProductCrawler.crawl((File)new File(string), this.fConfig, (DocSetItem)docProduct, (boolean)bl, indexerObserver);
    }

    public static void invoke() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DocCrawlerDebugTool.invokeEdt();
            }
        });
    }

    private void dispose() {
        MLDesktop.getInstance().removeClient((Component)((Object)this));
        this.fHtmlComponent.dispose();
    }

    private static void invokeEdt() {
        final DocCrawlerDebugTool docCrawlerDebugTool = new DocCrawlerDebugTool();
        MLDesktop mLDesktop = MLDesktop.getInstance();
        mLDesktop.addClient((Component)((Object)docCrawlerDebugTool), "Documentation Crawler Tool");
        mLDesktop.addClientListener((Component)((Object)docCrawlerDebugTool), (DTClientListener)new DTClientAdapter(){

            public void clientClosed(DTClientEvent dTClientEvent) {
                docCrawlerDebugTool.dispose();
            }
        });
    }

    private static String getDescriptionHtml() {
        StringBuilder stringBuilder = new StringBuilder("<html>\n<body>\n");
        stringBuilder.append("<div>This tool provides some insight into how our documentation search indexer crawls and parses our documentation.</div>\n");
        stringBuilder.append("<div>To use the tool, select a product and an indexer behavior to inspect. Available choices include:</div>\n<ul>\n");
        stringBuilder.append("<li><b>Crawl</b> (Slow): Crawls the entire documentation for the product, returning a list of pages that would be included and excluded from the index</li>\n");
        stringBuilder.append("<li><b>Crawl to Page</b> (Slow): Crawls the entire documentation for the product and tracks all of the pages that link to the page you specify, then parses that page and returns a summary</li>\n");
        stringBuilder.append("<li><b>Parse</b> (Fast): Parses a specific documentation page and returns a summary, without tracking incoming links.</li>\n");
        stringBuilder.append("</ul>\n");
        stringBuilder.append("<div>When providing a path for the \"Crawl to Page\" and \"Parse\" options, specify a relative path from the product's documentation folder (e.g. ref/plot.html)</div>\n");
        stringBuilder.append("</body>\n</html>");
        return stringBuilder.toString();
    }

    private static class CrawlDocObserver
    implements IndexerObserver<DocumentationSearchField> {
        private final DocProduct iProduct;
        private List<DocumentTracker<DocumentationSearchField>> iIndexed = new LinkedList<DocumentTracker<DocumentationSearchField>>();
        private List<DocumentTracker<DocumentationSearchField>> iUnindexed = new LinkedList<DocumentTracker<DocumentationSearchField>>();

        private CrawlDocObserver(DocProduct docProduct) {
            this.iProduct = docProduct;
        }

        public void indexingStarted() {
        }

        public void startDocument(DocumentTracker<DocumentationSearchField> documentTracker) {
        }

        public void parsedDocument(DocumentTracker<DocumentationSearchField> documentTracker) {
        }

        public void createdIndexDocument(DocumentTracker<DocumentationSearchField> documentTracker) {
        }

        public void endDocument(DocumentTracker<DocumentationSearchField> documentTracker) {
            boolean bl = !documentTracker.getIndexDocuments().isEmpty();
            List<DocumentTracker<DocumentationSearchField>> list = bl ? this.iIndexed : this.iUnindexed;
            list.add(documentTracker);
        }

        public void indexingFinished() {
        }

        private String toHtml() {
            StringBuilder stringBuilder = new StringBuilder("<html>\n<body>\n\n");
            stringBuilder.append("<h1>Crawler Report: ").append(this.iProduct.getDisplayName()).append("</h1>\n");
            stringBuilder.append("<div><a href=\"#indexed\">Indexed ").append(this.iIndexed.size()).append(" documents</a></div>");
            stringBuilder.append("<div><a href=\"#unindexed\">Omitted ").append(this.iUnindexed.size()).append(" documents</a></div>");
            stringBuilder.append("<a name=\"indexed\"/><h2>Indexed Documents(").append(this.iIndexed.size()).append(")</h2>\n");
            stringBuilder.append(CrawlDocObserver.createDocumentsTable(this.iIndexed, false));
            stringBuilder.append("<a name=\"unindexed\"/><h2>Unindexed Documents(").append(this.iUnindexed.size()).append(")</h2>\n");
            stringBuilder.append(CrawlDocObserver.createDocumentsTable(this.iUnindexed, true));
            stringBuilder.append("</body>\n</html>");
            return stringBuilder.toString();
        }

        private static String createDocumentsTable(List<DocumentTracker<DocumentationSearchField>> list, boolean bl) {
            StringBuilder stringBuilder = new StringBuilder("<table>\n");
            for (DocumentTracker<DocumentationSearchField> documentTracker : list) {
                String string = documentTracker.getDocumentationDocument().getRelativePath();
                stringBuilder.append("<tr><td>").append(string).append("</td>");
                if (bl) {
                    stringBuilder.append("<td>").append(documentTracker.getFailureMessage()).append("</td>");
                }
                CustomProtocolUrl customProtocolUrl = new CustomProtocolUrl("crawlTo", string);
                CustomProtocolUrl customProtocolUrl2 = new CustomProtocolUrl("parse", string);
                stringBuilder.append("<td><a href=\"").append(customProtocolUrl).append("\">Crawl To</a></td>");
                stringBuilder.append("<td><a href=\"").append(customProtocolUrl2).append("\">Parse</a>").append("</td></tr>\n");
            }
            stringBuilder.append("</table>\n\n");
            return stringBuilder.toString();
        }
    }

    private class TopPanel
    extends MJPanel {
        private TopPanel() {
            this.setLayout((LayoutManager)new FormLayout("3dlu,p,p,3dlu,p,3dlu,p:grow,3dlu,p,p,5dlu,p,3dlu", "p"));
            CellConstraints cellConstraints = new CellConstraints();
            this.add((Component)new MJLabel("Product: "), cellConstraints.xy(2, 1));
            this.add((Component)DocCrawlerDebugTool.this.fProductCombo, cellConstraints.xy(3, 1));
            this.add((Component)DocCrawlerDebugTool.this.fActionCombo, cellConstraints.xy(5, 1));
            this.add((Component)new MJLabel("Web Doc? "), cellConstraints.xy(9, 1));
            this.add((Component)DocCrawlerDebugTool.this.fWebDocBox, cellConstraints.xy(10, 1));
            MJButton mJButton = new MJButton("Go");
            mJButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DocCrawlerDebugTool.this.execute();
                }
            });
            this.add((Component)mJButton, cellConstraints.xy(12, 1));
        }

        private void addFileField() {
            this.add((Component)DocCrawlerDebugTool.this.fFileField, new CellConstraints().xy(7, 1));
        }

        private void removeFileField() {
            this.remove((Component)DocCrawlerDebugTool.this.fFileField);
        }
    }

    private class CrawlActionRequestHandler
    extends CustomProtocolRequestHandler {
        private final CrawlAction iAction;

        private CrawlActionRequestHandler(String string, CrawlAction crawlAction) {
            super(string, new String[0]);
            this.iAction = crawlAction;
        }

        protected void handleMatchedRequest(BrowserRequest browserRequest, final CustomProtocolUrl customProtocolUrl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CrawlActionRequestHandler.this.doCrawlAction(customProtocolUrl.getCommand());
                }
            });
        }

        private void doCrawlAction(String string) {
            DocCrawlerDebugTool.this.fActionCombo.setSelectedItem((Object)this.iAction);
            DocCrawlerDebugTool.this.fFileField.setText(string.replaceFirst("/$", ""));
            DocCrawlerDebugTool.this.execute();
        }
    }

    private static enum CrawlAction {
        CRAWL("Crawl", "Crawling doc for {0}"),
        CRAWL_TO_PAGE("Crawl to Page", "Crawling to page {1} in doc for {0}"),
        PARSE("Parse Page", "Parsing page {1} in doc for {0}");

        private final String iDisplay;
        private final MessageFormat iWaitMessage;

        private CrawlAction(String string2, String string3) {
            this.iDisplay = string2;
            this.iWaitMessage = new MessageFormat(string3);
        }

        public String toString() {
            return this.iDisplay;
        }

        private String getWaitMessage(DocProduct docProduct, String string) {
            Object[] objectArray = new Object[]{docProduct.getDisplayName(), string};
            return this.iWaitMessage.format(objectArray);
        }
    }
}

