/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.help.helpui.DocLocation;
import com.mathworks.html.Url;
import com.mathworks.jmi.Matlab;
import com.mathworks.mde.help.LinkClickedUrlDisplayBehaviorFactory;
import com.mathworks.mde.help.MLHelpBrowser;
import com.mathworks.mde.help.UrlDisplayBehavior;
import com.mathworks.mlwidgets.help.HelpPanelLinkClickedHandler;
import javax.swing.SwingUtilities;

public abstract class HelpBrowserLinkClickedHandler
extends HelpPanelLinkClickedHandler {
    protected boolean handleLinkClicked(Url url, UrlDisplayBehavior.Destination destination) {
        LinkClickedUrlDisplayBehaviorFactory linkClickedUrlDisplayBehaviorFactory = new LinkClickedUrlDisplayBehaviorFactory(this.getDocLocation(), destination);
        UrlDisplayBehavior urlDisplayBehavior = linkClickedUrlDisplayBehaviorFactory.transformUrl(url);
        switch (urlDisplayBehavior.getDestination()) {
            case SYSTEM_BROWSER: {
                this.openInSystemBrowser(urlDisplayBehavior.getUrl());
                return true;
            }
            case CURRENT_HELP_BROWSER: 
            case NEW_HELP_BROWSER: 
            case REQUEST_FOCUS_IN_HELP_BROWSER: {
                this.openInHelpBrowser(urlDisplayBehavior.getUrl());
                return true;
            }
        }
        return false;
    }

    private void openInSystemBrowser(Url url) {
        final String string = "web('" + url.toString() + "','-browser')";
        Matlab.whenMatlabReady((Runnable)new Runnable(){

            @Override
            public void run() {
                HelpBrowserLinkClickedHandler.this.doMatlabEval(string);
            }
        });
    }

    private synchronized void doMatlabEval(String string) {
        new Matlab().evalConsoleOutput(string);
    }

    private void openInHelpBrowser(final Url url) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelpBrowserLinkClickedHandler.this.getHelpBrowser().setCurrentLocation(url);
            }
        });
    }

    protected abstract MLHelpBrowser getHelpBrowser();

    protected abstract DocLocation getDocLocation();
}

