/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.jmi.Matlab;
import com.mathworks.mde.help.ClearSearchAction;
import com.mathworks.mde.help.Contents;
import com.mathworks.mde.help.HelpBrowser;
import com.mathworks.mde.help.HelpNavigatorAction;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mde.help.Search;
import com.mathworks.mde.help.SearchInputPanel;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.DemoInfoUtils;
import com.mathworks.mlwidgets.help.DemoTreeItem;
import com.mathworks.mlwidgets.help.DemosData;
import com.mathworks.mlwidgets.help.DemosDataListener;
import com.mathworks.mlwidgets.help.DocCenterUtils;
import com.mathworks.mlwidgets.help.HelpInfo;
import com.mathworks.mlwidgets.help.HelpSynchronizer;
import com.mathworks.mlwidgets.help.search.DocSearchEngine;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontListener;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class HelpNavigator
extends MJPanel {
    private static Font sFont = null;
    private static Color sSubPanelBackgroundColor = null;
    private static Color sTextColor = null;
    private SearchInputPanel fInputPanel;
    private Contents fContentsPanel;
    private Search fSearchPanel;
    private boolean fInitialized = false;
    private boolean fShowing = false;
    private Runnable fAfterInitialized = null;
    private DisplayMode fDisplayMode = null;
    private MJTabbedPane fTabPanel;

    public static void main(String[] stringArray) {
        HelpNavigator helpNavigator = new HelpNavigator();
        HelpUtils.placeComponentInFrame(helpNavigator);
    }

    HelpNavigator() {
        Color color = this.chooseTabAreaBackgroundColor();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 2, 2, 2));
        this.setBackground(color);
        this.setName("Help Navigator");
        sFont = FontPrefs.getFontForComponent((String)HelpUtils.getLocalizedString((String)"hb.helpnavigator"));
        sSubPanelBackgroundColor = ColorPrefs.getBackgroundColor();
        sTextColor = ColorPrefs.getTextColor();
        this.addSearchTextField();
        this.fContentsPanel = new Contents();
        ClearSearchAction.init(this);
        this.fSearchPanel = new Search();
        this.fTabPanel = new MJTabbedPane();
        this.fTabPanel.setName("Help Navigator Tab Panel");
        this.fTabPanel.setBackground(color);
        this.fTabPanel.add(HelpUtils.getLocalizedString((String)"hb.tab.contents"), (Component)((Object)this.fContentsPanel));
        this.fTabPanel.add(HelpUtils.getLocalizedString((String)"hb.tab.search"), (Component)((Object)this.fSearchPanel));
        TabChangeListener tabChangeListener = new TabChangeListener();
        this.fTabPanel.addChangeListener((ChangeListener)tabChangeListener);
        this.add((Component)this.fTabPanel, "Center");
    }

    private Color chooseTabAreaBackgroundColor() {
        if (MJUtilities.isHighContrast()) {
            return super.getBackground();
        }
        return new Color(191, 205, 219);
    }

    void populate() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        HelpNavigatorAction.setupKeybindings(this);
        HelpInfo.addHelpInfoChangedListener((ActionListener)new HelpInfoListener());
        this.addPrefsListeners();
        HelpColorListener helpColorListener = new HelpColorListener();
        ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)helpColorListener);
        ColorPrefs.addColorListener((String)"ColorsBackground", (PrefListener)helpColorListener);
        SwingUtilities.invokeLater(new PopulateThread());
    }

    private void addPrefsListeners() {
        HelpPrefsListener helpPrefsListener = new HelpPrefsListener();
        FontPrefs.addTextFontListener((FontListener)helpPrefsListener);
    }

    void reset() {
        this.fContentsPanel.reset();
        this.fSearchPanel.reset();
        this.fInputPanel.setText("");
    }

    void addSearchTextField() {
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new BorderLayout());
        mJPanel.setBackground(this.getBackground());
        this.fInputPanel = new SearchInputPanel(this);
        this.fInputPanel.configureForHelpNavigator();
        mJPanel.add((Component)((Object)this.fInputPanel), (Object)"Center");
        MJButton mJButton = new MJButton((Icon)MiscellaneousIcon.COLLAPSE_CHEVRON.getIcon());
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MLHelpServices.hideNavigator();
            }
        });
        mJButton.setName("HelpCloseNavigatorButton");
        MJToolBar.configureButton((MJButton)mJButton);
        mJButton.setBackground(this.getBackground());
        mJPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        mJPanel.add((Component)mJButton, (Object)"East");
        this.add((Component)mJPanel, "North");
    }

    SearchInputPanel removeSearchTextField() {
        this.remove((Component)((Object)this.fInputPanel));
        return this.fInputPanel;
    }

    private void populateNavigatorPanels(boolean bl) {
        if (!bl) {
            this.fSearchPanel.clear();
        }
        if (DocCenterUtils.hasClassicDoc()) {
            this.fContentsPanel.init();
            if (!DocSearchEngine.isInitialized()) {
                DocSearchEngine.initialize();
            }
            this.fInitialized = true;
            if (this.fAfterInitialized != null) {
                SwingUtilities.invokeLater(this.fAfterInitialized);
                this.fAfterInitialized = null;
            }
        }
    }

    private void setBackgroundColor() {
        sSubPanelBackgroundColor = ColorPrefs.getBackgroundColor();
        this.fContentsPanel.setBackground(sSubPanelBackgroundColor);
        this.fSearchPanel.setBackground(sSubPanelBackgroundColor);
    }

    private void setTextColor() {
        sTextColor = ColorPrefs.getTextColor();
        this.fContentsPanel.setForeground(sTextColor);
        this.fSearchPanel.setForeground(sTextColor);
    }

    static Font getNavigatorFont() {
        return sFont;
    }

    static Color getBackgroundColor() {
        return sSubPanelBackgroundColor;
    }

    static Color getTextColor() {
        return sTextColor;
    }

    public void addNotify() {
        super.addNotify();
        this.fShowing = true;
        if (!this.fInitialized) {
            this.repopulate();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.fShowing = false;
    }

    private void repopulate() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.repopulateTabPanelMethod();
        } else {
            SwingUtilities.invokeLater(new RepopulateTabPanelThread());
        }
    }

    private void repopulateTabPanelMethod() {
        this.populateNavigatorPanels(false);
    }

    void showDemosTab(final String string, final String string2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                HelpNavigator.this.doShowDemosTab(string, string2);
            }
        };
        if (this.fInitialized) {
            runnable.run();
        } else {
            this.fAfterInitialized = runnable;
        }
    }

    private void doShowDemosTab(final String string, final String string2) {
        DemosDataListener demosDataListener = new DemosDataListener(){

            public void demosCleared() {
            }

            public void demosPopulated() {
                DemoTreeItem demoTreeItem = DemosData.findProduct((String)string, (String)string2);
                if (demoTreeItem != null) {
                    HelpNavigator.this.fContentsPanel.selectDemoItem(demoTreeItem);
                } else {
                    HelpBrowser.setCurrentLocation(DemoInfoUtils.getLocalizedDemoFilename((String)(Matlab.matlabRoot() + "/toolbox/matlab/demos/html/nodemo.html")), false);
                }
                DemosData.removeDemosDataListener((DemosDataListener)this);
            }
        };
        DemosData.addDemosDataListener((DemosDataListener)demosDataListener, (boolean)true);
    }

    void docSearch(String string, String[] stringArray) {
        assert (SwingUtilities.isEventDispatchThread()) : "docSearch must be called on the event dispatch thread";
        this.setSearchFieldText(string);
        this.showSearch();
        MLHelpServices.showNavigator();
        this.fSearchPanel.doSearch(string, stringArray);
    }

    public boolean requestFocusInWindow() {
        if (this.fInputPanel != null) {
            return this.fInputPanel.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    private void setSearchFieldText(String string) {
        if (this.fInputPanel != null) {
            this.fInputPanel.setText(string);
        }
    }

    String getSearchFieldText() {
        if (this.fInputPanel != null) {
            return this.fInputPanel.getText();
        }
        return "";
    }

    List<String> getSearchHistory() {
        if (this.fInputPanel != null) {
            return this.fInputPanel.getSearchTextFieldHistory();
        }
        return new ArrayList<String>();
    }

    void setHelpSynchronizer(HelpSynchronizer helpSynchronizer) {
        assert (this.fContentsPanel != null) : "ContentsPanel is null. Cannot set the HelpSynchronizer.";
        assert (helpSynchronizer != null) : "setHelpSynchronizer must be called with non-null HelpSynchronizer.";
        this.fContentsPanel.setHelpSynchronizer(helpSynchronizer);
    }

    DisplayMode getDisplayMode() {
        return this.fDisplayMode;
    }

    private void setDisplayMode(DisplayMode displayMode) {
        this.fDisplayMode = displayMode;
    }

    void showContents() {
        this.fTabPanel.setSelectedComponent((Component)((Object)this.fContentsPanel));
        this.setDisplayMode(DisplayMode.CONTENTS);
        this.fContentsPanel.scrollToSelectedTreeNode();
        this.fContentsPanel.updateGlobalActions();
    }

    void showSearch() {
        this.fTabPanel.setSelectedComponent((Component)((Object)this.fSearchPanel));
        this.setDisplayMode(DisplayMode.SEARCH);
        this.fSearchPanel.updateGlobalActions();
    }

    void clearSearch() {
        this.fSearchPanel.clear();
    }

    void scrollToSelectedContentsTreeNode() {
        if (this.fContentsPanel != null && this.fContentsPanel.isShowing()) {
            this.fContentsPanel.scrollToSelectedTreeNode();
        }
    }

    private class TabChangeListener
    implements ChangeListener {
        private TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (HelpNavigator.this.fTabPanel.getSelectedIndex() == 0) {
                HelpNavigator.this.showContents();
            } else {
                HelpNavigator.this.showSearch();
            }
        }
    }

    private class RepopulateTabPanelThread
    implements Runnable {
        private RepopulateTabPanelThread() {
        }

        @Override
        public void run() {
            HelpNavigator.this.repopulateTabPanelMethod();
        }
    }

    private class HelpInfoListener
    implements ActionListener {
        private HelpInfoListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (HelpNavigator.this.fShowing) {
                HelpNavigator.this.repopulate();
            } else {
                HelpNavigator.this.fInitialized = false;
            }
        }
    }

    private class HelpPrefsListener
    implements PrefListener,
    FontListener {
        private HelpPrefsListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            if (HelpNavigator.this.fShowing) {
                HelpNavigator.this.repopulate();
            } else {
                HelpNavigator.this.fInitialized = false;
            }
        }

        public void fontChanged(Font font) {
            sFont = font;
            HelpNavigator.this.fContentsPanel.setFont(font);
            HelpNavigator.this.fSearchPanel.setFont(font);
        }
    }

    private class HelpColorListener
    implements PrefListener {
        private HelpColorListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getPrefKey().equals("ColorsText")) {
                HelpNavigator.this.setTextColor();
            } else if (prefEvent.getPrefKey().equals("ColorsBackground")) {
                HelpNavigator.this.setBackgroundColor();
            }
        }
    }

    private class PopulateThread
    implements Runnable {
        private PopulateThread() {
        }

        @Override
        public void run() {
            HelpNavigator.this.populateNavigatorPanels(true);
            HelpNavigator.this.setCursor(Cursor.getDefaultCursor());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HelpNavigator.this.requestFocusInWindow();
                }
            });
        }
    }

    public static enum DisplayMode {
        CONTENTS,
        SEARCH;

    }
}

