/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.help.helpui.DocConfig;
import com.mathworks.help.helpui.DocPage;
import com.mathworks.help.helpui.DocRoot;
import com.mathworks.help.helpui.DocUrlNavigationRuleHandler;
import com.mathworks.help.helpui.DocUrlType;
import com.mathworks.html.FileUrl;
import com.mathworks.html.Url;
import com.mathworks.html.WebUrl;
import com.mathworks.mlwidgets.help.ClassicDocConversionDocUrlRule;
import java.util.ArrayList;

public class InstalledFileUrlResolver {
    private final DocConfig<FileUrl> fLocalDocConfig;
    private final DocRoot<WebUrl> fSystemBrowserDocUrlBuilder;
    private final DocUrlNavigationRuleHandler fRuleHandler;

    public InstalledFileUrlResolver(DocConfig<FileUrl> docConfig, DocRoot<WebUrl> docRoot) {
        this.fLocalDocConfig = docConfig;
        this.fSystemBrowserDocUrlBuilder = docRoot;
        ArrayList<ClassicDocConversionDocUrlRule> arrayList = new ArrayList<ClassicDocConversionDocUrlRule>();
        arrayList.add(new ClassicDocConversionDocUrlRule());
        this.fRuleHandler = new DocUrlNavigationRuleHandler(arrayList);
    }

    public Url resolveFileUrl(FileUrl fileUrl) {
        if (this.fileUrlExists(fileUrl)) {
            return fileUrl;
        }
        DocPage docPage = this.getDocPage(fileUrl = this.convertClassicDocPath(fileUrl));
        if (docPage != null) {
            if (docPage.getDocSetItem() != null) {
                return this.fLocalDocConfig.getDocRoot().buildDocSetItemUrl(docPage.getDocSetItem(), docPage.getRelativeUrl());
            }
            FileUrl fileUrl2 = (FileUrl)this.fLocalDocConfig.getDocRoot().buildGlobalPageUrl(docPage.getRelativeUrl());
            if (this.fileUrlExists(fileUrl2)) {
                return fileUrl2;
            }
            return this.buildSystemBrowserUrl(docPage);
        }
        return null;
    }

    protected boolean fileUrlExists(FileUrl fileUrl) {
        return fileUrl.getFile().exists();
    }

    protected DocPage getDocPage(FileUrl fileUrl) {
        return this.fLocalDocConfig.getDocUrlParser().resolve((Url)fileUrl);
    }

    protected Url buildSystemBrowserUrl(DocPage docPage) {
        return this.fSystemBrowserDocUrlBuilder.buildDocPageUrl(docPage);
    }

    protected FileUrl convertClassicDocPath(FileUrl fileUrl) {
        Url url = this.fRuleHandler.applyRules(fileUrl.toUrlBuilder(), this.getDocUrlTypeForUrl((Url)fileUrl));
        return (FileUrl)url;
    }

    private DocUrlType getDocUrlTypeForUrl(Url url) {
        return this.fLocalDocConfig.getDocRoot().getDocUrlType(url);
    }
}

