/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help.search;

import com.mathworks.mde.help.search.HelpBrowserSearchResult;
import com.mathworks.mde.help.search.HighlightProvider;
import com.mathworks.mde.help.search.SearchResultCell;
import com.mathworks.mde.help.search.SearchResultCellColors;
import com.mathworks.mde.help.search.SearchResultsList;
import com.mathworks.mlwidgets.help.search.SearchCriteria;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;

class SearchResultListCellRenderer
implements ListCellRenderer {
    private static final Color SELECTED_ROW_BACKGROUND_COLOR = new Color(231, 231, 247);
    private HighlightProvider fHighlightProvider;

    SearchResultListCellRenderer(SearchCriteria searchCriteria) {
        this.fHighlightProvider = new HighlightProvider(searchCriteria);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        HelpBrowserSearchResult helpBrowserSearchResult = (HelpBrowserSearchResult)object;
        SearchResultCell searchResultCell = new SearchResultCell(helpBrowserSearchResult, this.fHighlightProvider);
        searchResultCell.setOpaque(true);
        searchResultCell.setForeground(jList.getForeground());
        searchResultCell.setBackground(bl ? SELECTED_ROW_BACKGROUND_COLOR : jList.getBackground());
        searchResultCell.setFont(jList.getFont());
        JComponent jComponent = searchResultCell.getComponent();
        boolean bl3 = bl2;
        if (!bl3 && jList instanceof SearchResultsList) {
            bl3 = ((SearchResultsList)((Object)jList)).listHasFocus();
        }
        jComponent.setBorder(new SearchResultBorder(bl && bl3));
        return jComponent;
    }

    private static class SearchResultBorder
    implements Border {
        private final boolean iFocusedAndSelected;

        private SearchResultBorder(boolean bl) {
            this.iFocusedAndSelected = bl;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (this.iFocusedAndSelected) {
                graphics.setColor(SearchResultCellColors.getProdSectForeground());
                graphics.drawRect(n, n2, n3 - 1, n4 - 2);
            }
            graphics.setColor(Color.GRAY);
            graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 2, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

