/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.licensing.borrowing.view;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.mathworks.mde.licensing.borrowing.controller.BorrowController;
import com.mathworks.mde.licensing.borrowing.view.CloseActionListener;
import com.mathworks.mde.licensing.borrowing.view.HelpActionListener;
import com.mathworks.mde.licensing.borrowing.view.MainView;
import com.mathworks.mde.licensing.borrowing.view.StatusView;
import com.mathworks.mde.licensing.borrowing.view.SubPanelView;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class MainViewImpl
implements MainView {
    private MJFrame mainUIFrame;
    private MJRadioButton autoBorrowButton;
    private MJRadioButton borrowFeatureButton;
    private MJRadioButton returnFeatureButton;
    private MJRadioButton dummyOptionsButton;
    private MJPanel borrowOptionsPanel;
    private MJPanel statusOptionsPanel;
    private MJPanel dataPanel = new MJPanel();
    private MJPanel statusDataPanel = new MJPanel();
    private MJMultilineLabel autoBorrowDesc;
    private MJMultilineLabel borrowDesc;
    private MJMultilineLabel returnDesc;
    private JTabbedPane tabbedPanel;
    private BorrowController borrowController;
    private ResourceBundle fResBundle;
    private CloseActionListener closeListener;
    private HelpActionListener helpListener;
    public static final String MAINDIALOG_DIALOG_NAME = "MainDialog";
    public static final String AUTOBORROW_RADIOBUTTON_NAME = "AutoBorrowRadioButton";
    public static final String AUTOBORROWDESC_MULTILINELABEL_NAME = "AutoBorrowDescMultilineLabel";
    public static final String BORROWFEATURE_RADIOBUTTON_NAME = "BorrowFeatureRadioButton";
    public static final String BORROWDESC_MULTILINELABEL_NAME = "BorrowDescMultilineLabel";
    public static final String RETURNFEATURE_RADIOBUTTON_NAME = "ReturnFeatureRadioButton";
    public static final String RETURNDESC_MULTILINELABEL_NAME = "ReturnDescMultilineLabel";
    public static final String CLOSE_BUTTON_NAME = "CloseButton";
    public static final String HELP_BUTTON_NAME = "HelpButton";
    public static final String STATUS_MULTILINELABEL_NAME = "StatusMultilineLabel";
    public static final String BORROWOPTIONS_PANEL_NAME = "BorrowOptionsPanel";
    public static final String STATUSOPTIONS_PANEL_NAME = "StatusOptionsPanel";
    public static final String TABBEDPANEL_TABBEDPANE_NAME = "TabbedPanel";
    public static final String DUMMY_RADIOBUTTON_NAME = "DummyRadioButton";
    public static final String TARGET_PANEL_NAME = "TagetPanel";
    private JPanel fMainPanel;
    private ActionListener radioListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.isSelected() && abstractButton.getActionCommand().equals("autoBorrow")) {
                MainViewImpl.this.borrowController.setAutoBorrowSelected();
            }
            if (abstractButton.isSelected() && abstractButton.getActionCommand().equals("byName")) {
                MainViewImpl.this.borrowController.setBorrowProductSelected();
            }
            if (abstractButton.isSelected() && abstractButton.getActionCommand().equals("return")) {
                MainViewImpl.this.borrowController.setReturnProductSelected();
            }
        }
    };
    private ChangeListener tabChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            int n = jTabbedPane.getSelectedIndex();
            if (n == 1) {
                MainViewImpl.this.borrowController.setStatusViewSelection();
            }
        }
    };

    public MainViewImpl(BorrowController borrowController, ResourceBundle resourceBundle) {
        this.borrowController = borrowController;
        this.fResBundle = resourceBundle;
        this.closeListener = new CloseActionListener(borrowController);
        this.helpListener = new HelpActionListener(borrowController);
        this.createTabbedPanel();
    }

    private void createTabbedPanel() {
        this.mainUIFrame = new MJFrame(this.fResBundle.getString("main.title"));
        this.mainUIFrame.setName(MAINDIALOG_DIALOG_NAME);
        this.mainUIFrame.setDefaultCloseOperation(2);
        this.mainUIFrame.setResizable(true);
        this.mainUIFrame.setFocusCycleRoot(true);
        this.buildBorrowOptionsPanel();
        this.buildStatusOptionsPanel();
        Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.borrowOptionsPanel.setBorder(border);
        this.borrowOptionsPanel.setName(BORROWOPTIONS_PANEL_NAME);
        this.statusOptionsPanel.setBorder(border);
        this.statusOptionsPanel.setName(STATUSOPTIONS_PANEL_NAME);
        this.tabbedPanel = new JTabbedPane();
        this.tabbedPanel.setName(TABBEDPANEL_TABBEDPANE_NAME);
        Sizes.dialogUnitXAsPixel((int)10, (Component)this.tabbedPanel);
        Sizes.dialogUnitYAsPixel((int)15, (Component)this.tabbedPanel);
        String string = this.fResBundle.getString("main.tab1.title");
        this.tabbedPanel.addTab(string, null, (Component)this.borrowOptionsPanel);
        String string2 = this.fResBundle.getString("main.tab2.title");
        this.tabbedPanel.addTab(string2, null, (Component)this.statusOptionsPanel);
        this.tabbedPanel.addChangeListener(this.tabChangeListener);
        this.tabbedPanel.setMnemonicAt(0, 66);
        this.tabbedPanel.setMnemonicAt(1, 83);
        JScrollPane jScrollPane = new JScrollPane(this.tabbedPanel);
        jScrollPane.setBorder(null);
        jScrollPane.setWheelScrollingEnabled(true);
        this.mainUIFrame.add((Component)jScrollPane, (Object)"Center");
        this.mainUIFrame.add((Component)this.createHelpClosePanel(), (Object)"South");
        this.mainUIFrame.setPreferredSize(new Dimension(625, 650));
        this.mainUIFrame.pack();
        this.mainUIFrame.setLocationRelativeTo(null);
    }

    private void buildBorrowOptionsPanel() {
        ColumnSpec[] columnSpecArray = new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.PREFERRED, 1.0)};
        RowSpec[] rowSpecArray = new RowSpec[]{new RowSpec(RowSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.dluY((int)2)), new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.dluY((int)12)), new RowSpec(RowSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.dluY((int)2)), new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.dluY((int)12)), new RowSpec(RowSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.dluY((int)2)), new RowSpec(RowSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.dluY((int)20)), new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 1.0)};
        FormLayout formLayout = new FormLayout(columnSpecArray, rowSpecArray);
        int n = MJUtilities.getRadioButtonIndent();
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(0, n, 0, 0);
        this.borrowOptionsPanel = new MJPanel((LayoutManager)formLayout);
        this.createRadioButtons();
        CellConstraints cellConstraints = new CellConstraints();
        cellConstraints.insets = insets;
        CellConstraints cellConstraints2 = new CellConstraints();
        cellConstraints2.insets = insets2;
        this.borrowOptionsPanel.add((Component)this.autoBorrowButton, (Object)cellConstraints.xy(1, 1));
        this.borrowOptionsPanel.add((Component)this.autoBorrowDesc, (Object)cellConstraints2.xy(1, 3));
        this.borrowOptionsPanel.add((Component)this.borrowFeatureButton, (Object)cellConstraints.xy(1, 5));
        this.borrowOptionsPanel.add((Component)this.borrowDesc, (Object)cellConstraints2.xy(1, 7));
        this.borrowOptionsPanel.add((Component)this.returnFeatureButton, (Object)cellConstraints.xy(1, 9));
        this.borrowOptionsPanel.add((Component)this.returnDesc, (Object)cellConstraints2.xy(1, 11));
        this.borrowOptionsPanel.add((Component)this.dataPanel, (Object)cellConstraints.xy(1, 13));
    }

    private void createRadioButtons() {
        ButtonGroup buttonGroup = new ButtonGroup();
        String string = this.fResBundle.getString("main.tab1.rb1");
        this.autoBorrowButton = new MJRadioButton(string);
        this.autoBorrowButton.setName(AUTOBORROW_RADIOBUTTON_NAME);
        this.autoBorrowButton.setActionCommand("autoBorrow");
        this.autoBorrowButton.addActionListener(this.radioListener);
        String string2 = this.fResBundle.getString("main.tab1.rb1desc");
        this.autoBorrowDesc = new MJMultilineLabel(string2, true);
        this.autoBorrowDesc.setName(AUTOBORROWDESC_MULTILINELABEL_NAME);
        String string3 = this.fResBundle.getString("main.tab1.rb2");
        this.borrowFeatureButton = new MJRadioButton(string3);
        this.borrowFeatureButton.setName(BORROWFEATURE_RADIOBUTTON_NAME);
        this.borrowFeatureButton.setActionCommand("byName");
        this.borrowFeatureButton.addActionListener(this.radioListener);
        String string4 = this.fResBundle.getString("main.tab1.rb2desc");
        this.borrowDesc = new MJMultilineLabel(string4, true);
        this.borrowDesc.setName(BORROWDESC_MULTILINELABEL_NAME);
        String string5 = this.fResBundle.getString("main.tab1.rb3");
        this.returnFeatureButton = new MJRadioButton(string5);
        this.returnFeatureButton.setName(RETURNFEATURE_RADIOBUTTON_NAME);
        this.returnFeatureButton.setActionCommand("return");
        this.returnFeatureButton.addActionListener(this.radioListener);
        String string6 = this.fResBundle.getString("main.tab1.rb3desc");
        this.returnDesc = new MJMultilineLabel(string6, true);
        this.returnDesc.setName(RETURNDESC_MULTILINELABEL_NAME);
        this.dummyOptionsButton = new MJRadioButton();
        this.dummyOptionsButton.setName(DUMMY_RADIOBUTTON_NAME);
        this.dummyOptionsButton.setVisible(false);
        buttonGroup.add((AbstractButton)this.autoBorrowButton);
        buttonGroup.add((AbstractButton)this.borrowFeatureButton);
        buttonGroup.add((AbstractButton)this.returnFeatureButton);
        buttonGroup.add((AbstractButton)this.dummyOptionsButton);
    }

    private void buildStatusOptionsPanel() {
        ColumnSpec[] columnSpecArray = new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.PREFERRED, 1.0)};
        RowSpec[] rowSpecArray = new RowSpec[]{new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.dluY((int)4)), new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.dluY((int)20)), new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 1.0)};
        FormLayout formLayout = new FormLayout(columnSpecArray, rowSpecArray);
        this.statusOptionsPanel = new MJPanel((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        MJMultilineLabel mJMultilineLabel = new MJMultilineLabel();
        mJMultilineLabel.setName(STATUS_MULTILINELABEL_NAME);
        mJMultilineLabel.setText(this.fResBundle.getString("statusview.line1"));
        this.statusOptionsPanel.add((Component)mJMultilineLabel, (Object)cellConstraints.xy(1, 3));
        this.statusOptionsPanel.add((Component)this.statusDataPanel, (Object)cellConstraints.xy(1, 5));
    }

    @Override
    public void createSubPanel(SubPanelView subPanelView) {
        ColumnSpec[] columnSpecArray = new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.PREFERRED, 1.0)};
        RowSpec[] rowSpecArray = new RowSpec[]{new RowSpec(RowSpec.TOP, (Size)Sizes.PREFERRED, 1.0)};
        MJPanel mJPanel = subPanelView instanceof StatusView ? this.statusDataPanel : this.dataPanel;
        mJPanel.setName(TARGET_PANEL_NAME);
        mJPanel.removeAll();
        mJPanel.setLayout((LayoutManager)new FormLayout(columnSpecArray, rowSpecArray));
        CellConstraints cellConstraints = new CellConstraints();
        mJPanel.add((Component)subPanelView.createSubPanelView(), cellConstraints.xy(1, 1));
        mJPanel.revalidate();
        mJPanel.repaint();
        this.mainUIFrame.repaint();
    }

    private JPanel createHelpClosePanel() {
        MJButton mJButton = new MJButton(this.fResBundle.getString("button.help"));
        mJButton.setName(HELP_BUTTON_NAME);
        mJButton.addActionListener((ActionListener)this.helpListener);
        mJButton.setActionCommand("HELP");
        mJButton.setMnemonic(72);
        MJButton mJButton2 = new MJButton(this.fResBundle.getString("button.close"));
        mJButton2.setName(CLOSE_BUTTON_NAME);
        mJButton2.addActionListener((ActionListener)this.closeListener);
        mJButton2.setActionCommand("CLOSE");
        mJButton2.setMnemonic(67);
        JPanel jPanel = ButtonBarFactory.buildCloseHelpBar((JButton)mJButton2, (JButton)mJButton);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return jPanel;
    }

    @Override
    public void showMessageDialog(String string, String string2) {
        Integer n = 79;
        UIManager.put("OptionPane.okButtonMnemonic", n.toString());
        JOptionPane jOptionPane = new JOptionPane(string, -1, -1, null);
        JDialog jDialog = jOptionPane.createDialog((Component)this.mainUIFrame, string2);
        jDialog.setResizable(true);
        JScrollPane jScrollPane = new JScrollPane(jOptionPane);
        jScrollPane.setBorder(null);
        jDialog.setContentPane(jScrollPane);
        jDialog.pack();
        jDialog.setModal(false);
        jDialog.setVisible(true);
    }

    @Override
    public void closeDialog() {
        this.mainUIFrame.setVisible(false);
    }

    @Override
    public void showInitialView() {
        this.autoBorrowButton.setEnabled(true);
        this.autoBorrowButton.setSelected(false);
        this.borrowFeatureButton.setEnabled(true);
        this.borrowFeatureButton.setSelected(false);
        this.returnFeatureButton.setSelected(false);
        this.dummyOptionsButton.setSelected(true);
        this.dataPanel.removeAll();
        this.borrowOptionsPanel.revalidate();
        this.borrowOptionsPanel.repaint();
        this.borrowController.updateRadioButtonStatus();
        this.tabbedPanel.setSelectedIndex(0);
        this.mainUIFrame.validate();
        this.mainUIFrame.setVisible(true);
    }

    @Override
    public void showAutoModeOnView() {
        this.tabbedPanel.setSelectedIndex(0);
        this.mainUIFrame.setVisible(true);
        this.autoBorrowButton.setSelected(true);
    }

    @Override
    public void enableReturnRadioButton() {
        this.returnFeatureButton.setEnabled(true);
        this.returnFeatureButton.setSelected(false);
        this.returnDesc.setEnabled(true);
    }

    @Override
    public void disableReturnRadioButton() {
        this.returnFeatureButton.setSelected(false);
        this.returnFeatureButton.setEnabled(false);
        this.returnDesc.setEnabled(false);
    }

    @Override
    public void enableAutoBorrowRadioButton() {
        this.autoBorrowButton.setEnabled(true);
        this.autoBorrowDesc.setEnabled(true);
    }

    @Override
    public void disableAutoBorrowRadioButton() {
        this.autoBorrowButton.setEnabled(false);
        this.autoBorrowDesc.setEnabled(false);
    }

    @Override
    public void enableBorrowFeatureRadioButton() {
        this.borrowFeatureButton.setEnabled(true);
        this.borrowDesc.setEnabled(true);
    }

    @Override
    public void disableBorrowFeatureRadioButton() {
        this.borrowFeatureButton.setEnabled(false);
        this.borrowDesc.setEnabled(false);
    }

    @Override
    public JFrame getMainUIFrame() {
        return this.mainUIFrame;
    }
}

