/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.licensing.borrowing.view;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import com.mathworks.mde.licensing.borrowing.model.Feature;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.ResourceBundle;

public class StatusTableFormat
implements AdvancedTableFormat<Feature> {
    private ResourceBundle fResBundle;

    public StatusTableFormat(ResourceBundle resourceBundle) {
        this.fResBundle = resourceBundle;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return this.fResBundle.getString("table.col.productname");
            }
            case 1: {
                return this.fResBundle.getString("table.col.inuse");
            }
            case 2: {
                return this.fResBundle.getString("table.col.borrowstatus");
            }
            case 3: {
                return this.fResBundle.getString("table.col.returndate");
            }
        }
        throw new IllegalStateException();
    }

    public Object getColumnValue(Feature feature, int n) {
        switch (n) {
            case 0: {
                return feature.getProductName();
            }
            case 1: {
                if (feature.isLicenseInUse()) {
                    return this.fResBundle.getString("table.col.inuse.value");
                }
                return "";
            }
            case 2: {
                return feature.getCurrentFeatureStatus();
            }
            case 3: {
                return this.formatDateString(feature.getReturnDate());
            }
        }
        throw new IllegalStateException();
    }

    private String formatDateString(String string) {
        String string2 = "";
        if (string.equals("")) {
            return string;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
            Date date = simpleDateFormat.parse(string);
            DateFormat dateFormat = DateFormat.getDateInstance(2);
            string2 = dateFormat.format(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return string2;
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    public Comparator getColumnComparator(int n) {
        return GlazedLists.comparableComparator();
    }
}

