/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.richeditor;

import com.mathworks.jmi.MLFileUtils;
import com.mathworks.matlab.api.explorer.ActionConfiguration;
import com.mathworks.matlab.api.explorer.ActionDefinition;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mde.richeditor.RichEditorApplication;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.explorer.model.actions.CoreMenuSection;
import com.mathworks.services.mlx.MlxFileUtils;
import com.mathworks.util.Predicate;
import java.awt.Component;
import java.util.ResourceBundle;

public class OpenAsRichCodeActionProvider
implements ActionProvider {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mde.richeditor.resources.RES_RichEditor");
    private static final ActionDefinition OPEN_AS_RICH_CODE = new ActionDefinition("openAsRichCode", CoreMenuSection.OPEN.getSection(), BUNDLE.getString("OpenAsRichCode.MenuItem.Label"));

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return fileSystemEntry != null && !fileSystemEntry.isFolder() && MLFileUtils.isMFile((String)fileSystemEntry.getLocation().toString());
    }

    public void configureActions(ActionRegistry actionRegistry) {
        actionRegistry.setActionPosition(actionRegistry.getAction(CoreActionID.OPEN).getDefinition(), OPEN_AS_RICH_CODE);
        ActionConfiguration actionConfiguration = actionRegistry.defineAction(OPEN_AS_RICH_CODE);
        actionConfiguration.setCode(SelectionMode.EXPLICIT_SINGLE_FILE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                FileSystemEntry fileSystemEntry = (FileSystemEntry)actionInput.getSelection().get(0);
                RichEditorApplication.openAsRichCode((Component)MatlabDesktopServices.getDesktop().getMainFrame(), fileSystemEntry.getLocation().toFile());
                return Status.COMPLETED;
            }
        });
        actionConfiguration.setVisibleOnContextMenu((Predicate)new Predicate<ActionInput>(){

            public boolean accept(ActionInput actionInput) {
                return MlxFileUtils.isRichScriptEnabled();
            }
        });
    }
}

