/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.richeditor;

import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.mde.richeditor.widget.rtc.RichDocument;
import com.mathworks.services.mlx.MlxFile;
import com.mathworks.services.mlx.MlxFileUtils;
import com.mathworks.util.ThreadUtils;
import com.mathworks.widgets.datamodel.AbstractBackingStore;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.datamodel.FutureFileStorageLocation;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class RichDocumentBackingStore
extends AbstractBackingStore<RichDocument> {
    private static final String DOCUMENT = "document";
    private static final String OUTPUT = "output";
    private File fFile;
    private StorageLocation fStorageLocation;

    public static RichDocumentBackingStore createWithNoBackingFile() {
        return new RichDocumentBackingStore(null);
    }

    public static RichDocumentBackingStore createWithExistentBackingFile(File file) {
        return new RichDocumentBackingStore(file);
    }

    private RichDocumentBackingStore(File file) {
        this.setFile(file);
    }

    void setFile(File file) {
        this.fFile = file;
        this.fStorageLocation = file == null ? new FutureFileStorageLocation() : new FileStorageLocation(this.fFile);
    }

    public File getFile() {
        return this.fFile;
    }

    public void doLoad(RichDocument richDocument) throws IOException {
        if (this.fFile != null && this.fFile.exists()) {
            MlxFile mlxFile = MlxFileUtils.read((File)this.fFile);
            richDocument.setContent(RichDocumentBackingStore.convertToMap(mlxFile));
        }
    }

    protected static Map<String, Object> convertToMap(MlxFile mlxFile) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(DOCUMENT, mlxFile.getDocument());
        String string = mlxFile.getOutput();
        if (string != null) {
            hashMap.put(OUTPUT, string);
        }
        return hashMap;
    }

    protected boolean doNegotiateSave(RichDocument richDocument, Component component) throws Exception {
        assert (false) : "Unexcepted call to this method.";
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doSave(RichDocument richDocument) throws IOException, ExecutionException, InterruptedException {
        ExecutorService executorService = ThreadUtils.newSingleDaemonThreadExecutor((String)"richDocument");
        Future<Map<String, Object>> future = executorService.submit(RichDocumentBackingStore.createGetContentCallable(richDocument));
        try {
            Map<String, Object> map = future.get();
            MlxFile mlxFile = new MlxFile((String)map.get(DOCUMENT), (String)map.get(OUTPUT));
            MlxFileUtils.write((File)this.fFile, (MlxFile)mlxFile);
        }
        finally {
            executorService.shutdown();
        }
        return true;
    }

    public StorageLocation getStorageLocation() {
        return this.fStorageLocation;
    }

    public boolean isPersistenceLocationSet() {
        return this.fFile != null;
    }

    public boolean isReadOnly() {
        return RichDocumentBackingStore.isReadOnly(this.fFile);
    }

    public String getPreferredContentType(String string) {
        assert (false) : "Unexcepted call to this method.";
        return null;
    }

    protected boolean doNegotiateSaveAs(RichDocument richDocument, Component component) throws Exception {
        assert (false) : "Unexcepted call to this method.";
        return false;
    }

    protected AbstractBackingStore.BackupResult doNegotiateBackup(RichDocument richDocument, Component component) throws Exception {
        assert (false) : "Unexcepted call to this method.";
        return null;
    }

    public boolean isOutOfSync() {
        assert (false) : "Unexcepted call to this method.";
        return false;
    }

    public void sync() {
        assert (false) : "Unexcepted call to this method.";
    }

    private static boolean isReadOnly(File file) {
        return file.exists() && !file.canWrite();
    }

    private static Callable<Map<String, Object>> createGetContentCallable(final RichDocument richDocument) {
        return new Callable<Map<String, Object>>(){

            @Override
            public Map<String, Object> call() {
                return richDocument.getContent();
            }
        };
    }
}

