/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.richeditor.widget.rtc;

import com.mathworks.mde.richeditor.widget.rtc.ConnectorFactory;
import com.mathworks.peermodel.PeerModelManager;
import com.mathworks.peermodel.PeerModelManagers;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import com.mathworks.peermodel.events.PeerModelEvent;
import com.mathworks.peermodel.events.PeerModelListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class ActionDataService {
    private String fNamespace;
    private Observer fPropertySetObserver;
    private Observer fChildAddedObserver;
    private Observer fChildDestroyedObserver;
    private List<ActionDataServiceListener> fActionDataServiceListeners;
    private PeerModelManager fPeerModelManager;
    private static final String PROPERTY_SET_EVENT = "propertySet";
    private static final String CHILD_ADDED_EVENT = "childAdded";
    private static final String CHILD_DESTROYED_EVENT = "childDestroyed";
    private static final String ACTION_ID_PROPERTY = "id";
    private static final String PROPERTY_EVENT_DATA = "key";
    private static final String OLD_VALUE_EVENT_DATA = "oldValue";
    private static final String NEW_VALUE_EVENT_DATA = "newValue";
    private static final String CHILD_EVENT_DATA = "child";

    public ActionDataService(final String string) {
        assert (string != null && !string.isEmpty()) : "Namespace must be non-empty string.";
        this.fNamespace = string;
        this.fActionDataServiceListeners = new ArrayList<ActionDataServiceListener>();
        ConnectorFactory.runWhenReady(new Runnable(){

            @Override
            public void run() {
                ActionDataService.this.setupPeerModelManager(PeerModelManagers.getClientInstance((String)string));
            }
        });
    }

    public ActionDataService(String string, PeerModelManager peerModelManager) {
        this.fNamespace = string;
        this.fActionDataServiceListeners = new ArrayList<ActionDataServiceListener>();
        this.setupPeerModelManager(peerModelManager);
    }

    public void addActionDataServiceListener(ActionDataServiceListener actionDataServiceListener) {
        this.fActionDataServiceListeners.add(actionDataServiceListener);
    }

    public void removeActionDataServiceListener(ActionDataServiceListener actionDataServiceListener) {
        this.fActionDataServiceListeners.remove(actionDataServiceListener);
    }

    public Map<String, Object> getProperties(String string) {
        Collection collection = this.fPeerModelManager.getByProperty(ACTION_ID_PROPERTY, (Object)string);
        if (collection == null || collection.size() == 0) {
            return Collections.unmodifiableMap(new HashMap());
        }
        assert (collection.size() == 1) : "There should be only one action with the id " + string;
        PeerNode[] peerNodeArray = collection.toArray(new PeerNode[collection.size()]);
        return peerNodeArray[0].getProperties() != null ? Collections.unmodifiableMap(peerNodeArray[0].getProperties()) : null;
    }

    private void handleChildAdded(PeerNode peerNode) {
        peerNode.addEventListener(PROPERTY_SET_EVENT, this.fPropertySetObserver);
        peerNode.addEventListener(CHILD_ADDED_EVENT, this.fChildAddedObserver);
        peerNode.addEventListener(CHILD_DESTROYED_EVENT, this.fChildDestroyedObserver);
    }

    private void handleChildDestroyed(PeerNode peerNode) {
        peerNode.removeEventListener(PROPERTY_SET_EVENT, this.fPropertySetObserver);
        peerNode.removeEventListener(CHILD_ADDED_EVENT, this.fChildAddedObserver);
        peerNode.removeEventListener(CHILD_DESTROYED_EVENT, this.fChildDestroyedObserver);
    }

    private void handlePropertySet(PeerNode peerNode, Map<String, Object> map) {
        String string = (String)peerNode.getProperty(ACTION_ID_PROPERTY);
        String string2 = (String)map.get(PROPERTY_EVENT_DATA);
        Object object = map.get(OLD_VALUE_EVENT_DATA);
        Object object2 = map.get(NEW_VALUE_EVENT_DATA);
        final ActionChangeEvent actionChangeEvent = new ActionChangeEvent(string, peerNode, string2, object, object2);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (ActionDataServiceListener actionDataServiceListener : ActionDataService.this.fActionDataServiceListeners) {
                    actionDataServiceListener.onActionChange(actionChangeEvent);
                }
            }
        });
    }

    private void setupPeerModelManager(PeerModelManager peerModelManager) {
        this.fPeerModelManager = peerModelManager;
        this.fPropertySetObserver = new Observer(){

            public void handle(Event event) {
                PeerNode peerNode = event.getTarget();
                ActionDataService.this.handlePropertySet(peerNode, event.getData());
            }
        };
        this.fChildAddedObserver = new Observer(){

            public void handle(Event event) {
                PeerNode peerNode = (PeerNode)event.getData().get(ActionDataService.CHILD_EVENT_DATA);
                ActionDataService.this.handleChildAdded(peerNode);
                ActionDataService.this.onChildAdded(peerNode);
            }
        };
        this.fChildDestroyedObserver = new Observer(){

            public void handle(Event event) {
                PeerNode peerNode = (PeerNode)event.getData().get(ActionDataService.CHILD_EVENT_DATA);
                ActionDataService.this.handleChildDestroyed(peerNode);
                ActionDataService.this.onChildDestroyed(peerNode);
            }
        };
        this.fPeerModelManager.addPeerModelListener(new PeerModelListener(){

            public void rootSet(PeerModelEvent peerModelEvent) {
                PeerNode peerNode = (PeerNode)peerModelEvent.getSource();
                ActionDataService.this.handleChildAdded(peerNode);
            }

            public void rootUnset(PeerModelEvent peerModelEvent) {
                PeerNode peerNode = (PeerNode)peerModelEvent.getSource();
                ActionDataService.this.handleChildDestroyed(peerNode);
            }

            public void syncChanged(PeerModelEvent peerModelEvent) {
            }

            public void childMoved(PeerModelEvent peerModelEvent) {
            }
        });
        this.fPeerModelManager.setSyncEnabled(true);
    }

    private void onChildAdded(PeerNode peerNode) {
        final String string = (String)peerNode.getProperty(ACTION_ID_PROPERTY);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (ActionDataServiceListener actionDataServiceListener : ActionDataService.this.fActionDataServiceListeners) {
                    actionDataServiceListener.onActionAdded(string);
                }
            }
        });
    }

    private void onChildDestroyed(PeerNode peerNode) {
        final String string = (String)peerNode.getProperty(ACTION_ID_PROPERTY);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (ActionDataServiceListener actionDataServiceListener : ActionDataService.this.fActionDataServiceListeners) {
                    actionDataServiceListener.onActionDeleted(string);
                }
            }
        });
    }

    public void dispose() {
        PeerModelManagers.cleanup((String)this.fNamespace);
    }

    public static class ActionChangeEvent
    extends PropertyChangeEvent {
        private final String fActionID;

        public ActionChangeEvent(String string, Object object, String string2, Object object2, Object object3) {
            super(object, string2, object2, object3);
            this.fActionID = string;
        }

        public String getActionID() {
            return this.fActionID;
        }
    }

    public static interface ActionDataServiceListener {
        public void onActionChange(ActionChangeEvent var1);

        public void onActionAdded(String var1);

        public void onActionDeleted(String var1);
    }
}

